/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqual;

public final class LessThanOrEqualIntsEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final EvalOperator.ExpressionEvaluator lhs;
    private final EvalOperator.ExpressionEvaluator rhs;
    private final DriverContext driverContext;

    public LessThanOrEqualIntsEvaluator(EvalOperator.ExpressionEvaluator lhs, EvalOperator.ExpressionEvaluator rhs, DriverContext driverContext) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.driverContext = driverContext;
    }

    public Block.Ref eval(Page page) {
        try (Block.Ref lhsRef = this.lhs.eval(page);){
            Block.Ref ref;
            block26: {
                IntVector rhsVector;
                IntVector lhsVector;
                Block.Ref rhsRef;
                block24: {
                    Block.Ref ref2;
                    block25: {
                        IntBlock rhsBlock;
                        IntBlock lhsBlock;
                        block22: {
                            Block.Ref ref3;
                            block23: {
                                block20: {
                                    Block.Ref ref4;
                                    block21: {
                                        if (lhsRef.block().areAllValuesNull()) {
                                            Block.Ref ref5 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            return ref5;
                                        }
                                        lhsBlock = (IntBlock)lhsRef.block();
                                        rhsRef = this.rhs.eval(page);
                                        try {
                                            if (!rhsRef.block().areAllValuesNull()) break block20;
                                            ref4 = Block.Ref.floating((Block)Block.constantNullBlock((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                                            if (rhsRef == null) break block21;
                                        }
                                        catch (Throwable throwable) {
                                            if (rhsRef != null) {
                                                try {
                                                    rhsRef.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        rhsRef.close();
                                    }
                                    return ref4;
                                }
                                rhsBlock = (IntBlock)rhsRef.block();
                                lhsVector = lhsBlock.asVector();
                                if (lhsVector != null) break block22;
                                ref3 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), lhsBlock, rhsBlock));
                                if (rhsRef == null) break block23;
                                rhsRef.close();
                            }
                            return ref3;
                        }
                        rhsVector = rhsBlock.asVector();
                        if (rhsVector != null) break block24;
                        ref2 = Block.Ref.floating((Block)this.eval(page.getPositionCount(), lhsBlock, rhsBlock));
                        if (rhsRef == null) break block25;
                        rhsRef.close();
                    }
                    return ref2;
                }
                ref = Block.Ref.floating((Block)this.eval(page.getPositionCount(), lhsVector, rhsVector).asBlock());
                if (rhsRef == null) break block26;
                rhsRef.close();
            }
            return ref;
        }
    }

    public BooleanBlock eval(int positionCount, IntBlock lhsBlock, IntBlock rhsBlock) {
        try (BooleanBlock.Builder result = BooleanBlock.newBlockBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                if (lhsBlock.isNull(p) || lhsBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                if (rhsBlock.isNull(p) || rhsBlock.getValueCount(p) != 1) {
                    result.appendNull();
                    continue;
                }
                result.appendBoolean(LessThanOrEqual.processInts(lhsBlock.getInt(lhsBlock.getFirstValueIndex(p)), rhsBlock.getInt(rhsBlock.getFirstValueIndex(p))));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, IntVector lhsVector, IntVector rhsVector) {
        try (BooleanVector.Builder result = BooleanVector.newVectorBuilder((int)positionCount, (BlockFactory)this.driverContext.blockFactory());){
            for (int p = 0; p < positionCount; ++p) {
                result.appendBoolean(LessThanOrEqual.processInts(lhsVector.getInt(p), rhsVector.getInt(p)));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "LessThanOrEqualIntsEvaluator[lhs=" + this.lhs + ", rhs=" + this.rhs + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.lhs, this.rhs});
    }
}

