/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison;

import org.elasticsearch.common.TriFunction;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.evaluator.EvalMapper;
import org.elasticsearch.xpack.esql.evaluator.mapper.ExpressionMapper;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EqualsBoolsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EqualsDoublesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EqualsIntsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EqualsKeywordsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EqualsLongsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanDoublesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanIntsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanKeywordsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanLongsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanOrEqualDoublesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanOrEqualIntsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanOrEqualKeywordsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanOrEqualLongsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanDoublesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanIntsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanKeywordsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanLongsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqualDoublesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqualIntsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqualKeywordsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqualLongsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEqualsBoolsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEqualsDoublesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEqualsIntsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEqualsKeywordsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEqualsLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.planner.Layout;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeRegistry;
import org.elasticsearch.xpack.ql.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public abstract class ComparisonMapper<T extends BinaryComparison>
extends ExpressionMapper<T> {
    public static final ExpressionMapper<?> EQUALS = new ComparisonMapper<Equals>(EqualsIntsEvaluator::new, EqualsLongsEvaluator::new, EqualsDoublesEvaluator::new, EqualsKeywordsEvaluator::new, EqualsBoolsEvaluator::new){};
    public static final ExpressionMapper<?> NOT_EQUALS = new ComparisonMapper<NotEquals>(NotEqualsIntsEvaluator::new, NotEqualsLongsEvaluator::new, NotEqualsDoublesEvaluator::new, NotEqualsKeywordsEvaluator::new, NotEqualsBoolsEvaluator::new){};
    public static final ExpressionMapper<?> GREATER_THAN = new ComparisonMapper<GreaterThan>(GreaterThanIntsEvaluator::new, GreaterThanLongsEvaluator::new, GreaterThanDoublesEvaluator::new, GreaterThanKeywordsEvaluator::new){};
    public static final ExpressionMapper<?> GREATER_THAN_OR_EQUAL = new ComparisonMapper<GreaterThanOrEqual>(GreaterThanOrEqualIntsEvaluator::new, GreaterThanOrEqualLongsEvaluator::new, GreaterThanOrEqualDoublesEvaluator::new, GreaterThanOrEqualKeywordsEvaluator::new){};
    public static final ExpressionMapper<?> LESS_THAN = new ComparisonMapper<LessThan>(LessThanIntsEvaluator::new, LessThanLongsEvaluator::new, LessThanDoublesEvaluator::new, LessThanKeywordsEvaluator::new){};
    public static final ExpressionMapper<?> LESS_THAN_OR_EQUAL = new ComparisonMapper<LessThanOrEqual>(LessThanOrEqualIntsEvaluator::new, LessThanOrEqualLongsEvaluator::new, LessThanOrEqualDoublesEvaluator::new, LessThanOrEqualKeywordsEvaluator::new){};
    private final TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator> ints;
    private final TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator> longs;
    private final TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator> doubles;
    private final TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator> keywords;
    private final TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator> bools;

    private ComparisonMapper(TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator> ints, TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator> longs, TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator> doubles, TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator> keywords, TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator> bools) {
        this.ints = ints;
        this.longs = longs;
        this.doubles = doubles;
        this.keywords = keywords;
        this.bools = bools;
    }

    ComparisonMapper(TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator> ints, TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator> longs, TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator> doubles, TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator> keywords) {
        this.ints = ints;
        this.longs = longs;
        this.doubles = doubles;
        this.keywords = keywords;
        this.bools = (lhs, rhs, dvrCtx) -> {
            throw EsqlIllegalArgumentException.illegalDataType(DataTypes.BOOLEAN);
        };
    }

    @Override
    public final EvalOperator.ExpressionEvaluator.Factory map(BinaryComparison bc, Layout layout) {
        DataType leftType = bc.left().dataType();
        if (leftType.isNumeric()) {
            DataType type = EsqlDataTypeRegistry.INSTANCE.commonType(leftType, bc.right().dataType());
            if (type == DataTypes.INTEGER) {
                return ComparisonMapper.castToEvaluator(bc, layout, DataTypes.INTEGER, this.ints);
            }
            if (type == DataTypes.LONG) {
                return ComparisonMapper.castToEvaluator(bc, layout, DataTypes.LONG, this.longs);
            }
            if (type == DataTypes.DOUBLE) {
                return ComparisonMapper.castToEvaluator(bc, layout, DataTypes.DOUBLE, this.doubles);
            }
            if (type == DataTypes.UNSIGNED_LONG) {
                return ComparisonMapper.castToEvaluator(bc, layout, DataTypes.UNSIGNED_LONG, this.longs);
            }
        }
        EvalOperator.ExpressionEvaluator.Factory leftEval = EvalMapper.toEvaluator(bc.left(), layout);
        EvalOperator.ExpressionEvaluator.Factory rightEval = EvalMapper.toEvaluator(bc.right(), layout);
        if (leftType == DataTypes.KEYWORD || leftType == DataTypes.TEXT || leftType == DataTypes.IP || leftType == DataTypes.VERSION) {
            return dvrCtx -> (EvalOperator.ExpressionEvaluator)this.keywords.apply((Object)leftEval.get(dvrCtx), (Object)rightEval.get(dvrCtx), (Object)dvrCtx);
        }
        if (leftType == DataTypes.BOOLEAN) {
            return dvrCtx -> (EvalOperator.ExpressionEvaluator)this.bools.apply((Object)leftEval.get(dvrCtx), (Object)rightEval.get(dvrCtx), (Object)dvrCtx);
        }
        if (leftType == DataTypes.DATETIME) {
            return dvrCtx -> (EvalOperator.ExpressionEvaluator)this.longs.apply((Object)leftEval.get(dvrCtx), (Object)rightEval.get(dvrCtx), (Object)dvrCtx);
        }
        throw new EsqlIllegalArgumentException("resolved type for [" + bc + "] but didn't implement mapping");
    }

    public static EvalOperator.ExpressionEvaluator.Factory castToEvaluator(BinaryOperator<?, ?, ?, ?> op, Layout layout, DataType required, TriFunction<EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, DriverContext, EvalOperator.ExpressionEvaluator> buildEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory lhs = Cast.cast(op.left().dataType(), required, EvalMapper.toEvaluator(op.left(), layout));
        EvalOperator.ExpressionEvaluator.Factory rhs = Cast.cast(op.right().dataType(), required, EvalMapper.toEvaluator(op.right(), layout));
        return dvrCtx -> (EvalOperator.ExpressionEvaluator)buildEvaluator.apply((Object)lhs.get(dvrCtx), (Object)rhs.get(dvrCtx), (Object)dvrCtx);
    }

    public static EvalOperator.ExpressionEvaluator.Factory castToEvaluatorWithSource(BinaryOperator<?, ?, ?, ?> op, Layout layout, DataType required, TriFunction<Source, EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator, EvalOperator.ExpressionEvaluator> buildEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory lhs = Cast.cast(op.left().dataType(), required, EvalMapper.toEvaluator(op.left(), layout));
        EvalOperator.ExpressionEvaluator.Factory rhs = Cast.cast(op.right().dataType(), required, EvalMapper.toEvaluator(op.right(), layout));
        return dvrCtx -> (EvalOperator.ExpressionEvaluator)buildEvaluator.apply((Object)op.source(), (Object)lhs.get(dvrCtx), (Object)rhs.get(dvrCtx));
    }
}

