/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.ColumnExtractOperator;
import org.elasticsearch.grok.FloatConsumer;
import org.elasticsearch.grok.Grok;
import org.elasticsearch.grok.GrokCaptureConfig;
import org.elasticsearch.grok.GrokCaptureExtracter;
import org.joni.Region;

public class GrokEvaluatorExtracter
implements ColumnExtractOperator.Evaluator,
GrokCaptureExtracter {
    private final Grok parser;
    private final String pattern;
    private final List<GrokCaptureExtracter> fieldExtracters;
    private final boolean[] valuesSet;
    private final Object[] firstValues;
    private final ElementType[] positionToType;
    private Block.Builder[] blocks;

    public GrokEvaluatorExtracter(Grok parser, String pattern, Map<String, Integer> keyToBlock, Map<String, ElementType> types) {
        this.parser = parser;
        this.pattern = pattern;
        this.valuesSet = new boolean[types.size()];
        this.firstValues = new Object[types.size()];
        this.positionToType = new ElementType[types.size()];
        this.fieldExtracters = new ArrayList<GrokCaptureExtracter>(parser.captureConfig().size());
        for (GrokCaptureConfig config : parser.captureConfig()) {
            String key = config.name();
            ElementType type = types.get(key);
            final Integer blockIdx = keyToBlock.get(key);
            this.positionToType[blockIdx.intValue()] = type;
            this.fieldExtracters.add((GrokCaptureExtracter)config.nativeExtracter((GrokCaptureConfig.NativeExtracterMap)new GrokCaptureConfig.NativeExtracterMap<GrokCaptureExtracter>(){

                public GrokCaptureExtracter forString(Function<Consumer<String>, GrokCaptureExtracter> buildExtracter) {
                    return buildExtracter.apply(value -> {
                        if (GrokEvaluatorExtracter.this.firstValues[blockIdx] == null) {
                            GrokEvaluatorExtracter.this.firstValues[blockIdx2.intValue()] = value;
                        } else {
                            BytesRefBlock.Builder block = (BytesRefBlock.Builder)GrokEvaluatorExtracter.this.blocks()[blockIdx];
                            if (!GrokEvaluatorExtracter.this.valuesSet[blockIdx]) {
                                block.beginPositionEntry();
                                block.appendBytesRef(new BytesRef((CharSequence)((String)GrokEvaluatorExtracter.this.firstValues[blockIdx])));
                                GrokEvaluatorExtracter.this.valuesSet[blockIdx2.intValue()] = true;
                            }
                            block.appendBytesRef(new BytesRef((CharSequence)value));
                        }
                    });
                }

                public GrokCaptureExtracter forInt(Function<IntConsumer, GrokCaptureExtracter> buildExtracter) {
                    return buildExtracter.apply(value -> {
                        if (GrokEvaluatorExtracter.this.firstValues[blockIdx] == null) {
                            GrokEvaluatorExtracter.this.firstValues[blockIdx2.intValue()] = value;
                        } else {
                            IntBlock.Builder block = (IntBlock.Builder)GrokEvaluatorExtracter.this.blocks()[blockIdx];
                            if (!GrokEvaluatorExtracter.this.valuesSet[blockIdx]) {
                                block.beginPositionEntry();
                                block.appendInt(((Integer)GrokEvaluatorExtracter.this.firstValues[blockIdx]).intValue());
                                GrokEvaluatorExtracter.this.valuesSet[blockIdx2.intValue()] = true;
                            }
                            block.appendInt(value);
                        }
                    });
                }

                public GrokCaptureExtracter forLong(Function<LongConsumer, GrokCaptureExtracter> buildExtracter) {
                    return buildExtracter.apply(value -> {
                        if (GrokEvaluatorExtracter.this.firstValues[blockIdx] == null) {
                            GrokEvaluatorExtracter.this.firstValues[blockIdx2.intValue()] = value;
                        } else {
                            LongBlock.Builder block = (LongBlock.Builder)GrokEvaluatorExtracter.this.blocks()[blockIdx];
                            if (!GrokEvaluatorExtracter.this.valuesSet[blockIdx]) {
                                block.beginPositionEntry();
                                block.appendLong(((Long)GrokEvaluatorExtracter.this.firstValues[blockIdx]).longValue());
                                GrokEvaluatorExtracter.this.valuesSet[blockIdx2.intValue()] = true;
                            }
                            block.appendLong(value);
                        }
                    });
                }

                public GrokCaptureExtracter forFloat(Function<FloatConsumer, GrokCaptureExtracter> buildExtracter) {
                    return buildExtracter.apply(value -> {
                        if (GrokEvaluatorExtracter.this.firstValues[blockIdx] == null) {
                            GrokEvaluatorExtracter.this.firstValues[blockIdx2.intValue()] = Float.valueOf(value);
                        } else {
                            DoubleBlock.Builder block = (DoubleBlock.Builder)GrokEvaluatorExtracter.this.blocks()[blockIdx];
                            if (!GrokEvaluatorExtracter.this.valuesSet[blockIdx]) {
                                block.beginPositionEntry();
                                block.appendDouble(((Float)GrokEvaluatorExtracter.this.firstValues[blockIdx]).doubleValue());
                                GrokEvaluatorExtracter.this.valuesSet[blockIdx2.intValue()] = true;
                            }
                            block.appendDouble((double)value);
                        }
                    });
                }

                public GrokCaptureExtracter forDouble(Function<DoubleConsumer, GrokCaptureExtracter> buildExtracter) {
                    return buildExtracter.apply(value -> {
                        if (GrokEvaluatorExtracter.this.firstValues[blockIdx] == null) {
                            GrokEvaluatorExtracter.this.firstValues[blockIdx2.intValue()] = value;
                        } else {
                            DoubleBlock.Builder block = (DoubleBlock.Builder)GrokEvaluatorExtracter.this.blocks()[blockIdx];
                            if (!GrokEvaluatorExtracter.this.valuesSet[blockIdx]) {
                                block.beginPositionEntry();
                                block.appendDouble(((Double)GrokEvaluatorExtracter.this.firstValues[blockIdx]).doubleValue());
                                GrokEvaluatorExtracter.this.valuesSet[blockIdx2.intValue()] = true;
                            }
                            block.appendDouble(value);
                        }
                    });
                }

                public GrokCaptureExtracter forBoolean(Function<Consumer<Boolean>, GrokCaptureExtracter> buildExtracter) {
                    return buildExtracter.apply(value -> {
                        if (GrokEvaluatorExtracter.this.firstValues[blockIdx] == null) {
                            GrokEvaluatorExtracter.this.firstValues[blockIdx2.intValue()] = value;
                        } else {
                            BooleanBlock.Builder block = (BooleanBlock.Builder)GrokEvaluatorExtracter.this.blocks()[blockIdx];
                            if (!GrokEvaluatorExtracter.this.valuesSet[blockIdx]) {
                                block.beginPositionEntry();
                                block.appendBoolean(((Boolean)GrokEvaluatorExtracter.this.firstValues[blockIdx]).booleanValue());
                                GrokEvaluatorExtracter.this.valuesSet[blockIdx2.intValue()] = true;
                            }
                            block.appendBoolean(value.booleanValue());
                        }
                    });
                }
            }));
        }
    }

    private static void append(Object value, Block.Builder block, ElementType type) {
        if (value instanceof Float) {
            Float f = (Float)value;
            ((DoubleBlock.Builder)block).appendDouble(f.doubleValue());
        } else {
            BlockUtils.appendValue((Block.Builder)block, (Object)value, (ElementType)type);
        }
    }

    public Block.Builder[] blocks() {
        return this.blocks;
    }

    public void computeRow(BytesRefBlock inputBlock, int row, Block.Builder[] blocks, BytesRef spare) {
        this.blocks = blocks;
        int position = inputBlock.getFirstValueIndex(row);
        int valueCount = inputBlock.getValueCount(row);
        Arrays.fill(this.valuesSet, false);
        Arrays.fill(this.firstValues, null);
        for (int c = 0; c < valueCount; ++c) {
            BytesRef input = inputBlock.getBytesRef(position + c, spare);
            this.parser.match(input.bytes, input.offset, input.length, (GrokCaptureExtracter)this);
        }
        for (int i = 0; i < this.firstValues.length; ++i) {
            if (this.firstValues[i] == null) {
                this.blocks[i].appendNull();
                continue;
            }
            if (this.valuesSet[i]) {
                this.blocks[i].endPositionEntry();
                continue;
            }
            GrokEvaluatorExtracter.append(this.firstValues[i], blocks[i], this.positionToType[i]);
        }
    }

    public void extract(byte[] utf8Bytes, int offset, Region region) {
        this.fieldExtracters.forEach(extracter -> extracter.extract(utf8Bytes, offset, region));
    }

    public String toString() {
        return "GrokEvaluatorExtracter[pattern=" + this.pattern + "]";
    }
}

