/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator;

import java.util.List;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.evaluator.mapper.ExpressionMapper;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.ComparisonMapper;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.InMapper;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.logical.NotEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.regex.RegexMapper;
import org.elasticsearch.xpack.esql.planner.Layout;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogicProcessor;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNull;

public final class EvalMapper {
    private static final List<ExpressionMapper<?>> MAPPERS = List.of(ComparisonMapper.EQUALS, ComparisonMapper.NOT_EQUALS, ComparisonMapper.GREATER_THAN, ComparisonMapper.GREATER_THAN_OR_EQUAL, ComparisonMapper.LESS_THAN, ComparisonMapper.LESS_THAN_OR_EQUAL, InMapper.IN_MAPPER, RegexMapper.REGEX_MATCH, new BooleanLogic(), new Nots(), new Attributes(), new Literals(), new IsNotNulls(), new IsNulls());

    private EvalMapper() {
    }

    public static EvalOperator.ExpressionEvaluator.Factory toEvaluator(Expression exp, Layout layout) {
        if (exp instanceof EvaluatorMapper) {
            EvaluatorMapper m = (EvaluatorMapper)exp;
            return m.toEvaluator(e -> EvalMapper.toEvaluator(e, layout));
        }
        for (ExpressionMapper<?> em : MAPPERS) {
            if (!em.typeToken.isInstance(exp)) continue;
            return em.map(exp, layout);
        }
        throw new QlIllegalArgumentException("Unsupported expression [{}]", new Object[]{exp});
    }

    static class BooleanLogic
    extends ExpressionMapper<BinaryLogic> {
        BooleanLogic() {
        }

        @Override
        public EvalOperator.ExpressionEvaluator.Factory map(BinaryLogic bc, Layout layout) {
            EvalOperator.ExpressionEvaluator.Factory leftEval = EvalMapper.toEvaluator(bc.left(), layout);
            EvalOperator.ExpressionEvaluator.Factory rightEval = EvalMapper.toEvaluator(bc.right(), layout);
            return driverContext -> {
                record BooleanLogicExpressionEvaluator(BinaryLogic bl, EvalOperator.ExpressionEvaluator leftEval, EvalOperator.ExpressionEvaluator rightEval) implements EvalOperator.ExpressionEvaluator
                {
                    public Block.Ref eval(Page page) {
                        try (Block.Ref lhs = this.leftEval.eval(page);){
                            Block.Ref ref;
                            block16: {
                                Block.Ref rhs;
                                block14: {
                                    Block.Ref ref2;
                                    block15: {
                                        rhs = this.rightEval.eval(page);
                                        try {
                                            Vector lhsVector = lhs.block().asVector();
                                            Vector rhsVector = rhs.block().asVector();
                                            if (lhsVector == null || rhsVector == null) break block14;
                                            ref2 = Block.Ref.floating((Block)this.eval((BooleanVector)lhsVector, (BooleanVector)rhsVector));
                                            if (rhs == null) break block15;
                                        }
                                        catch (Throwable throwable) {
                                            if (rhs != null) {
                                                try {
                                                    rhs.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        rhs.close();
                                    }
                                    return ref2;
                                }
                                ref = Block.Ref.floating((Block)this.eval(lhs.block(), rhs.block()));
                                if (rhs == null) break block16;
                                rhs.close();
                            }
                            return ref;
                        }
                    }

                    private Block eval(Block lhs, Block rhs) {
                        int positionCount = lhs.getPositionCount();
                        try (BooleanBlock.Builder result = BooleanBlock.newBlockBuilder((int)positionCount, (BlockFactory)lhs.blockFactory());){
                            for (int p = 0; p < positionCount; ++p) {
                                if (lhs.getValueCount(p) > 1) {
                                    result.appendNull();
                                    continue;
                                }
                                if (rhs.getValueCount(p) > 1) {
                                    result.appendNull();
                                    continue;
                                }
                                Boolean v = ((BinaryLogicProcessor.BinaryLogicOperation)this.bl.function()).apply(lhs.isNull(p) ? null : Boolean.valueOf(((BooleanBlock)lhs).getBoolean(lhs.getFirstValueIndex(p))), rhs.isNull(p) ? null : Boolean.valueOf(((BooleanBlock)rhs).getBoolean(rhs.getFirstValueIndex(p))));
                                if (v == null) {
                                    result.appendNull();
                                    continue;
                                }
                                result.appendBoolean(v.booleanValue());
                            }
                            BooleanBlock booleanBlock = result.build();
                            return booleanBlock;
                        }
                    }

                    private Block eval(BooleanVector lhs, BooleanVector rhs) {
                        int positionCount = lhs.getPositionCount();
                        try (BooleanVector.FixedBuilder result = BooleanVector.newVectorFixedBuilder((int)positionCount, (BlockFactory)lhs.blockFactory());){
                            for (int p = 0; p < positionCount; ++p) {
                                result.appendBoolean(((BinaryLogicProcessor.BinaryLogicOperation)this.bl.function()).apply(Boolean.valueOf(lhs.getBoolean(p)), Boolean.valueOf(rhs.getBoolean(p))).booleanValue());
                            }
                            BooleanBlock booleanBlock = result.build().asBlock();
                            return booleanBlock;
                        }
                    }

                    public void close() {
                        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.leftEval, this.rightEval});
                    }
                }
                return new BooleanLogicExpressionEvaluator(bc, leftEval.get(driverContext), rightEval.get(driverContext));
            };
        }
    }

    static class Nots
    extends ExpressionMapper<Not> {
        Nots() {
        }

        @Override
        public EvalOperator.ExpressionEvaluator.Factory map(Not not, Layout layout) {
            EvalOperator.ExpressionEvaluator.Factory expEval = EvalMapper.toEvaluator(not.field(), layout);
            return dvrCtx -> new NotEvaluator(expEval.get(dvrCtx), dvrCtx);
        }
    }

    static class Attributes
    extends ExpressionMapper<Attribute> {
        Attributes() {
        }

        @Override
        public EvalOperator.ExpressionEvaluator.Factory map(Attribute attr, Layout layout) {
            int channel = layout.get(attr.id()).channel();
            return driverContext -> {
                record Attribute(int channel) implements EvalOperator.ExpressionEvaluator
                {
                    public Block.Ref eval(Page page) {
                        return new Block.Ref(page.getBlock(this.channel), page);
                    }

                    public void close() {
                    }
                }
                return new Attribute(channel);
            };
        }
    }

    static class Literals
    extends ExpressionMapper<Literal> {
        Literals() {
        }

        @Override
        public EvalOperator.ExpressionEvaluator.Factory map(Literal lit, Layout layout) {
            return context -> {
                record LiteralsEvaluator(DriverContext context, Literal lit) implements EvalOperator.ExpressionEvaluator
                {
                    public Block.Ref eval(Page page) {
                        return Block.Ref.floating((Block)Literals.block(this.lit, this.context.blockFactory(), page.getPositionCount()));
                    }

                    @Override
                    public String toString() {
                        return "LiteralsEvaluator[lit=" + this.lit + "]";
                    }

                    public void close() {
                    }
                }
                return new LiteralsEvaluator(context, lit);
            };
        }

        private static Block block(Literal lit, BlockFactory blockFactory, int positions) {
            Object value = lit.value();
            if (value == null) {
                return Block.constantNullBlock((int)positions, (BlockFactory)blockFactory);
            }
            if (value instanceof List) {
                List multiValue = (List)value;
                if (multiValue.isEmpty()) {
                    return Block.constantNullBlock((int)positions, (BlockFactory)blockFactory);
                }
                BlockUtils.BuilderWrapper wrapper = BlockUtils.wrapperFor((BlockFactory)blockFactory, (ElementType)ElementType.fromJava(multiValue.get(0).getClass()), (int)positions);
                for (int i = 0; i < positions; ++i) {
                    wrapper.accept((Object)multiValue);
                }
                return wrapper.builder().build();
            }
            return BlockUtils.constantBlock((BlockFactory)blockFactory, (Object)value, (int)positions);
        }
    }

    static class IsNotNulls
    extends ExpressionMapper<IsNotNull> {
        IsNotNulls() {
        }

        @Override
        public EvalOperator.ExpressionEvaluator.Factory map(IsNotNull isNotNull, Layout layout) {
            EvalOperator.ExpressionEvaluator.Factory field = EvalMapper.toEvaluator(isNotNull.field(), layout);
            return driverContext -> new IsNotNullEvaluator(driverContext, field.get(driverContext));
        }

        record IsNotNullEvaluator(DriverContext driverContext, EvalOperator.ExpressionEvaluator field) implements EvalOperator.ExpressionEvaluator
        {
            public Block.Ref eval(Page page) {
                try (Block.Ref fieldBlock = this.field.eval(page);){
                    Block.Ref ref;
                    block15: {
                        if (fieldBlock.block().asVector() != null) {
                            Block.Ref ref2 = Block.Ref.floating((Block)BooleanBlock.newConstantBlockWith((boolean)true, (int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                            return ref2;
                        }
                        BooleanVector.FixedBuilder builder = BooleanVector.newVectorFixedBuilder((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory());
                        try {
                            for (int p = 0; p < page.getPositionCount(); ++p) {
                                builder.appendBoolean(!fieldBlock.block().isNull(p));
                            }
                            ref = Block.Ref.floating((Block)builder.build().asBlock());
                            if (builder == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (builder != null) {
                                try {
                                    builder.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        builder.close();
                    }
                    return ref;
                }
            }

            public void close() {
                Releasables.closeExpectNoException((Releasable)this.field);
            }

            @Override
            public String toString() {
                return "IsNotNullEvaluator[field=" + this.field + "]";
            }
        }
    }

    static class IsNulls
    extends ExpressionMapper<IsNull> {
        IsNulls() {
        }

        @Override
        public EvalOperator.ExpressionEvaluator.Factory map(IsNull isNull, Layout layout) {
            EvalOperator.ExpressionEvaluator.Factory field = EvalMapper.toEvaluator(isNull.field(), layout);
            return driverContext -> new IsNullEvaluator(driverContext, field.get(driverContext));
        }

        record IsNullEvaluator(DriverContext driverContext, EvalOperator.ExpressionEvaluator field) implements EvalOperator.ExpressionEvaluator
        {
            public Block.Ref eval(Page page) {
                try (Block.Ref fieldBlock = this.field.eval(page);){
                    Block.Ref ref;
                    block15: {
                        if (fieldBlock.block().asVector() != null) {
                            Block.Ref ref2 = Block.Ref.floating((Block)BooleanBlock.newConstantBlockWith((boolean)false, (int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory()));
                            return ref2;
                        }
                        BooleanVector.FixedBuilder builder = BooleanVector.newVectorFixedBuilder((int)page.getPositionCount(), (BlockFactory)this.driverContext.blockFactory());
                        try {
                            for (int p = 0; p < page.getPositionCount(); ++p) {
                                builder.appendBoolean(fieldBlock.block().isNull(p));
                            }
                            ref = Block.Ref.floating((Block)builder.build().asBlock());
                            if (builder == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (builder != null) {
                                try {
                                    builder.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        builder.close();
                    }
                    return ref;
                }
            }

            public void close() {
                Releasables.closeExpectNoException((Releasable)this.field);
            }

            @Override
            public String toString() {
                return "IsNullEvaluator[field=" + this.field + "]";
            }
        }
    }
}

