/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.util.ArrayList;
import java.util.function.IntFunction;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;

abstract class QueryList {
    protected final Block block;

    protected QueryList(Block block) {
        this.block = block;
    }

    int getPositionCount() {
        return this.block.getPositionCount();
    }

    @Nullable
    abstract Query getQuery(int var1);

    static QueryList termQueryList(final MappedFieldType field, final SearchExecutionContext searchExecutionContext, Block block) {
        return new QueryList(block){
            private final IntFunction<Object> blockValueReader;
            {
                super(block);
                this.blockValueReader = QueryList.blockToJavaObject(this.block);
            }

            @Override
            Query getQuery(int position) {
                int first = this.block.getFirstValueIndex(position);
                int count = this.block.getValueCount(position);
                return switch (count) {
                    case 0 -> null;
                    case 1 -> field.termQuery(this.blockValueReader.apply(first), searchExecutionContext);
                    default -> {
                        ArrayList<Object> terms = new ArrayList<Object>(count);
                        for (int i = 0; i < count; ++i) {
                            Object value = this.blockValueReader.apply(first + i);
                            terms.add(value);
                        }
                        yield field.termsQuery(terms, searchExecutionContext);
                    }
                };
            }
        };
    }

    private static IntFunction<Object> blockToJavaObject(Block block) {
        return switch (block.elementType()) {
            default -> throw new IncompatibleClassChangeError();
            case ElementType.BOOLEAN -> {
                BooleanBlock booleanBlock = (BooleanBlock)block;
                yield arg_0 -> ((BooleanBlock)booleanBlock).getBoolean(arg_0);
            }
            case ElementType.BYTES_REF -> {
                BytesRefBlock bytesRefBlock = (BytesRefBlock)block;
                yield offset -> bytesRefBlock.getBytesRef(offset, new BytesRef());
            }
            case ElementType.DOUBLE -> {
                DoubleBlock doubleBlock = (DoubleBlock)block;
                yield arg_0 -> ((DoubleBlock)doubleBlock).getDouble(arg_0);
            }
            case ElementType.INT -> {
                IntBlock intBlock = (IntBlock)block;
                yield arg_0 -> ((IntBlock)intBlock).getInt(arg_0);
            }
            case ElementType.LONG -> {
                LongBlock longBlock = (LongBlock)block;
                yield arg_0 -> ((LongBlock)longBlock).getLong(arg_0);
            }
            case ElementType.NULL -> offset -> null;
            case ElementType.DOC -> throw new EsqlIllegalArgumentException("can't read values from [doc] block");
            case ElementType.UNKNOWN -> throw new EsqlIllegalArgumentException("can't read values from [" + block + "]");
        };
    }
}

