/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.util.Arrays;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

final class MergePositionsOperator
implements Operator {
    private boolean finished = false;
    private int filledPositions = 0;
    private final boolean singleMode;
    private final int positionCount;
    private final int positionChannel;
    private final Block.Builder[] outputBuilders;
    private final int[] mergingChannels;
    private final ElementType[] mergingTypes;
    private PositionBuilder positionBuilder = null;
    private Page outputPage;

    MergePositionsOperator(boolean singleMode, int positionCount, int positionChannel, int[] mergingChannels, ElementType[] mergingTypes) {
        if (mergingChannels.length != mergingTypes.length) {
            throw new IllegalArgumentException("Merging channels don't match merging types; channels=" + Arrays.toString(mergingChannels) + ",types=" + Arrays.toString(mergingTypes));
        }
        this.singleMode = singleMode;
        this.positionCount = positionCount;
        this.positionChannel = positionChannel;
        this.mergingChannels = mergingChannels;
        this.mergingTypes = mergingTypes;
        this.outputBuilders = new Block.Builder[mergingTypes.length];
        for (int i = 0; i < mergingTypes.length; ++i) {
            this.outputBuilders[i] = mergingTypes[i].newBlockBuilder(positionCount);
        }
    }

    public boolean needsInput() {
        return true;
    }

    public void addInput(Page page) {
        IntBlock positions = (IntBlock)page.getBlock(this.positionChannel);
        int currentPosition = positions.getInt(0);
        if (this.singleMode) {
            this.fillNullUpToPosition(currentPosition);
            for (int i = 0; i < this.mergingChannels.length; ++i) {
                int channel = this.mergingChannels[i];
                this.outputBuilders[i].appendAllValuesToCurrentPosition(page.getBlock(channel));
            }
            ++this.filledPositions;
        } else {
            if (this.positionBuilder != null && this.positionBuilder.position != currentPosition) {
                this.flushPositionBuilder();
            }
            if (this.positionBuilder == null) {
                this.positionBuilder = new PositionBuilder(currentPosition, this.mergingTypes);
            }
            this.positionBuilder.combine(page, this.mergingChannels);
        }
    }

    private void flushPositionBuilder() {
        this.fillNullUpToPosition(this.positionBuilder.position);
        ++this.filledPositions;
        this.positionBuilder.buildTo(this.outputBuilders);
        this.positionBuilder = null;
    }

    private void fillNullUpToPosition(int position) {
        while (this.filledPositions < position) {
            for (Block.Builder builder : this.outputBuilders) {
                builder.appendNull();
            }
            ++this.filledPositions;
        }
    }

    public void finish() {
        if (this.positionBuilder != null) {
            this.flushPositionBuilder();
        }
        this.fillNullUpToPosition(this.positionCount);
        try {
            Block[] blocks = (Block[])Arrays.stream(this.outputBuilders).map(Block.Builder::build).toArray(Block[]::new);
            this.outputPage = new Page(blocks);
            this.finished = true;
            assert (this.outputPage.getPositionCount() == this.positionCount);
        }
        finally {
            Releasables.closeExpectNoException((Releasable[])this.outputBuilders);
        }
    }

    public boolean isFinished() {
        return this.finished && this.outputPage == null;
    }

    public Page getOutput() {
        Page page = this.outputPage;
        this.outputPage = null;
        return page;
    }

    public void close() {
    }

    static final class PositionBuilder {
        private final int position;
        private final Block.Builder[] builders;

        PositionBuilder(int position, ElementType[] elementTypes) {
            this.position = position;
            this.builders = new Block.Builder[elementTypes.length];
            for (int i = 0; i < this.builders.length; ++i) {
                this.builders[i] = elementTypes[i].newBlockBuilder(1);
            }
        }

        void combine(Page page, int[] channels) {
            for (int i = 0; i < channels.length; ++i) {
                this.builders[i].appendAllValuesToCurrentPosition(page.getBlock(channels[i]));
            }
        }

        void buildTo(Block.Builder[] output) {
            for (int i = 0; i < output.length; ++i) {
                output[i].appendAllValuesToCurrentPosition(this.builders[i].build());
            }
        }
    }
}

