/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.ConstantIntVector;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.IntArrayVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.xpack.esql.enrich.QueryList;

final class EnrichQuerySourceOperator
extends SourceOperator {
    private final QueryList queryList;
    private int queryPosition;
    private Weight weight = null;
    private final IndexReader indexReader;
    private int leafIndex = 0;
    private final IndexSearcher searcher;

    EnrichQuerySourceOperator(QueryList queryList, IndexReader indexReader) {
        this.queryList = queryList;
        this.indexReader = indexReader;
        this.searcher = new IndexSearcher(indexReader);
    }

    public void finish() {
    }

    public boolean isFinished() {
        return this.queryPosition >= this.queryList.getPositionCount();
    }

    public Page getOutput() {
        Query query;
        if (this.leafIndex == this.indexReader.leaves().size()) {
            ++this.queryPosition;
            this.leafIndex = 0;
            this.weight = null;
        }
        if (this.isFinished()) {
            return null;
        }
        if (this.weight == null && (query = this.queryList.getQuery(this.queryPosition)) != null) {
            try {
                query = this.searcher.rewrite((Query)new ConstantScoreQuery(query));
                this.weight = this.searcher.createWeight(query, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        try {
            return this.queryOneLeaf(this.weight, this.leafIndex++);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private Page queryOneLeaf(Weight weight, int leafIndex) throws IOException {
        if (weight == null) {
            return null;
        }
        LeafReaderContext leafReaderContext = (LeafReaderContext)this.indexReader.leaves().get(leafIndex);
        BulkScorer scorer = weight.bulkScorer(leafReaderContext);
        if (scorer == null) {
            return null;
        }
        DocCollector collector = new DocCollector();
        scorer.score((LeafCollector)collector, leafReaderContext.reader().getLiveDocs());
        int matches = collector.matches;
        DocVector docVector = new DocVector((IntVector)new ConstantIntVector(0, matches), (IntVector)new ConstantIntVector(leafIndex, matches), (IntVector)new IntArrayVector(collector.docs, matches), Boolean.valueOf(true));
        IntBlock positionBlock = new ConstantIntVector(this.queryPosition, matches).asBlock();
        return new Page(new Block[]{docVector.asBlock(), positionBlock});
    }

    public void close() {
    }

    private static class DocCollector
    implements LeafCollector {
        int matches = 0;
        int[] docs = new int[0];

        private DocCollector() {
        }

        public void setScorer(Scorable scorer) {
        }

        public void collect(int doc) throws IOException {
            this.docs = ArrayUtil.grow((int[])this.docs, (int)(this.matches + 1));
            this.docs[this.matches++] = doc;
        }
    }
}

