/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AsyncOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.xpack.esql.enrich.EnrichLookupService;
import org.elasticsearch.xpack.ql.expression.NamedExpression;

public final class EnrichLookupOperator
extends AsyncOperator {
    private final EnrichLookupService enrichLookupService;
    private final String sessionId;
    private final CancellableTask parentTask;
    private final int inputChannel;
    private final String enrichIndex;
    private final String matchType;
    private final String matchField;
    private final List<NamedExpression> enrichFields;

    public EnrichLookupOperator(String sessionId, CancellableTask parentTask, int maxOutstandingRequests, int inputChannel, EnrichLookupService enrichLookupService, String enrichIndex, String matchType, String matchField, List<NamedExpression> enrichFields) {
        super(maxOutstandingRequests);
        this.sessionId = sessionId;
        this.parentTask = parentTask;
        this.inputChannel = inputChannel;
        this.enrichLookupService = enrichLookupService;
        this.enrichIndex = enrichIndex;
        this.matchType = matchType;
        this.matchField = matchField;
        this.enrichFields = enrichFields;
    }

    protected void performAsync(Page inputPage, ActionListener<Page> listener) {
        Block inputBlock = inputPage.getBlock(this.inputChannel);
        this.enrichLookupService.lookupAsync(this.sessionId, this.parentTask, this.enrichIndex, this.matchType, this.matchField, this.enrichFields, new Page(new Block[]{inputBlock}), (ActionListener<Page>)listener.map(arg_0 -> ((Page)inputPage).appendPage(arg_0)));
    }

    public void close() {
    }

    public record Factory(String sessionId, CancellableTask parentTask, int maxOutstandingRequests, int inputChannel, EnrichLookupService enrichLookupService, String enrichIndex, String matchType, String matchField, List<NamedExpression> enrichFields) implements Operator.OperatorFactory
    {
        public String describe() {
            return "EnrichOperator[index=" + this.enrichIndex + " match_field=" + this.matchField + " enrich_fields=" + this.enrichFields + " inputChannel=" + this.inputChannel + "]";
        }

        public Operator get(DriverContext driverContext) {
            return new EnrichLookupOperator(this.sessionId, this.parentTask, this.maxOutstandingRequests, this.inputChannel, this.enrichLookupService, this.enrichIndex, this.matchType, this.matchField, this.enrichFields);
        }
    }
}

