/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.analysis;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.esql.expression.function.UnsupportedAttribute;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Neg;
import org.elasticsearch.xpack.esql.plan.logical.Dissect;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Grok;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;
import org.elasticsearch.xpack.esql.plan.logical.Row;
import org.elasticsearch.xpack.esql.stats.FeatureMetric;
import org.elasticsearch.xpack.esql.stats.Metrics;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.analyzer.VerifierChecks;
import org.elasticsearch.xpack.ql.capabilities.Unresolvable;
import org.elasticsearch.xpack.ql.common.Failure;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.MetadataAttribute;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.ReferenceAttribute;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.plan.logical.Aggregate;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.plan.logical.Project;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Verifier {
    private final Metrics metrics;

    public Verifier(Metrics metrics) {
        this.metrics = metrics;
    }

    Collection<Failure> verify(LogicalPlan plan) {
        LinkedHashSet<Failure> failures = new LinkedHashSet<Failure>();
        plan.forEachUp(p -> {
            if (!p.childrenResolved()) {
                return;
            }
            if (p instanceof Unresolvable) {
                Unresolvable u = (Unresolvable)p;
                failures.add(Failure.fail((Node)p, (String)u.unresolvedMessage(), (Object[])new Object[0]));
            } else if (p.resolved()) {
                return;
            }
            if (p instanceof Aggregate) {
                Aggregate aggregate = (Aggregate)p;
                for (NamedExpression agg : aggregate.aggregates()) {
                    Alias as;
                    Expression child;
                    if (!(agg instanceof Alias) || !((child = (as = (Alias)agg).child()) instanceof UnresolvedAttribute)) continue;
                    UnresolvedAttribute u = (UnresolvedAttribute)child;
                    failures.add(Failure.fail((Node)child, (String)"invalid stats declaration; [{}] is not an aggregate function", (Object[])new Object[]{child.sourceText()}));
                }
            }
            p.forEachExpression(e -> {
                if (e.resolved()) {
                    return;
                }
                e.forEachUp(ae -> {
                    if (!ae.childrenResolved()) {
                        return;
                    }
                    if (ae instanceof Unresolvable) {
                        Unresolvable u = (Unresolvable)ae;
                        if (!(p instanceof Project) || !(u instanceof UnsupportedAttribute)) {
                            failures.add(Failure.fail((Node)ae, (String)u.unresolvedMessage(), (Object[])new Object[0]));
                        }
                    }
                    if (ae.typeResolved().unresolved()) {
                        failures.add(Failure.fail((Node)ae, (String)ae.typeResolved().message(), (Object[])new Object[0]));
                    }
                });
            });
        });
        if (!failures.isEmpty()) {
            return failures;
        }
        plan.forEachDown(p -> {
            if (!p.childrenResolved()) {
                return;
            }
            VerifierChecks.checkFilterConditionType((LogicalPlan)p, (Set)failures);
            Verifier.checkAggregate(p, failures);
            Verifier.checkRegexExtractOnlyOnStrings(p, failures);
            Verifier.checkRow(p, failures);
            Verifier.checkEvalFields(p, failures);
            Verifier.checkOperationsOnUnsignedLong(p, failures);
            Verifier.checkBinaryComparison(p, failures);
        });
        if (failures.isEmpty()) {
            this.gatherMetrics(plan);
        }
        return failures;
    }

    private static void checkAggregate(LogicalPlan p, Set<Failure> failures) {
        if (p instanceof Aggregate) {
            Aggregate agg = (Aggregate)p;
            agg.aggregates().forEach(e -> {
                NamedExpression exp;
                Object object = exp = e instanceof Alias ? ((Alias)e).child() : e;
                if (exp instanceof AggregateFunction) {
                    AggregateFunction aggFunc = (AggregateFunction)exp;
                    Expression field = aggFunc.field();
                    if (!(field instanceof FieldAttribute || field instanceof MetadataAttribute || field instanceof ReferenceAttribute || field instanceof Literal)) {
                        failures.add(Failure.fail((Node)e, (String)("aggregate function's field must be an attribute or literal; found [" + field.sourceText() + "] of type [" + field.nodeName() + "]"), (Object[])new Object[0]));
                    }
                } else if (!agg.groupings().contains(exp)) {
                    failures.add(Failure.fail((Node)exp, (String)("expected an aggregate function or group but got [" + exp.sourceText() + "] of type [" + exp.nodeName() + "]"), (Object[])new Object[0]));
                }
            });
        }
    }

    private static void checkRegexExtractOnlyOnStrings(LogicalPlan p, Set<Failure> failures) {
        RegexExtract re;
        Expression expr;
        DataType type;
        if (p instanceof RegexExtract && !EsqlDataTypes.isString(type = (expr = (re = (RegexExtract)p).input()).dataType())) {
            failures.add(Failure.fail((Node)expr, (String)"{} only supports KEYWORD or TEXT values, found expression [{}] type [{}]", (Object[])new Object[]{((Object)((Object)re)).getClass().getSimpleName(), expr.sourceText(), type}));
        }
    }

    private static void checkRow(LogicalPlan p, Set<Failure> failures) {
        if (p instanceof Row) {
            Row row = (Row)p;
            row.fields().forEach(a -> {
                if (!EsqlDataTypes.isRepresentable(a.dataType())) {
                    failures.add(Failure.fail((Node)a, (String)"cannot use [{}] directly in a row assignment", (Object[])new Object[]{a.child().sourceText()}));
                }
            });
        }
    }

    private static void checkEvalFields(LogicalPlan p, Set<Failure> failures) {
        if (p instanceof Eval) {
            Eval eval = (Eval)p;
            eval.fields().forEach(field -> {
                DataType dataType = field.dataType();
                if (!EsqlDataTypes.isRepresentable(dataType)) {
                    failures.add(Failure.fail((Node)field, (String)"EVAL does not support type [{}] in expression [{}]", (Object[])new Object[]{dataType.typeName(), field.child().sourceText()}));
                }
            });
        }
    }

    private static void checkOperationsOnUnsignedLong(LogicalPlan p, Set<Failure> failures) {
        p.forEachExpression(e -> {
            Failure f = null;
            if (e instanceof BinaryOperator) {
                BinaryOperator bo = (BinaryOperator)e;
                f = Verifier.validateUnsignedLongOperator(bo);
            } else if (e instanceof Neg) {
                Neg neg = (Neg)e;
                f = Verifier.validateUnsignedLongNegation(neg);
            }
            if (f != null) {
                failures.add(f);
            }
        });
    }

    private static void checkBinaryComparison(LogicalPlan p, Set<Failure> failures) {
        p.forEachExpression(BinaryComparison.class, bc -> {
            Failure f = Verifier.validateBinaryComparison(bc);
            if (f != null) {
                failures.add(f);
            }
        });
    }

    private void gatherMetrics(LogicalPlan plan) {
        BitSet b = new BitSet(FeatureMetric.values().length);
        plan.forEachDown(p -> {
            if (p instanceof Dissect) {
                b.set(FeatureMetric.DISSECT.ordinal());
            } else if (p instanceof Eval) {
                b.set(FeatureMetric.EVAL.ordinal());
            } else if (p instanceof Grok) {
                b.set(FeatureMetric.GROK.ordinal());
            } else if (p instanceof Limit) {
                b.set(FeatureMetric.LIMIT.ordinal());
            } else if (p instanceof OrderBy) {
                b.set(FeatureMetric.SORT.ordinal());
            } else if (p instanceof Aggregate) {
                b.set(FeatureMetric.STATS.ordinal());
            } else if (p instanceof Filter) {
                b.set(FeatureMetric.WHERE.ordinal());
            }
        });
        int i = b.nextSetBit(0);
        while (i >= 0) {
            this.metrics.inc(FeatureMetric.values()[i]);
            i = b.nextSetBit(i + 1);
        }
    }

    public static Failure validateBinaryComparison(BinaryComparison bc) {
        if (bc.left().dataType().isNumeric()) {
            if (!bc.right().dataType().isNumeric()) {
                return Failure.fail((Node)bc, (String)"first argument of [{}] is [numeric] so second argument must also be [numeric] but was [{}]", (Object[])new Object[]{bc.sourceText(), bc.right().dataType().typeName()});
            }
            return null;
        }
        ArrayList<DataType> allowed = new ArrayList<DataType>();
        allowed.add(DataTypes.KEYWORD);
        allowed.add(DataTypes.TEXT);
        allowed.add(DataTypes.IP);
        allowed.add(DataTypes.DATETIME);
        allowed.add(DataTypes.VERSION);
        if (bc instanceof Equals || bc instanceof NotEquals) {
            allowed.add(DataTypes.BOOLEAN);
        }
        Expression.TypeResolution r = TypeResolutions.isType((Expression)bc.left(), allowed::contains, (String)bc.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])((String[])Stream.concat(Stream.of("numeric"), allowed.stream().map(DataType::typeName)).toArray(String[]::new)));
        if (!r.resolved()) {
            return Failure.fail((Node)bc, (String)r.message(), (Object[])new Object[0]);
        }
        if (DataTypes.isString((DataType)bc.left().dataType()) && DataTypes.isString((DataType)bc.right().dataType())) {
            return null;
        }
        if (bc.left().dataType() != bc.right().dataType()) {
            return Failure.fail((Node)bc, (String)"first argument of [{}] is [{}] so second argument must also be [{}] but was [{}]", (Object[])new Object[]{bc.sourceText(), bc.left().dataType().typeName(), bc.left().dataType().typeName(), bc.right().dataType().typeName()});
        }
        return null;
    }

    public static Failure validateUnsignedLongOperator(BinaryOperator<?, ?, ?, ?> bo) {
        DataType leftType = bo.left().dataType();
        DataType rightType = bo.right().dataType();
        if ((leftType == DataTypes.UNSIGNED_LONG || rightType == DataTypes.UNSIGNED_LONG) && leftType != rightType) {
            return Failure.fail(bo, (String)"first argument of [{}] is [{}] and second is [{}]. [{}] can only be operated on together with another [{}]", (Object[])new Object[]{bo.sourceText(), leftType.typeName(), rightType.typeName(), DataTypes.UNSIGNED_LONG.typeName(), DataTypes.UNSIGNED_LONG.typeName()});
        }
        return null;
    }

    private static Failure validateUnsignedLongNegation(Neg neg) {
        DataType childExpressionType = neg.field().dataType();
        if (childExpressionType.equals((Object)DataTypes.UNSIGNED_LONG)) {
            return Failure.fail((Node)neg, (String)"negation unsupported for arguments of type [{}] in expression [{}]", (Object[])new Object[]{childExpressionType.typeName(), neg.sourceText()});
        }
        return null;
    }
}

