/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.UnsupportedValueSource;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.InstantiatingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.action.ColumnInfo;
import org.elasticsearch.xpack.esql.planner.LocalExecutionPlanner;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.util.DateUtils;
import org.elasticsearch.xpack.ql.util.NumericUtils;
import org.elasticsearch.xpack.ql.util.StringUtils;
import org.elasticsearch.xpack.versionfield.Version;

public class EsqlQueryResponse
extends ActionResponse
implements ChunkedToXContent,
Releasable {
    private final List<ColumnInfo> columns;
    private final List<Page> pages;
    private final boolean columnar;
    private static final InstantiatingObjectParser<EsqlQueryResponse, Void> PARSER;

    public EsqlQueryResponse(List<ColumnInfo> columns, List<Page> pages, boolean columnar) {
        this.columns = columns;
        this.pages = pages;
        this.columnar = columnar;
    }

    public EsqlQueryResponse(List<ColumnInfo> columns, List<List<Object>> values) {
        this.columns = columns;
        this.pages = List.of(EsqlQueryResponse.valuesToPage(columns.stream().map(ColumnInfo::type).toList(), values));
        this.columnar = false;
    }

    public static Writeable.Reader<EsqlQueryResponse> reader(BlockFactory blockFactory) {
        return in -> new EsqlQueryResponse(new BlockStreamInput(in, blockFactory));
    }

    public EsqlQueryResponse(BlockStreamInput in) throws IOException {
        super((StreamInput)in);
        this.columns = in.readCollectionAsList(ColumnInfo::new);
        this.pages = in.readCollectionAsList(Page::new);
        this.columnar = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.columns);
        out.writeCollection(this.pages);
        out.writeBoolean(this.columnar);
    }

    public List<ColumnInfo> columns() {
        return this.columns;
    }

    List<Page> pages() {
        return this.pages;
    }

    public Iterator<Iterator<Object>> values() {
        return EsqlQueryResponse.pagesToValues(this.columns.stream().map(ColumnInfo::type).toList(), this.pages);
    }

    public boolean columnar() {
        return this.columnar;
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params unused) {
        BytesRef scratch = new BytesRef();
        Iterator valuesIt = this.pages.isEmpty() ? Collections.emptyIterator() : (this.columnar ? Iterators.flatMap((Iterator)Iterators.forRange((int)0, (int)this.columns().size(), column -> Iterators.concat((Iterator[])new Iterator[]{Iterators.single((builder, params) -> builder.startArray()), Iterators.flatMap(this.pages.iterator(), page -> {
            ColumnInfo.PositionToXContent toXContent = this.columns.get(column).positionToXContent(page.getBlock(column), scratch);
            return Iterators.forRange((int)0, (int)page.getPositionCount(), position -> (builder, params) -> toXContent.positionToXContent(builder, params, position));
        }), ChunkedToXContentHelper.endArray()})), Function.identity()) : Iterators.flatMap(this.pages.iterator(), page -> {
            int columnCount = this.columns.size();
            assert (page.getBlockCount() == columnCount) : page.getBlockCount() + " != " + columnCount;
            ColumnInfo.PositionToXContent[] toXContents = new ColumnInfo.PositionToXContent[columnCount];
            for (int column = 0; column < columnCount; ++column) {
                toXContents[column] = this.columns.get(column).positionToXContent(page.getBlock(column), scratch);
            }
            return Iterators.forRange((int)0, (int)page.getPositionCount(), position -> (builder, params) -> {
                builder.startArray();
                for (int c = 0; c < columnCount; ++c) {
                    toXContents[c].positionToXContent(builder, params, position);
                }
                return builder.endArray();
            });
        }));
        return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject(), ChunkedToXContentHelper.singleChunk((ToXContent[])new ToXContent[]{(builder, params) -> {
            builder.startArray("columns");
            for (ColumnInfo col : this.columns) {
                col.toXContent(builder, params);
            }
            return builder.endArray();
        }}), ChunkedToXContentHelper.array((String)"values", (Iterator)valuesIt), ChunkedToXContentHelper.endObject()});
    }

    public boolean isFragment() {
        return false;
    }

    public static EsqlQueryResponse fromXContent(XContentParser parser) {
        return (EsqlQueryResponse)((Object)PARSER.apply(parser, null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EsqlQueryResponse that = (EsqlQueryResponse)((Object)o);
        return Objects.equals(this.columns, that.columns) && this.columnar == that.columnar && Iterators.equals(this.values(), that.values(), (row1, row2) -> Iterators.equals((Iterator)row1, (Iterator)row2, Objects::equals));
    }

    public int hashCode() {
        return Objects.hash(this.columns, Iterators.hashCode(this.values(), row -> Iterators.hashCode((Iterator)row, Objects::hashCode)), this.columnar);
    }

    public String toString() {
        return Strings.toString((ToXContent)ChunkedToXContent.wrapAsToXContent((ChunkedToXContent)this));
    }

    public void close() {
        Releasables.close(() -> Iterators.map(this.pages.iterator(), p -> () -> ((Page)p).releaseBlocks()));
    }

    public static Iterator<Iterator<Object>> pagesToValues(List<String> dataTypes, List<Page> pages) {
        BytesRef scratch = new BytesRef();
        return Iterators.flatMap(pages.iterator(), page -> Iterators.forRange((int)0, (int)page.getPositionCount(), p -> Iterators.forRange((int)0, (int)page.getBlockCount(), b -> {
            Block block = page.getBlock(b);
            if (block.isNull(p)) {
                return null;
            }
            int count = block.getValueCount(p);
            int start = block.getFirstValueIndex(p);
            String dataType = (String)dataTypes.get(b);
            if (count == 1) {
                return EsqlQueryResponse.valueAt(dataType, block, start, scratch);
            }
            ArrayList<Object> thisResult = new ArrayList<Object>(count);
            int end = count + start;
            for (int i = start; i < end; ++i) {
                thisResult.add(EsqlQueryResponse.valueAt(dataType, block, i, scratch));
            }
            return thisResult;
        })));
    }

    private static Object valueAt(String dataType, Block block, int offset, BytesRef scratch) {
        return switch (dataType) {
            case "unsigned_long" -> NumericUtils.unsignedLongAsNumber((long)((LongBlock)block).getLong(offset));
            case "long" -> ((LongBlock)block).getLong(offset);
            case "integer" -> ((IntBlock)block).getInt(offset);
            case "double" -> ((DoubleBlock)block).getDouble(offset);
            case "keyword", "text" -> ((BytesRefBlock)block).getBytesRef(offset, scratch).utf8ToString();
            case "ip" -> {
                BytesRef val = ((BytesRefBlock)block).getBytesRef(offset, scratch);
                yield DocValueFormat.IP.format(val);
            }
            case "date" -> {
                long longVal = ((LongBlock)block).getLong(offset);
                yield DateUtils.UTC_DATE_TIME_FORMATTER.formatMillis(longVal);
            }
            case "boolean" -> ((BooleanBlock)block).getBoolean(offset);
            case "version" -> new Version(((BytesRefBlock)block).getBytesRef(offset, scratch)).toString();
            case "unsupported" -> UnsupportedValueSource.UNSUPPORTED_OUTPUT;
            default -> throw EsqlIllegalArgumentException.illegalDataType(dataType);
        };
    }

    private static Page valuesToPage(List<String> dataTypes, List<List<Object>> values) {
        List<Block.Builder> results = dataTypes.stream().map(c -> LocalExecutionPlanner.toElementType(EsqlDataTypes.fromName(c)).newBlockBuilder(values.size())).toList();
        for (List<Object> row : values) {
            block27: for (int c2 = 0; c2 < row.size(); ++c2) {
                Block.Builder builder = results.get(c2);
                Object value = row.get(c2);
                switch (dataTypes.get(c2)) {
                    case "unsigned_long": {
                        ((LongBlock.Builder)builder).appendLong(NumericUtils.asLongUnsigned((long)((Number)value).longValue()));
                        continue block27;
                    }
                    case "long": {
                        ((LongBlock.Builder)builder).appendLong(((Number)value).longValue());
                        continue block27;
                    }
                    case "integer": {
                        ((IntBlock.Builder)builder).appendInt(((Number)value).intValue());
                        continue block27;
                    }
                    case "double": {
                        ((DoubleBlock.Builder)builder).appendDouble(((Number)value).doubleValue());
                        continue block27;
                    }
                    case "keyword": 
                    case "text": 
                    case "unsupported": {
                        ((BytesRefBlock.Builder)builder).appendBytesRef(new BytesRef((CharSequence)value.toString()));
                        continue block27;
                    }
                    case "ip": {
                        ((BytesRefBlock.Builder)builder).appendBytesRef(StringUtils.parseIP((String)value.toString()));
                        continue block27;
                    }
                    case "date": {
                        long longVal = DateUtils.UTC_DATE_TIME_FORMATTER.parseMillis(value.toString());
                        ((LongBlock.Builder)builder).appendLong(longVal);
                        continue block27;
                    }
                    case "boolean": {
                        ((BooleanBlock.Builder)builder).appendBoolean(((Boolean)value).booleanValue());
                        continue block27;
                    }
                    case "null": {
                        builder.appendNull();
                        continue block27;
                    }
                    case "version": {
                        ((BytesRefBlock.Builder)builder).appendBytesRef(new Version(value.toString()).toBytesRef());
                        continue block27;
                    }
                    default: {
                        throw EsqlIllegalArgumentException.illegalDataType(dataTypes.get(c2));
                    }
                }
            }
        }
        return new Page((Block[])results.stream().map(Block.Builder::build).toArray(Block[]::new));
    }

    static {
        InstantiatingObjectParser.Builder parser = InstantiatingObjectParser.builder((String)"esql/query_response", (boolean)true, EsqlQueryResponse.class);
        parser.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> ColumnInfo.fromXContent(p), new ParseField("columns", new String[0]));
        parser.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.list(), new ParseField("values", new String[0]), ObjectParser.ValueType.OBJECT_ARRAY);
        PARSER = parser.build();
    }
}

