/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.lucene.UnsupportedValueSource;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.InstantiatingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.ql.util.DateUtils;
import org.elasticsearch.xpack.ql.util.NumericUtils;
import org.elasticsearch.xpack.versionfield.Version;

public record ColumnInfo(String name, String type) implements Writeable
{
    private static final InstantiatingObjectParser<ColumnInfo, Void> PARSER;

    public ColumnInfo(StreamInput in) throws IOException {
        this(in.readString(), in.readString());
    }

    public static ColumnInfo fromXContent(XContentParser parser) {
        return (ColumnInfo)PARSER.apply(parser, null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.type);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.name);
        builder.field("type", this.type);
        builder.endObject();
        return builder;
    }

    public PositionToXContent positionToXContent(final Block block, final BytesRef scratch) {
        return switch (this.type) {
            case "long" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.value(((LongBlock)block).getLong(valueIndex));
                }
            };
            case "integer" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.value(((IntBlock)block).getInt(valueIndex));
                }
            };
            case "double" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.value(((DoubleBlock)block).getDouble(valueIndex));
                }
            };
            case "unsigned_long" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    long l = ((LongBlock)block).getLong(valueIndex);
                    return builder.value((Object)NumericUtils.unsignedLongAsNumber((long)l));
                }
            };
            case "keyword", "text" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    BytesRef val = ((BytesRefBlock)block).getBytesRef(valueIndex, scratch);
                    if (builder.contentType() == XContentType.CBOR && val.offset != 0) {
                        val = BytesRef.deepCopyOf((BytesRef)scratch);
                    }
                    return builder.utf8Value(val.bytes, val.offset, val.length);
                }
            };
            case "ip" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    BytesRef val = ((BytesRefBlock)block).getBytesRef(valueIndex, scratch);
                    return builder.value(DocValueFormat.IP.format(val));
                }
            };
            case "date" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    long longVal = ((LongBlock)block).getLong(valueIndex);
                    return builder.value(DateUtils.UTC_DATE_TIME_FORMATTER.formatMillis(longVal));
                }
            };
            case "boolean" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.value(((BooleanBlock)block).getBoolean(valueIndex));
                }
            };
            case "version" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    BytesRef val = ((BytesRefBlock)block).getBytesRef(valueIndex, scratch);
                    return builder.value(new Version(val).toString());
                }
            };
            case "null" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.nullValue();
                }
            };
            case "unsupported" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.value(UnsupportedValueSource.UNSUPPORTED_OUTPUT);
                }
            };
            default -> throw new IllegalArgumentException("can't convert values of type [" + this.type + "]");
        };
    }

    static {
        InstantiatingObjectParser.Builder parser = InstantiatingObjectParser.builder((String)"esql/column_info", (boolean)true, ColumnInfo.class);
        parser.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        parser.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
        PARSER = parser.build();
    }

    public abstract class PositionToXContent {
        private final Block block;

        PositionToXContent(Block block) {
            this.block = block;
        }

        public XContentBuilder positionToXContent(XContentBuilder builder, ToXContent.Params params, int position) throws IOException {
            if (this.block.isNull(position)) {
                return builder.nullValue();
            }
            int count = this.block.getValueCount(position);
            int start = this.block.getFirstValueIndex(position);
            if (count == 1) {
                return this.valueToXContent(builder, params, start);
            }
            builder.startArray();
            int end = start + count;
            for (int i = start; i < end; ++i) {
                this.valueToXContent(builder, params, i);
            }
            return builder.endArray();
        }

        protected abstract XContentBuilder valueToXContent(XContentBuilder var1, ToXContent.Params var2, int var3) throws IOException;
    }
}

