/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.action;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.analytics.AnalyticsUsage;
import org.elasticsearch.xpack.core.analytics.action.AnalyticsStatsAction;

public class TransportAnalyticsStatsAction
extends TransportNodesAction<AnalyticsStatsAction.Request, AnalyticsStatsAction.Response, AnalyticsStatsAction.NodeRequest, AnalyticsStatsAction.NodeResponse> {
    private final AnalyticsUsage usage;

    @Inject
    public TransportAnalyticsStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, AnalyticsUsage usage) {
        super("cluster:monitor/xpack/analytics/stats", threadPool, clusterService, transportService, actionFilters, AnalyticsStatsAction.Request::new, AnalyticsStatsAction.NodeRequest::new, (Executor)threadPool.executor("management"));
        this.usage = usage;
    }

    protected AnalyticsStatsAction.Response newResponse(AnalyticsStatsAction.Request request, List<AnalyticsStatsAction.NodeResponse> nodes, List<FailedNodeException> failures) {
        return new AnalyticsStatsAction.Response(this.clusterService.getClusterName(), nodes, failures);
    }

    protected AnalyticsStatsAction.NodeRequest newNodeRequest(AnalyticsStatsAction.Request request) {
        return new AnalyticsStatsAction.NodeRequest(request);
    }

    protected AnalyticsStatsAction.NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new AnalyticsStatsAction.NodeResponse(in);
    }

    protected AnalyticsStatsAction.NodeResponse nodeOperation(AnalyticsStatsAction.NodeRequest request, Task task) {
        return this.usage.stats(this.clusterService.localNode());
    }
}

