/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import com.maxmind.db.Network;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Subdivision;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.geoip.GeoIpDatabase;
import org.elasticsearch.ingest.geoip.GeoIpDatabaseProvider;

public final class GeoIpProcessor
extends AbstractProcessor {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(GeoIpProcessor.class);
    static final String DEFAULT_DATABASES_DEPRECATION_MESSAGE = "the [fallback_to_default_databases] has been deprecated, because Elasticsearch no longer includes the default Maxmind geoip databases. This setting will be removed in Elasticsearch 9.0";
    public static final String TYPE = "geoip";
    private static final String CITY_DB_SUFFIX = "-City";
    private static final String COUNTRY_DB_SUFFIX = "-Country";
    private static final String ASN_DB_SUFFIX = "-ASN";
    private final String field;
    private final Supplier<Boolean> isValid;
    private final String targetField;
    private final CheckedSupplier<GeoIpDatabase, IOException> supplier;
    private final Set<Property> properties;
    private final boolean ignoreMissing;
    private final boolean firstOnly;
    private final String databaseFile;

    GeoIpProcessor(String tag, String description, String field, CheckedSupplier<GeoIpDatabase, IOException> supplier, Supplier<Boolean> isValid, String targetField, Set<Property> properties, boolean ignoreMissing, boolean firstOnly, String databaseFile) {
        super(tag, description);
        this.field = field;
        this.isValid = isValid;
        this.targetField = targetField;
        this.supplier = supplier;
        this.properties = properties;
        this.ignoreMissing = ignoreMissing;
        this.firstOnly = firstOnly;
        this.databaseFile = databaseFile;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IngestDocument execute(IngestDocument ingestDocument) throws IOException {
        block17: {
            Object ip = ingestDocument.getFieldValue(this.field, Object.class, this.ignoreMissing);
            if (!this.isValid.get().booleanValue()) {
                ingestDocument.appendFieldValue("tags", (Object)"_geoip_expired_database", false);
                return ingestDocument;
            }
            if (ip == null && this.ignoreMissing) {
                return ingestDocument;
            }
            if (ip == null) {
                throw new IllegalArgumentException("field [" + this.field + "] is null, cannot extract geoip information.");
            }
            GeoIpDatabase geoIpDatabase = (GeoIpDatabase)this.supplier.get();
            if (geoIpDatabase == null) {
                if (!this.ignoreMissing) {
                    GeoIpProcessor.tag(ingestDocument, this.databaseFile);
                }
                return ingestDocument;
            }
            try {
                if (ip instanceof String) {
                    String ipString = (String)ip;
                    Map<String, Object> geoData = this.getGeoData(geoIpDatabase, ipString);
                    if (!geoData.isEmpty()) {
                        ingestDocument.setFieldValue(this.targetField, geoData);
                    }
                    break block17;
                }
                if (ip instanceof List) {
                    List ipList = (List)ip;
                    boolean match = false;
                    ArrayList<Map<String, Object>> geoDataList = new ArrayList<Map<String, Object>>(ipList.size());
                    for (Object ipAddr : ipList) {
                        if (!(ipAddr instanceof String)) {
                            throw new IllegalArgumentException("array in field [" + this.field + "] should only contain strings");
                        }
                        Map<String, Object> geoData = this.getGeoData(geoIpDatabase, (String)ipAddr);
                        if (geoData.isEmpty()) {
                            geoDataList.add(null);
                            continue;
                        }
                        if (this.firstOnly) {
                            ingestDocument.setFieldValue(this.targetField, geoData);
                            IngestDocument ingestDocument2 = ingestDocument;
                            return ingestDocument2;
                        }
                        match = true;
                        geoDataList.add(geoData);
                    }
                    if (match) {
                        ingestDocument.setFieldValue(this.targetField, geoDataList);
                    }
                    break block17;
                }
                throw new IllegalArgumentException("field [" + this.field + "] should contain only string or array of strings");
            }
            finally {
                geoIpDatabase.release();
            }
        }
        return ingestDocument;
    }

    private Map<String, Object> getGeoData(GeoIpDatabase geoIpDatabase, String ip) throws IOException {
        Map<String, Object> geoData;
        String databaseType = geoIpDatabase.getDatabaseType();
        InetAddress ipAddress = InetAddresses.forString((String)ip);
        if (databaseType.endsWith(CITY_DB_SUFFIX)) {
            geoData = this.retrieveCityGeoData(geoIpDatabase, ipAddress);
        } else if (databaseType.endsWith(COUNTRY_DB_SUFFIX)) {
            geoData = this.retrieveCountryGeoData(geoIpDatabase, ipAddress);
        } else if (databaseType.endsWith(ASN_DB_SUFFIX)) {
            geoData = this.retrieveAsnGeoData(geoIpDatabase, ipAddress);
        } else {
            throw new ElasticsearchParseException("Unsupported database type [" + geoIpDatabase.getDatabaseType() + "]", (Throwable)new IllegalStateException(), new Object[0]);
        }
        return geoData;
    }

    public String getType() {
        return TYPE;
    }

    String getField() {
        return this.field;
    }

    String getTargetField() {
        return this.targetField;
    }

    String getDatabaseType() throws IOException {
        return ((GeoIpDatabase)this.supplier.get()).getDatabaseType();
    }

    Set<Property> getProperties() {
        return this.properties;
    }

    private Map<String, Object> retrieveCityGeoData(GeoIpDatabase geoIpDatabase, InetAddress ipAddress) {
        CityResponse response = geoIpDatabase.getCity(ipAddress);
        if (response == null) {
            return Map.of();
        }
        Country country = response.getCountry();
        City city = response.getCity();
        Location location = response.getLocation();
        Continent continent = response.getContinent();
        Subdivision subdivision = response.getMostSpecificSubdivision();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        block11: for (Property property : this.properties) {
            switch (property) {
                case IP: {
                    geoData.put("ip", NetworkAddress.format((InetAddress)ipAddress));
                    break;
                }
                case COUNTRY_ISO_CODE: {
                    String countryIsoCode = country.getIsoCode();
                    if (countryIsoCode == null) continue block11;
                    geoData.put("country_iso_code", countryIsoCode);
                    break;
                }
                case COUNTRY_NAME: {
                    String countryName = country.getName();
                    if (countryName == null) continue block11;
                    geoData.put("country_name", countryName);
                    break;
                }
                case CONTINENT_NAME: {
                    String continentName = continent.getName();
                    if (continentName == null) continue block11;
                    geoData.put("continent_name", continentName);
                    break;
                }
                case REGION_ISO_CODE: {
                    String countryIso = country.getIsoCode();
                    String subdivisionIso = subdivision.getIsoCode();
                    if (countryIso == null || subdivisionIso == null) continue block11;
                    String regionIsoCode = countryIso + "-" + subdivisionIso;
                    geoData.put("region_iso_code", regionIsoCode);
                    break;
                }
                case REGION_NAME: {
                    String subdivisionName = subdivision.getName();
                    if (subdivisionName == null) continue block11;
                    geoData.put("region_name", subdivisionName);
                    break;
                }
                case CITY_NAME: {
                    String cityName = city.getName();
                    if (cityName == null) continue block11;
                    geoData.put("city_name", cityName);
                    break;
                }
                case TIMEZONE: {
                    String locationTimeZone = location.getTimeZone();
                    if (locationTimeZone == null) continue block11;
                    geoData.put("timezone", locationTimeZone);
                    break;
                }
                case LOCATION: {
                    Double latitude = location.getLatitude();
                    Double longitude = location.getLongitude();
                    if (latitude == null || longitude == null) break;
                    HashMap<String, Double> locationObject = new HashMap<String, Double>();
                    locationObject.put("lat", latitude);
                    locationObject.put("lon", longitude);
                    geoData.put("location", locationObject);
                }
            }
        }
        return geoData;
    }

    private Map<String, Object> retrieveCountryGeoData(GeoIpDatabase geoIpDatabase, InetAddress ipAddress) {
        CountryResponse response = geoIpDatabase.getCountry(ipAddress);
        if (response == null) {
            return Map.of();
        }
        Country country = response.getCountry();
        Continent continent = response.getContinent();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        block6: for (Property property : this.properties) {
            switch (property) {
                case IP: {
                    geoData.put("ip", NetworkAddress.format((InetAddress)ipAddress));
                    break;
                }
                case COUNTRY_ISO_CODE: {
                    String countryIsoCode = country.getIsoCode();
                    if (countryIsoCode == null) continue block6;
                    geoData.put("country_iso_code", countryIsoCode);
                    break;
                }
                case COUNTRY_NAME: {
                    String countryName = country.getName();
                    if (countryName == null) continue block6;
                    geoData.put("country_name", countryName);
                    break;
                }
                case CONTINENT_NAME: {
                    String continentName = continent.getName();
                    if (continentName == null) break;
                    geoData.put("continent_name", continentName);
                }
            }
        }
        return geoData;
    }

    private Map<String, Object> retrieveAsnGeoData(GeoIpDatabase geoIpDatabase, InetAddress ipAddress) {
        AsnResponse response = geoIpDatabase.getAsn(ipAddress);
        if (response == null) {
            return Map.of();
        }
        Long asn = response.getAutonomousSystemNumber();
        String organization_name = response.getAutonomousSystemOrganization();
        Network network = response.getNetwork();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        for (Property property : this.properties) {
            switch (property) {
                case IP: {
                    geoData.put("ip", NetworkAddress.format((InetAddress)ipAddress));
                    break;
                }
                case ASN: {
                    if (asn == null) break;
                    geoData.put("asn", asn);
                    break;
                }
                case ORGANIZATION_NAME: {
                    if (organization_name == null) break;
                    geoData.put("organization_name", organization_name);
                    break;
                }
                case NETWORK: {
                    if (network == null) break;
                    geoData.put("network", network.toString());
                }
            }
        }
        return geoData;
    }

    private static void tag(IngestDocument ingestDocument, String databaseName) {
        ingestDocument.appendFieldValue("tags", (Object)("_geoip_database_unavailable_" + databaseName), true);
    }

    static enum Property {
        IP,
        COUNTRY_ISO_CODE,
        COUNTRY_NAME,
        CONTINENT_NAME,
        REGION_ISO_CODE,
        REGION_NAME,
        CITY_NAME,
        TIMEZONE,
        LOCATION,
        ASN,
        ORGANIZATION_NAME,
        NETWORK;

        static final EnumSet<Property> ALL_CITY_PROPERTIES;
        static final EnumSet<Property> ALL_COUNTRY_PROPERTIES;
        static final EnumSet<Property> ALL_ASN_PROPERTIES;

        public static Property parseProperty(String databaseType, String value) {
            EnumSet<Property> validProperties = EnumSet.noneOf(Property.class);
            if (databaseType.endsWith(GeoIpProcessor.CITY_DB_SUFFIX)) {
                validProperties = ALL_CITY_PROPERTIES;
            } else if (databaseType.endsWith(GeoIpProcessor.COUNTRY_DB_SUFFIX)) {
                validProperties = ALL_COUNTRY_PROPERTIES;
            } else if (databaseType.endsWith(GeoIpProcessor.ASN_DB_SUFFIX)) {
                validProperties = ALL_ASN_PROPERTIES;
            }
            try {
                Property property = Property.valueOf(value.toUpperCase(Locale.ROOT));
                if (!validProperties.contains((Object)property)) {
                    throw new IllegalArgumentException("invalid");
                }
                return property;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("illegal property value [" + value + "]. valid values are " + Arrays.toString(validProperties.toArray()));
            }
        }

        static {
            ALL_CITY_PROPERTIES = EnumSet.of(IP, new Property[]{COUNTRY_ISO_CODE, COUNTRY_NAME, CONTINENT_NAME, REGION_ISO_CODE, REGION_NAME, CITY_NAME, TIMEZONE, LOCATION});
            ALL_COUNTRY_PROPERTIES = EnumSet.of(IP, CONTINENT_NAME, COUNTRY_NAME, COUNTRY_ISO_CODE);
            ALL_ASN_PROPERTIES = EnumSet.of(IP, ASN, ORGANIZATION_NAME, NETWORK);
        }
    }

    static class DatabaseUnavailableProcessor
    extends AbstractProcessor {
        private final String databaseName;

        DatabaseUnavailableProcessor(String tag, String description, String databaseName) {
            super(tag, description);
            this.databaseName = databaseName;
        }

        public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
            GeoIpProcessor.tag(ingestDocument, this.databaseName);
            return ingestDocument;
        }

        public String getType() {
            return GeoIpProcessor.TYPE;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }
    }

    public static final class Factory
    implements Processor.Factory {
        static final Set<Property> DEFAULT_CITY_PROPERTIES = Set.copyOf(EnumSet.of(Property.CONTINENT_NAME, new Property[]{Property.COUNTRY_NAME, Property.COUNTRY_ISO_CODE, Property.REGION_ISO_CODE, Property.REGION_NAME, Property.CITY_NAME, Property.LOCATION}));
        static final Set<Property> DEFAULT_COUNTRY_PROPERTIES = Set.copyOf(EnumSet.of(Property.CONTINENT_NAME, Property.COUNTRY_NAME, Property.COUNTRY_ISO_CODE));
        static final Set<Property> DEFAULT_ASN_PROPERTIES = Set.copyOf(EnumSet.of(Property.IP, Property.ASN, Property.ORGANIZATION_NAME, Property.NETWORK));
        private final GeoIpDatabaseProvider geoIpDatabaseProvider;

        public Factory(GeoIpDatabaseProvider geoIpDatabaseProvider) {
            this.geoIpDatabaseProvider = geoIpDatabaseProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Processor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws IOException {
            Set<Property> properties;
            String databaseType;
            GeoIpDatabase geoIpDatabase;
            String ipField = ConfigurationUtils.readStringProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)GeoIpProcessor.TYPE);
            String databaseFile = ConfigurationUtils.readStringProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"database_file", (String)"GeoLite2-City.mmdb");
            List propertyNames = ConfigurationUtils.readOptionalList((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"properties");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            boolean firstOnly = ConfigurationUtils.readBooleanProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"first_only", (boolean)true);
            Factory.downloadDatabaseOnPipelineCreation(config, processorTag);
            Object value = config.remove("fallback_to_default_databases");
            if (value != null) {
                DEPRECATION_LOGGER.warn(DeprecationCategory.OTHER, "default_databases_message", GeoIpProcessor.DEFAULT_DATABASES_DEPRECATION_MESSAGE, new Object[0]);
            }
            if ((geoIpDatabase = this.geoIpDatabaseProvider.getDatabase(databaseFile)) == null) {
                return new DatabaseUnavailableProcessor(processorTag, description, databaseFile);
            }
            try {
                databaseType = geoIpDatabase.getDatabaseType();
            }
            finally {
                geoIpDatabase.release();
            }
            if (propertyNames != null) {
                EnumSet<Property> modifiableProperties = EnumSet.noneOf(Property.class);
                for (String fieldName : propertyNames) {
                    try {
                        modifiableProperties.add(Property.parseProperty(databaseType, fieldName));
                    }
                    catch (IllegalArgumentException e) {
                        throw ConfigurationUtils.newConfigurationException((String)GeoIpProcessor.TYPE, (String)processorTag, (String)"properties", (String)e.getMessage());
                    }
                }
                properties = Set.copyOf(modifiableProperties);
            } else if (databaseType.endsWith(GeoIpProcessor.CITY_DB_SUFFIX)) {
                properties = DEFAULT_CITY_PROPERTIES;
            } else if (databaseType.endsWith(GeoIpProcessor.COUNTRY_DB_SUFFIX)) {
                properties = DEFAULT_COUNTRY_PROPERTIES;
            } else if (databaseType.endsWith(GeoIpProcessor.ASN_DB_SUFFIX)) {
                properties = DEFAULT_ASN_PROPERTIES;
            } else {
                throw ConfigurationUtils.newConfigurationException((String)GeoIpProcessor.TYPE, (String)processorTag, (String)"database_file", (String)("Unsupported database type [" + databaseType + "]"));
            }
            return new GeoIpProcessor(processorTag, description, ipField, new DatabaseVerifyingSupplier(this.geoIpDatabaseProvider, databaseFile, databaseType), () -> this.geoIpDatabaseProvider.isValid(databaseFile), targetField, properties, ignoreMissing, firstOnly, databaseFile);
        }

        public static boolean downloadDatabaseOnPipelineCreation(Map<String, Object> config) {
            return Factory.downloadDatabaseOnPipelineCreation(config, null);
        }

        public static boolean downloadDatabaseOnPipelineCreation(Map<String, Object> config, String processorTag) {
            return ConfigurationUtils.readBooleanProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"download_database_on_pipeline_creation", (boolean)true);
        }
    }

    public static final class DatabaseVerifyingSupplier
    implements CheckedSupplier<GeoIpDatabase, IOException> {
        private final GeoIpDatabaseProvider geoIpDatabaseProvider;
        private final String databaseFile;
        private final String databaseType;

        public DatabaseVerifyingSupplier(GeoIpDatabaseProvider geoIpDatabaseProvider, String databaseFile, String databaseType) {
            this.geoIpDatabaseProvider = geoIpDatabaseProvider;
            this.databaseFile = databaseFile;
            this.databaseType = databaseType;
        }

        public GeoIpDatabase get() throws IOException {
            GeoIpDatabase loader = this.geoIpDatabaseProvider.getDatabase(this.databaseFile);
            if (loader == null) {
                return null;
            }
            if (Assertions.ENABLED) {
                String expectedSuffix = this.databaseType.substring(this.databaseType.lastIndexOf(45));
                assert (loader.getDatabaseType().endsWith(expectedSuffix)) : "database type [" + loader.getDatabaseType() + "] doesn't match with expected suffix [" + expectedSuffix + "]";
            }
            return loader;
        }
    }
}

