/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.transport.TaskTransportChannel;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TcpTransportChannel;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.netty4.Netty4TcpChannel;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.action.SecurityActionMapper;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.transport.SSLEngineUtils;

class ServerTransportFilter {
    private static final Logger logger = LogManager.getLogger(ServerTransportFilter.class);
    private final AuthenticationService authcService;
    private final AuthorizationService authzService;
    private final SecurityActionMapper actionMapper = new SecurityActionMapper();
    private final ThreadContext threadContext;
    private final boolean extractClientCert;
    private final DestructiveOperations destructiveOperations;
    private final SecurityContext securityContext;

    ServerTransportFilter(AuthenticationService authcService, AuthorizationService authzService, ThreadContext threadContext, boolean extractClientCert, DestructiveOperations destructiveOperations, SecurityContext securityContext) {
        this.authcService = authcService;
        this.authzService = authzService;
        this.threadContext = threadContext;
        this.extractClientCert = extractClientCert;
        this.destructiveOperations = destructiveOperations;
        this.securityContext = securityContext;
    }

    void inbound(String action, TransportRequest request, TransportChannel transportChannel, ActionListener<Void> listener) {
        TcpChannel tcpChannel;
        if ("indices:admin/close".equals(action) || "indices:admin/open".equals(action) || "indices:admin/delete".equals(action)) {
            IndicesRequest indicesRequest = (IndicesRequest)request;
            try {
                this.destructiveOperations.failDestructive(indicesRequest.indices());
            }
            catch (IllegalArgumentException e) {
                listener.onFailure((Exception)e);
                return;
            }
        }
        String securityAction = SecurityActionMapper.action(action, request);
        TransportChannel unwrappedChannel = transportChannel;
        if (unwrappedChannel instanceof TaskTransportChannel) {
            unwrappedChannel = ((TaskTransportChannel)unwrappedChannel).getChannel();
        }
        if (this.extractClientCert && unwrappedChannel instanceof TcpTransportChannel && (tcpChannel = ((TcpTransportChannel)unwrappedChannel).getChannel()) instanceof Netty4TcpChannel && tcpChannel.isOpen()) {
            SSLEngineUtils.extractClientCertificates(logger, this.threadContext, tcpChannel);
        }
        TransportVersion version = transportChannel.getVersion();
        this.authenticate(securityAction, request, (ActionListener<Authentication>)listener.delegateFailureAndWrap((l, authentication) -> {
            if (authentication != null) {
                if (securityAction.equals("internal:transport/handshake") && !SystemUser.is((User)authentication.getEffectiveSubject().getUser())) {
                    this.securityContext.executeAsSystemUser(version, original -> {
                        Authentication replaced = this.securityContext.getAuthentication();
                        this.authzService.authorize(replaced, securityAction, request, (ActionListener<Void>)l);
                    });
                } else {
                    this.authzService.authorize((Authentication)authentication, securityAction, request, (ActionListener<Void>)l);
                }
            } else {
                l.onFailure((Exception)new IllegalStateException("no authentication present but auth is allowed"));
            }
        }));
    }

    protected void authenticate(String securityAction, TransportRequest request, ActionListener<Authentication> authenticationListener) {
        this.authcService.authenticate(securityAction, request, true, authenticationListener);
    }

    protected final ThreadContext getThreadContext() {
        return this.threadContext;
    }

    boolean isExtractClientCert() {
        return this.extractClientCert;
    }
}

