/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action;

import java.io.IOException;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.xpack.core.XPackSettings;

public abstract class SecurityBaseRestHandler
extends BaseRestHandler {
    protected final Settings settings;
    protected final XPackLicenseState licenseState;

    protected SecurityBaseRestHandler(Settings settings, XPackLicenseState licenseState) {
        this.settings = settings;
        this.licenseState = licenseState;
    }

    protected final BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        Exception failedFeature = this.checkFeatureAvailable(request);
        if (failedFeature == null) {
            return this.innerPrepareRequest(request, client);
        }
        request.params().keySet().forEach(key -> request.param(key, ""));
        request.content();
        return channel -> channel.sendResponse(new RestResponse(channel, failedFeature));
    }

    public final Exception checkFeatureAvailable(RestRequest request) {
        if (!((Boolean)XPackSettings.SECURITY_ENABLED.get(this.settings)).booleanValue()) {
            return new IllegalStateException("Security is not enabled but a security rest handler is registered");
        }
        return this.innerCheckFeatureAvailable(request);
    }

    protected Exception innerCheckFeatureAvailable(RestRequest request) {
        return null;
    }

    protected abstract BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest var1, NodeClient var2) throws IOException;
}

