/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.rest.FilterRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.xpack.core.security.authc.support.SecondaryAuthentication;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.authc.support.SecondaryAuthenticator;
import org.elasticsearch.xpack.security.authz.restriction.WorkflowService;
import org.elasticsearch.xpack.security.operator.OperatorPrivileges;

public class SecurityRestFilter
extends FilterRestHandler
implements RestHandler {
    private static final Logger logger = LogManager.getLogger(SecurityRestFilter.class);
    private final SecondaryAuthenticator secondaryAuthenticator;
    private final AuditTrailService auditTrailService;
    private final boolean enabled;
    private final ThreadContext threadContext;
    private final WorkflowService workflowService;
    private final OperatorPrivileges.OperatorPrivilegesService operatorPrivilegesService;

    public SecurityRestFilter(boolean enabled, ThreadContext threadContext, SecondaryAuthenticator secondaryAuthenticator, AuditTrailService auditTrailService, WorkflowService workflowService, RestHandler restHandler, OperatorPrivileges.OperatorPrivilegesService operatorPrivilegesService) {
        super(restHandler);
        this.enabled = enabled;
        this.threadContext = threadContext;
        this.secondaryAuthenticator = secondaryAuthenticator;
        this.auditTrailService = auditTrailService;
        this.workflowService = workflowService;
        this.operatorPrivilegesService = operatorPrivilegesService == null ? OperatorPrivileges.NOOP_OPERATOR_PRIVILEGES_SERVICE : operatorPrivilegesService;
    }

    public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        if (request.method() == RestRequest.Method.OPTIONS) {
            this.handleException(request, channel, (Exception)new ElasticsearchSecurityException("Cannot dispatch OPTIONS request, as they are not authenticated", new Object[0]));
            return;
        }
        if (!this.enabled) {
            this.doHandleRequest(request, channel, client);
            return;
        }
        RestRequest wrappedRequest = this.maybeWrapRestRequest(request);
        this.auditTrailService.get().authenticationSuccess(wrappedRequest);
        this.secondaryAuthenticator.authenticateAndAttachToContext(wrappedRequest, (ActionListener<SecondaryAuthentication>)ActionListener.wrap(secondaryAuthentication -> {
            if (secondaryAuthentication != null) {
                logger.trace("Found secondary authentication {} in REST request [{}]", secondaryAuthentication, (Object)request.uri());
            }
            this.workflowService.resolveWorkflowAndStoreInThreadContext(this.getConcreteRestHandler(), this.threadContext);
            this.doHandleRequest(request, channel, client);
        }, e -> this.handleException(request, channel, (Exception)e)));
    }

    private void doHandleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        this.threadContext.sanitizeHeaders();
        if (this.operatorPrivilegesService.checkRest(this.getConcreteRestHandler(), request, channel, this.threadContext)) {
            try {
                this.getDelegate().handleRequest(request, channel, client);
            }
            catch (Exception e) {
                logger.debug(() -> Strings.format((String)"Request handling failed for REST request [%s]", (Object[])new Object[]{request.uri()}), (Throwable)e);
                throw e;
            }
        }
    }

    protected void handleException(RestRequest request, RestChannel channel, Exception e) {
        logger.debug(() -> Strings.format((String)"failed for REST request [%s]", (Object[])new Object[]{request.uri()}), (Throwable)e);
        this.threadContext.sanitizeHeaders();
        try {
            channel.sendResponse(new RestResponse(channel, e));
        }
        catch (Exception inner) {
            inner.addSuppressed(e);
            logger.error(() -> "failed to send failure response for uri [" + request.uri() + "]", (Throwable)inner);
        }
    }

    OperatorPrivileges.OperatorPrivilegesService getOperatorPrivilegesService() {
        return this.operatorPrivilegesService;
    }

    private RestRequest maybeWrapRestRequest(RestRequest restRequest) {
        RestHandler restHandler = this.getConcreteRestHandler();
        if (restHandler instanceof RestRequestFilter) {
            RestRequestFilter rrf = (RestRequestFilter)restHandler;
            return rrf.getFilteredRequest(restRequest);
        }
        return restRequest;
    }
}

