/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.enrollment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoAction;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoMetrics;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.transport.TransportInfo;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.EnrollmentToken;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.enrollment.BaseEnrollmentTokenGenerator;

public class InternalEnrollmentTokenGenerator
extends BaseEnrollmentTokenGenerator {
    private static final Logger LOGGER = LogManager.getLogger(InternalEnrollmentTokenGenerator.class);
    private final Environment environment;
    private final SSLService sslService;
    private final Client client;

    public InternalEnrollmentTokenGenerator(Environment environment, SSLService sslService, Client client) {
        this.environment = environment;
        this.sslService = sslService;
        this.client = new OriginSettingClient(client, "security");
    }

    public void maybeCreateNodeEnrollmentToken(Consumer<String> consumer, Iterator<TimeValue> backoff) {
        NodesInfoRequest nodesInfoRequest = ((NodesInfoRequest)new NodesInfoRequest(new String[0]).nodesIds(new String[]{"_local"})).addMetrics(new String[]{NodesInfoMetrics.Metric.HTTP.metricName(), NodesInfoMetrics.Metric.TRANSPORT.metricName()});
        this.client.execute((ActionType)NodesInfoAction.INSTANCE, (ActionRequest)nodesInfoRequest, ActionListener.wrap(response -> {
            assert (response.getNodes().size() == 1);
            NodeInfo nodeInfo = (NodeInfo)response.getNodes().get(0);
            TransportInfo transportInfo = (TransportInfo)nodeInfo.getInfo(TransportInfo.class);
            HttpInfo httpInfo = (HttpInfo)nodeInfo.getInfo(HttpInfo.class);
            if (null == transportInfo || null == httpInfo) {
                if (backoff.hasNext()) {
                    LOGGER.debug("Local node's HTTP/transport info is not yet available, will retry...");
                    this.client.threadPool().schedule(() -> this.maybeCreateNodeEnrollmentToken(consumer, backoff), (TimeValue)backoff.next(), (Executor)this.client.threadPool().generic());
                } else {
                    LOGGER.warn("Unable to get local node's HTTP/transport info after all retries.");
                    consumer.accept(null);
                }
            } else {
                boolean noNonLocalTransportAddresses = ((List)InternalEnrollmentTokenGenerator.splitAddresses(InternalEnrollmentTokenGenerator.getAllTransportAddresses(transportInfo)).v2()).isEmpty();
                if (noNonLocalTransportAddresses) {
                    LOGGER.info("Will not generate node enrollment token because node is only bound on localhost for transport and cannot connect to nodes from other hosts");
                    consumer.accept("");
                    return;
                }
                boolean noNonLocalHttpAddresses = ((List)InternalEnrollmentTokenGenerator.splitAddresses(InternalEnrollmentTokenGenerator.getAllHttpAddresses(httpInfo)).v2()).isEmpty();
                if (noNonLocalHttpAddresses) {
                    LOGGER.info("Will not generate node enrollment token because node is only bound on localhost for HTTPS and cannot enroll nodes from other hosts");
                    consumer.accept("");
                    return;
                }
                LOGGER.debug("Attempting to generate the node enrollment token");
                this.assembleToken(EnrollmentTokenType.NODE, httpInfo, token -> {
                    if (null == token) {
                        consumer.accept(null);
                    } else {
                        try {
                            LOGGER.debug("Successfully generated the node enrollment token");
                            consumer.accept(token.getEncoded());
                        }
                        catch (Exception e) {
                            LOGGER.error("Failed to encode node enrollment token", (Throwable)e);
                            consumer.accept(null);
                        }
                    }
                });
            }
        }, e -> {
            LOGGER.error("Failed to create node enrollment token when retrieving local node's HTTP/transport info", (Throwable)e);
            consumer.accept(null);
        }));
    }

    public void createKibanaEnrollmentToken(Consumer<EnrollmentToken> consumer, Iterator<TimeValue> backoff) {
        NodesInfoRequest nodesInfoRequest = ((NodesInfoRequest)new NodesInfoRequest(new String[0]).nodesIds(new String[]{"_local"})).addMetric(NodesInfoMetrics.Metric.HTTP.metricName());
        this.client.execute((ActionType)NodesInfoAction.INSTANCE, (ActionRequest)nodesInfoRequest, ActionListener.wrap(response -> {
            assert (response.getNodes().size() == 1);
            NodeInfo nodeInfo = (NodeInfo)response.getNodes().get(0);
            HttpInfo httpInfo = (HttpInfo)nodeInfo.getInfo(HttpInfo.class);
            if (null == httpInfo) {
                if (backoff.hasNext()) {
                    LOGGER.info("Local node's HTTP info is not yet available, will retry...");
                    this.client.threadPool().schedule(() -> this.createKibanaEnrollmentToken(consumer, backoff), (TimeValue)backoff.next(), (Executor)this.client.threadPool().generic());
                } else {
                    LOGGER.warn("Unable to get local node's HTTP info after all retries.");
                    consumer.accept(null);
                }
            } else {
                this.assembleToken(EnrollmentTokenType.KIBANA, httpInfo, consumer);
            }
        }, e -> {
            LOGGER.error("Failed to create kibana enrollment token when retrieving local nodes HTTP info", (Throwable)e);
            consumer.accept(null);
        }));
    }

    private void assembleToken(EnrollmentTokenType enrollTokenType, HttpInfo httpInfo, Consumer<EnrollmentToken> consumer) {
        List<String> tokenAddresses;
        String fingerprint;
        if (!((Boolean)XPackSettings.ENROLLMENT_ENABLED.get(this.environment.settings())).booleanValue()) {
            LOGGER.error("Cannot create enrollment token [" + enrollTokenType + "] because enrollment is disabled with setting [" + XPackSettings.ENROLLMENT_ENABLED.getKey() + "] set to [false]");
            consumer.accept(null);
            return;
        }
        try {
            fingerprint = this.getHttpsCaFingerprint();
        }
        catch (Exception e2) {
            LOGGER.error("Failed to create enrollment token when computing HTTPS CA fingerprint, possibly the certs are not auto-generated", (Throwable)e2);
            consumer.accept(null);
            return;
        }
        try {
            List<String> httpAddressesList = InternalEnrollmentTokenGenerator.getAllHttpAddresses(httpInfo);
            tokenAddresses = InternalEnrollmentTokenGenerator.getFilteredAddresses(httpAddressesList);
        }
        catch (Exception e3) {
            LOGGER.error("Failed to create enrollment when extracting HTTPS bound addresses", (Throwable)e3);
            consumer.accept(null);
            return;
        }
        CreateApiKeyRequest apiKeyRequest = new CreateApiKeyRequest("enrollment_token_API_key_" + UUIDs.base64UUID(), List.of(new RoleDescriptor("create_enrollment_token", new String[]{enrollTokenType.toString()}, null, null)), TimeValue.timeValueMinutes((long)30L));
        apiKeyRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.client.execute((ActionType)CreateApiKeyAction.INSTANCE, (ActionRequest)apiKeyRequest, ActionListener.wrap(createApiKeyResponse -> {
            String apiKey = createApiKeyResponse.getId() + ":" + createApiKeyResponse.getKey().toString();
            EnrollmentToken enrollmentToken = new EnrollmentToken(apiKey, fingerprint, Version.CURRENT.toString(), tokenAddresses);
            consumer.accept(enrollmentToken);
        }, e -> {
            LOGGER.error("Failed to create enrollment token when generating API key", (Throwable)e);
            consumer.accept(null);
        }));
    }

    public String getHttpsCaFingerprint() throws Exception {
        return InternalEnrollmentTokenGenerator.getHttpsCaFingerprint(this.sslService);
    }

    private static List<String> getAllHttpAddresses(HttpInfo httpInfo) {
        ArrayList<String> httpAddressesList = new ArrayList<String>();
        InternalEnrollmentTokenGenerator.collectAllAddresses(httpInfo.getAddress(), httpAddressesList);
        return httpAddressesList;
    }

    private static List<String> getAllTransportAddresses(TransportInfo transportInfo) {
        ArrayList<String> transportAddressesList = new ArrayList<String>();
        InternalEnrollmentTokenGenerator.collectAllAddresses(transportInfo.getAddress(), transportAddressesList);
        transportInfo.getProfileAddresses().values().forEach(profileAddress -> InternalEnrollmentTokenGenerator.collectAllAddresses(profileAddress, transportAddressesList));
        return transportAddressesList;
    }

    private static void collectAllAddresses(BoundTransportAddress address, List<String> collectedAddressesList) {
        collectedAddressesList.add(address.publishAddress().toString());
        Arrays.stream(address.boundAddresses()).map(TransportAddress::toString).forEach(collectedAddressesList::add);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum EnrollmentTokenType {
        KIBANA{

            public String toString() {
                return "cluster:admin/xpack/security/enroll/kibana";
            }
        }
        ,
        NODE{

            public String toString() {
                return "cluster:admin/xpack/security/enroll/node";
            }
        };

    }
}

