/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.ScrollHelper;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheAction;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheRequest;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheResponse;
import org.elasticsearch.xpack.core.security.action.role.DeleteRoleRequest;
import org.elasticsearch.xpack.core.security.action.role.PutRoleRequest;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.store.RoleRetrievalResult;
import org.elasticsearch.xpack.core.security.support.NativeRealmValidationUtil;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class NativeRolesStore
implements BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>> {
    public static final String NATIVE_ROLES_ENABLED = "xpack.security.authc.native_roles.enabled";
    private static final Logger logger = LogManager.getLogger(NativeRolesStore.class);
    private final Settings settings;
    private final Client client;
    private final XPackLicenseState licenseState;
    private final boolean enabled;
    private final SecurityIndexManager securityIndex;
    private final ClusterService clusterService;

    public NativeRolesStore(Settings settings, Client client, XPackLicenseState licenseState, SecurityIndexManager securityIndex, ClusterService clusterService) {
        this.settings = settings;
        this.client = client;
        this.licenseState = licenseState;
        this.securityIndex = securityIndex;
        this.clusterService = clusterService;
        this.enabled = settings.getAsBoolean(NATIVE_ROLES_ENABLED, Boolean.valueOf(true));
    }

    @Override
    public void accept(Set<String> names, ActionListener<RoleRetrievalResult> listener) {
        this.getRoleDescriptors(names, listener);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void getRoleDescriptors(Set<String> names, ActionListener<RoleRetrievalResult> listener) {
        block8: {
            block7: {
                if (!this.enabled) {
                    listener.onResponse((Object)RoleRetrievalResult.success(Set.of()));
                    return;
                }
                SecurityIndexManager frozenSecurityIndex = this.securityIndex.freeze();
                if (!frozenSecurityIndex.indexExists()) {
                    listener.onResponse((Object)RoleRetrievalResult.success(Collections.emptySet()));
                    return;
                }
                if (!frozenSecurityIndex.isAvailable()) {
                    listener.onResponse((Object)RoleRetrievalResult.failure((Exception)frozenSecurityIndex.getUnavailableReason()));
                    return;
                }
                if (names == null) break block7;
                if (!names.isEmpty()) break block8;
            }
            this.securityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                TermQueryBuilder query = QueryBuilders.termQuery((String)RoleDescriptor.Fields.TYPE.getPreferredName(), (String)"role");
                Supplier supplier = this.client.threadPool().getThreadContext().newRestorableContext(false);
                try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("security");){
                    SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".security"}).setScroll((TimeValue)SearchService.DEFAULT_KEEPALIVE_SETTING.get(this.settings)).setQuery((QueryBuilder)query).setSize(1000).setFetchSource(true).request();
                    request.indicesOptions().ignoreUnavailable();
                    ScrollHelper.fetchAllByEntity((Client)this.client, (SearchRequest)request, (ActionListener)new ContextPreservingActionListener(supplier, ActionListener.wrap(roles -> listener.onResponse((Object)RoleRetrievalResult.success(new HashSet(roles))), e -> listener.onResponse((Object)RoleRetrievalResult.failure((Exception)e)))), hit -> NativeRolesStore.transformRole(hit.getId(), hit.getSourceRef(), logger, this.licenseState));
                }
            });
            return;
        }
        if (names.size() == 1) {
            this.getRoleDescriptor(Objects.requireNonNull(names.iterator().next()), listener);
            return;
        }
        this.securityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
            String[] roleIds = (String[])names.stream().map(NativeRolesStore::getIdForRole).toArray(String[]::new);
            MultiGetRequest multiGetRequest = (MultiGetRequest)this.client.prepareMultiGet().addIds(".security", roleIds).request();
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)multiGetRequest, (ActionListener)ActionListener.wrap(mGetResponse -> {
                MultiGetItemResponse[] responses = mGetResponse.getResponses();
                HashSet<RoleDescriptor> descriptors = new HashSet<RoleDescriptor>();
                for (int i = 0; i < responses.length; ++i) {
                    MultiGetItemResponse item = responses[i];
                    if (item.isFailed()) {
                        Exception failure = item.getFailure().getFailure();
                        for (int j = i + 1; j < responses.length; ++j) {
                            item = responses[j];
                            if (!item.isFailed()) continue;
                            failure.addSuppressed(failure);
                        }
                        listener.onResponse((Object)RoleRetrievalResult.failure((Exception)failure));
                        return;
                    }
                    if (!item.getResponse().isExists()) continue;
                    descriptors.add(this.transformRole(item.getResponse()));
                }
                listener.onResponse((Object)RoleRetrievalResult.success(descriptors));
            }, e -> listener.onResponse((Object)RoleRetrievalResult.failure((Exception)e))), (arg_0, arg_1) -> ((Client)this.client).multiGet(arg_0, arg_1));
        });
    }

    public void deleteRole(final DeleteRoleRequest deleteRoleRequest, final ActionListener<Boolean> listener) {
        if (!this.enabled) {
            listener.onFailure((Exception)new IllegalStateException("Native role management is disabled"));
            return;
        }
        SecurityIndexManager frozenSecurityIndex = this.securityIndex.freeze();
        if (!frozenSecurityIndex.indexExists()) {
            listener.onResponse((Object)false);
        } else if (!frozenSecurityIndex.isAvailable()) {
            listener.onFailure((Exception)frozenSecurityIndex.getUnavailableReason());
        } else {
            this.securityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                DeleteRequest request = (DeleteRequest)this.client.prepareDelete(".security", NativeRolesStore.getIdForRole(deleteRoleRequest.name())).request();
                request.setRefreshPolicy(deleteRoleRequest.getRefreshPolicy());
                ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)request, (ActionListener)new ActionListener<DeleteResponse>(){

                    public void onResponse(DeleteResponse deleteResponse) {
                        NativeRolesStore.this.clearRoleCache(deleteRoleRequest.name(), listener, deleteResponse.getResult() == DocWriteResponse.Result.DELETED);
                    }

                    public void onFailure(Exception e) {
                        logger.error("failed to delete role from the index", (Throwable)e);
                        listener.onFailure(e);
                    }
                }, (arg_0, arg_1) -> ((Client)this.client).delete(arg_0, arg_1));
            });
        }
    }

    public void putRole(PutRoleRequest request, RoleDescriptor role, ActionListener<Boolean> listener) {
        if (!this.enabled) {
            listener.onFailure((Exception)new IllegalStateException("Native role management is disabled"));
            return;
        }
        if (role.isUsingDocumentOrFieldLevelSecurity() && !SecurityField.DOCUMENT_LEVEL_SECURITY_FEATURE.checkWithoutTracking(this.licenseState)) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"field and document level security"));
        } else if (role.hasRemoteIndicesPrivileges() && this.clusterService.state().getMinTransportVersion().before((VersionId)RemoteClusterPortSettings.TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY)) {
            listener.onFailure((Exception)new IllegalStateException("all nodes must have transport version [" + RemoteClusterPortSettings.TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY + "] or higher to support remote indices privileges"));
        } else {
            this.innerPutRole(request, role, listener);
        }
    }

    void innerPutRole(PutRoleRequest request, RoleDescriptor role, final ActionListener<Boolean> listener) {
        final String roleName = role.getName();
        assert (NativeRealmValidationUtil.validateRoleName((String)roleName, (boolean)false) == null) : "Role name was invalid or reserved: " + roleName;
        assert (!role.hasRestriction()) : "restriction is not supported for native roles";
        this.securityIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
            XContentBuilder xContentBuilder;
            try {
                xContentBuilder = role.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS, true);
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
                return;
            }
            final IndexRequest indexRequest = (IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(".security").setId(NativeRolesStore.getIdForRole(roleName)).setSource(xContentBuilder).setRefreshPolicy(request.getRefreshPolicy())).request();
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)indexRequest, (ActionListener)new ActionListener<DocWriteResponse>(){

                public void onResponse(DocWriteResponse indexResponse) {
                    boolean created = indexResponse.getResult() == DocWriteResponse.Result.CREATED;
                    logger.trace("Created role: [{}]", (Object)indexRequest);
                    NativeRolesStore.this.clearRoleCache(roleName, listener, created);
                }

                public void onFailure(Exception e) {
                    logger.error(() -> "failed to put role [" + roleName + "]", (Throwable)e);
                    listener.onFailure(e);
                }
            }, (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1));
        });
    }

    public void usageStats(ActionListener<Map<String, Object>> listener) {
        final Map usageStats = Maps.newMapWithExpectedSize((int)3);
        if (!this.securityIndex.isAvailable()) {
            usageStats.put("size", 0L);
            usageStats.put("fls", false);
            usageStats.put("dls", false);
            listener.onResponse((Object)usageStats);
        } else {
            this.securityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((MultiSearchRequest)this.client.prepareMultiSearch().add(this.client.prepareSearch(new String[]{".security"}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)RoleDescriptor.Fields.TYPE.getPreferredName(), (String)"role")).setTrackTotalHits(true).setSize(0)).add(this.client.prepareSearch(new String[]{".security"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)RoleDescriptor.Fields.TYPE.getPreferredName(), (String)"role")).must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.existsQuery((String)"indices.field_security.grant")).should((QueryBuilder)QueryBuilders.existsQuery((String)"indices.field_security.except")).should((QueryBuilder)QueryBuilders.existsQuery((String)"indices.fields")))).setTrackTotalHits(true).setSize(0).setTerminateAfter(1)).add(this.client.prepareSearch(new String[]{".security"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)RoleDescriptor.Fields.TYPE.getPreferredName(), (String)"role")).filter((QueryBuilder)QueryBuilders.existsQuery((String)"indices.query"))).setTrackTotalHits(true).setSize(0).setTerminateAfter(1)).add(this.client.prepareSearch(new String[]{".security"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)RoleDescriptor.Fields.TYPE.getPreferredName(), (String)"role")).filter((QueryBuilder)QueryBuilders.existsQuery((String)"remote_indices"))).setTrackTotalHits(true).setSize(0)).request()), (ActionListener)new DelegatingActionListener<MultiSearchResponse, Map<String, Object>>(listener){

                public void onResponse(MultiSearchResponse items) {
                    MultiSearchResponse.Item[] responses = items.getResponses();
                    if (responses[0].isFailure()) {
                        usageStats.put("size", 0);
                    } else {
                        usageStats.put("size", responses[0].getResponse().getHits().getTotalHits().value);
                    }
                    if (responses[1].isFailure()) {
                        usageStats.put("fls", false);
                    } else {
                        usageStats.put("fls", responses[1].getResponse().getHits().getTotalHits().value > 0L);
                    }
                    if (responses[2].isFailure()) {
                        usageStats.put("dls", false);
                    } else {
                        usageStats.put("dls", responses[2].getResponse().getHits().getTotalHits().value > 0L);
                    }
                    if (responses[3].isFailure()) {
                        usageStats.put("remote_indices", 0);
                    } else {
                        usageStats.put("remote_indices", responses[3].getResponse().getHits().getTotalHits().value);
                    }
                    this.delegate.onResponse((Object)usageStats);
                }
            }, (arg_0, arg_1) -> ((Client)this.client).multiSearch(arg_0, arg_1)));
        }
    }

    public String toString() {
        return "native roles store";
    }

    private void getRoleDescriptor(String roleId, final ActionListener<RoleRetrievalResult> resultListener) {
        SecurityIndexManager frozenSecurityIndex = this.securityIndex.freeze();
        if (!frozenSecurityIndex.indexExists()) {
            resultListener.onResponse((Object)RoleRetrievalResult.success(Collections.emptySet()));
        } else if (!frozenSecurityIndex.isAvailable()) {
            resultListener.onResponse((Object)RoleRetrievalResult.failure((Exception)frozenSecurityIndex.getUnavailableReason()));
        } else {
            this.securityIndex.checkIndexVersionThenExecute(e -> resultListener.onResponse((Object)RoleRetrievalResult.failure((Exception)e)), () -> this.executeGetRoleRequest(roleId, new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    RoleDescriptor descriptor = NativeRolesStore.this.transformRole(response);
                    resultListener.onResponse((Object)RoleRetrievalResult.success(descriptor == null ? Collections.emptySet() : Collections.singleton(descriptor)));
                }

                public void onFailure(Exception e) {
                    resultListener.onResponse((Object)RoleRetrievalResult.failure((Exception)e));
                }
            }));
        }
    }

    private void executeGetRoleRequest(String role, ActionListener<GetResponse> listener) {
        this.securityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((GetRequest)this.client.prepareGet(".security", NativeRolesStore.getIdForRole(role)).request()), (ActionListener)listener, (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1)));
    }

    private <Response> void clearRoleCache(final String role, final ActionListener<Response> listener, final Response response) {
        ClearRolesCacheRequest request = new ClearRolesCacheRequest().names(new String[]{role});
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)ClearRolesCacheAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<ClearRolesCacheResponse>(){

            public void onResponse(ClearRolesCacheResponse nodes) {
                listener.onResponse(response);
            }

            public void onFailure(Exception e) {
                logger.error(() -> "unable to clear cache for role [" + role + "]", (Throwable)e);
                ElasticsearchException exception = new ElasticsearchException("clearing the cache for [" + role + "] failed. please clear the role cache manually", (Throwable)e, new Object[0]);
                listener.onFailure((Exception)exception);
            }
        });
    }

    @Nullable
    private RoleDescriptor transformRole(GetResponse response) {
        if (!response.isExists()) {
            return null;
        }
        return NativeRolesStore.transformRole(response.getId(), response.getSourceAsBytesRef(), logger, this.licenseState);
    }

    @Nullable
    static RoleDescriptor transformRole(String id, BytesReference sourceBytes, Logger logger, XPackLicenseState licenseState) {
        assert (id.startsWith("role")) : "[" + id + "] does not have role prefix";
        String name = id.substring("role".length() + 1);
        try {
            RoleDescriptor roleDescriptor = RoleDescriptor.parse((String)name, (BytesReference)sourceBytes, (boolean)true, (XContentType)XContentType.JSON, (boolean)false);
            boolean dlsEnabled = Arrays.stream(roleDescriptor.getIndicesPrivileges()).anyMatch(RoleDescriptor.IndicesPrivileges::isUsingDocumentLevelSecurity);
            boolean flsEnabled = Arrays.stream(roleDescriptor.getIndicesPrivileges()).anyMatch(RoleDescriptor.IndicesPrivileges::isUsingFieldLevelSecurity);
            if ((dlsEnabled || flsEnabled) && !SecurityField.DOCUMENT_LEVEL_SECURITY_FEATURE.checkWithoutTracking(licenseState)) {
                ArrayList<String> unlicensedFeatures = new ArrayList<String>(2);
                if (flsEnabled) {
                    unlicensedFeatures.add("fls");
                }
                if (dlsEnabled) {
                    unlicensedFeatures.add("dls");
                }
                Map transientMap = Maps.newMapWithExpectedSize((int)2);
                transientMap.put("unlicensed_features", unlicensedFeatures);
                transientMap.put("enabled", false);
                return new RoleDescriptor(roleDescriptor.getName(), roleDescriptor.getClusterPrivileges(), roleDescriptor.getIndicesPrivileges(), roleDescriptor.getApplicationPrivileges(), roleDescriptor.getConditionalClusterPrivileges(), roleDescriptor.getRunAs(), roleDescriptor.getMetadata(), transientMap, roleDescriptor.getRemoteIndicesPrivileges(), roleDescriptor.getRestriction());
            }
            return roleDescriptor;
        }
        catch (Exception e) {
            logger.error("error in the format of data for role [" + name + "]", (Throwable)e);
            return null;
        }
    }

    private static String getIdForRole(String roleName) {
        return "role-" + roleName;
    }
}

