/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.pki;

import java.lang.invoke.CallSite;
import java.security.MessageDigest;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.common.ssl.SslTrustConfig;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.pki.PkiRealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.core.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.ssl.SslSettingsLoader;
import org.elasticsearch.xpack.security.authc.BytesKey;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.pki.X509AuthenticationToken;
import org.elasticsearch.xpack.security.authc.support.DelegatedAuthorizationSupport;
import org.elasticsearch.xpack.security.authc.support.mapper.CompositeRoleMapper;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;

public class PkiRealm
extends Realm
implements CachingRealm {
    public static final String PKI_CERT_HEADER_NAME = "__SECURITY_CLIENT_CERTIFICATE";
    private static final String AUTH_TYPE = "UNKNOWN";
    private final ReleasableLock readLock;
    private final ReleasableLock writeLock;
    private final X509TrustManager trustManager;
    private final Pattern principalPattern;
    private final UserRoleMapper roleMapper;
    private final Cache<BytesKey, User> cache;
    private DelegatedAuthorizationSupport delegatedRealms;
    private final boolean delegationEnabled;

    public PkiRealm(RealmConfig config, ResourceWatcherService watcherService, NativeRoleMappingStore nativeRoleMappingStore) {
        this(config, new CompositeRoleMapper(config, watcherService, nativeRoleMappingStore));
    }

    PkiRealm(RealmConfig config, UserRoleMapper roleMapper) {
        super(config);
        ReentrantReadWriteLock iterationLock = new ReentrantReadWriteLock();
        this.readLock = new ReleasableLock(iterationLock.readLock());
        this.writeLock = new ReleasableLock(iterationLock.writeLock());
        this.delegationEnabled = (Boolean)config.getSetting(PkiRealmSettings.DELEGATION_ENABLED_SETTING);
        this.trustManager = this.trustManagers(config);
        this.principalPattern = (Pattern)config.getSetting(PkiRealmSettings.USERNAME_PATTERN_SETTING);
        this.roleMapper = roleMapper;
        this.roleMapper.refreshRealmOnChange((CachingRealm)this);
        this.cache = CacheBuilder.builder().setExpireAfterWrite((TimeValue)config.getSetting(PkiRealmSettings.CACHE_TTL_SETTING)).setMaximumWeight((long)((Integer)config.getSetting(PkiRealmSettings.CACHE_MAX_USERS_SETTING)).intValue()).build();
        this.delegatedRealms = null;
        this.validateAuthenticationDelegationConfiguration(config);
    }

    public void initialize(Iterable<Realm> realms, XPackLicenseState licenseState) {
        if (this.delegatedRealms != null) {
            throw new IllegalStateException("Realm has already been initialized");
        }
        this.delegatedRealms = new DelegatedAuthorizationSupport(realms, this.config, licenseState);
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof X509AuthenticationToken;
    }

    public X509AuthenticationToken token(ThreadContext context) {
        Object pkiHeaderValue = context.getTransient(PKI_CERT_HEADER_NAME);
        if (pkiHeaderValue == null) {
            return null;
        }
        assert (pkiHeaderValue instanceof X509Certificate[]);
        X509Certificate[] certificates = (X509Certificate[])pkiHeaderValue;
        if (certificates.length == 0) {
            return null;
        }
        X509AuthenticationToken token = new X509AuthenticationToken(certificates);
        String parsedPrincipal = PkiRealm.getPrincipalFromSubjectDN(this.principalPattern, token, this.logger);
        if (parsedPrincipal == null) {
            return null;
        }
        token.setPrincipal(parsedPrincipal);
        return token;
    }

    public void authenticate(AuthenticationToken authToken, ActionListener<AuthenticationResult<User>> listener) {
        assert (this.delegatedRealms != null) : "Realm has not been initialized correctly";
        X509AuthenticationToken token = (X509AuthenticationToken)authToken;
        try {
            BytesKey fingerprint = PkiRealm.computeTokenFingerprint(token);
            User user = (User)this.cache.get((Object)fingerprint);
            if (user != null) {
                this.logger.debug(() -> Strings.format((String)"Using cached authentication for DN [%s], as principal [%s]", (Object[])new Object[]{token.dn(), user.principal()}));
                if (this.delegatedRealms.hasDelegation()) {
                    this.delegatedRealms.resolve(user.principal(), listener);
                } else {
                    listener.onResponse((Object)AuthenticationResult.success((Object)user));
                }
            } else if (!this.delegationEnabled && token.isDelegated()) {
                listener.onResponse((Object)AuthenticationResult.unsuccessful((String)("Realm does not permit delegation for " + token.dn()), null));
            } else if (!this.isCertificateChainTrusted(token)) {
                listener.onResponse((Object)AuthenticationResult.unsuccessful((String)("Certificate for " + token.dn() + " is not trusted"), null));
            } else {
                String principal = PkiRealm.getPrincipalFromSubjectDN(this.principalPattern, token, this.logger);
                if (principal == null) {
                    this.logger.debug(() -> Strings.format((String)"the extracted principal after cert chain validation, from DN [%s], using pattern [%s] is null", (Object[])new Object[]{token.dn(), this.principalPattern.toString()}));
                    listener.onResponse((Object)AuthenticationResult.unsuccessful((String)("Could not parse principal from Subject DN " + token.dn()), null));
                } else {
                    ActionListener cachingListener = ActionListener.wrap(result -> {
                        if (result.isAuthenticated()) {
                            try (ReleasableLock ignored = this.readLock.acquire();){
                                this.cache.put((Object)fingerprint, (Object)((User)result.getValue()));
                            }
                        }
                        listener.onResponse(result);
                    }, arg_0 -> listener.onFailure(arg_0));
                    if (!principal.equals(token.principal())) {
                        this.logger.debug(() -> Strings.format((String)"the extracted principal before [%s] and after [%s] cert chain validation, for DN [%s], are different", (Object[])new Object[]{token.principal(), principal, token.dn()}));
                    }
                    if (this.delegatedRealms.hasDelegation()) {
                        this.delegatedRealms.resolve(principal, (ActionListener<AuthenticationResult<User>>)cachingListener);
                    } else {
                        this.buildUser(token, principal, (ActionListener<AuthenticationResult<User>>)cachingListener);
                    }
                }
            }
        }
        catch (CertificateEncodingException e) {
            listener.onResponse((Object)AuthenticationResult.unsuccessful((String)("Certificate for " + token.dn() + " has encoding issues"), (Exception)e));
        }
    }

    private void buildUser(X509AuthenticationToken token, String principal, ActionListener<AuthenticationResult<User>> listener) {
        Map<String, String> metadata = token.isDelegated() ? Map.of("pki_dn", token.dn(), "pki_delegated_by_user", token.getDelegateeAuthentication().getEffectiveSubject().getUser().principal(), "pki_delegated_by_realm", token.getDelegateeAuthentication().getEffectiveSubject().getRealm().getName()) : Map.of("pki_dn", token.dn());
        UserRoleMapper.UserData userData = new UserRoleMapper.UserData(principal, token.dn(), Set.of(), metadata, this.config);
        this.roleMapper.resolveRoles(userData, ActionListener.wrap(roles -> {
            User computedUser = new User(principal, roles.toArray(new String[roles.size()]), null, null, metadata, true);
            listener.onResponse((Object)AuthenticationResult.success((Object)computedUser));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void lookupUser(String username, ActionListener<User> listener) {
        listener.onResponse(null);
    }

    static String getPrincipalFromSubjectDN(Pattern principalPattern, X509AuthenticationToken token, Logger logger) {
        String dn = token.credentials()[0].getSubjectX500Principal().toString();
        Matcher matcher = principalPattern.matcher(dn);
        if (!matcher.find()) {
            logger.debug(() -> Strings.format((String)"could not extract principal from DN [%s] using pattern [%s]", (Object[])new Object[]{dn, principalPattern.toString()}));
            return null;
        }
        String principal = matcher.group(1);
        if (org.elasticsearch.common.Strings.isNullOrEmpty((String)principal)) {
            logger.debug(() -> Strings.format((String)"the extracted principal from DN [%s] using pattern [%s] is empty", (Object[])new Object[]{dn, principalPattern.toString()}));
            return null;
        }
        return principal;
    }

    private boolean isCertificateChainTrusted(X509AuthenticationToken token) {
        if (this.trustManager == null) {
            return !token.isDelegated();
        }
        try {
            this.trustManager.checkClientTrusted(token.credentials(), AUTH_TYPE);
            return true;
        }
        catch (CertificateException e) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("failed certificate validation for Subject DN [" + token.dn() + "]", (Throwable)e);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("failed certificate validation for Subject DN [{}]", (Object)token.dn());
            }
            return false;
        }
    }

    private X509TrustManager trustManagers(RealmConfig realmConfig) {
        SslConfiguration sslConfiguration = SslSettingsLoader.load((Settings)realmConfig.settings(), (String)RealmSettings.realmSettingPrefix((RealmConfig.RealmIdentifier)realmConfig.identifier()), (Environment)realmConfig.env());
        SslTrustConfig trustConfig = sslConfiguration.trustConfig();
        if (trustConfig.isSystemDefault()) {
            return null;
        }
        X509ExtendedTrustManager trustManager = trustConfig.createTrustManager();
        if (trustManager.getAcceptedIssuers().length == 0) {
            this.logger.warn("PKI Realm [{}] uses trust configuration [{}] which has no accepted certificate issuers", (Object)this, (Object)trustConfig);
        }
        return trustManager;
    }

    public void expire(String username) {
        try (ReleasableLock ignored = this.writeLock.acquire();){
            Iterator userIterator = this.cache.values().iterator();
            while (userIterator.hasNext()) {
                if (!((User)userIterator.next()).principal().equals(username)) continue;
                userIterator.remove();
            }
        }
    }

    public void expireAll() {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.cache.invalidateAll();
        }
    }

    public void usageStats(ActionListener<Map<String, Object>> listener) {
        super.usageStats(ActionListener.wrap(stats -> {
            stats.put("has_truststore", this.trustManager != null);
            stats.put("has_authorization_realms", this.delegatedRealms != null && this.delegatedRealms.hasDelegation());
            stats.put("has_default_username_pattern", "CN=(.*?)(?:,|$)".equals(this.principalPattern.pattern()));
            stats.put("is_authentication_delegated", this.delegationEnabled);
            listener.onResponse(stats);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void validateAuthenticationDelegationConfiguration(RealmConfig config) {
        if (this.delegationEnabled) {
            ArrayList<CallSite> exceptionMessages = new ArrayList<CallSite>(2);
            if (this.trustManager == null) {
                exceptionMessages.add((CallSite)((Object)("a trust configuration (" + config.getConcreteSetting(PkiRealmSettings.CAPATH_SETTING).getKey() + " or " + config.getConcreteSetting(PkiRealmSettings.TRUST_STORE_PATH).getKey() + ")")));
            }
            if (!TokenService.isTokenServiceEnabled(config.settings()).booleanValue()) {
                exceptionMessages.add((CallSite)((Object)("that the token service be also enabled (" + XPackSettings.TOKEN_SERVICE_ENABLED_SETTING.getKey() + ")")));
            }
            if (!exceptionMessages.isEmpty()) {
                String message = "PKI realms with delegation enabled require " + (String)exceptionMessages.get(0);
                if (exceptionMessages.size() == 2) {
                    message = message + " and " + (String)exceptionMessages.get(1);
                }
                throw new IllegalStateException(message);
            }
        }
    }

    static BytesKey computeTokenFingerprint(X509AuthenticationToken token) throws CertificateEncodingException {
        MessageDigest digest = MessageDigests.sha256();
        for (X509Certificate certificate : token.credentials()) {
            digest.update(certificate.getEncoded());
        }
        return new BytesKey(digest.digest());
    }
}

