/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.LDAPException;
import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.LdapRealmSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.LdapSessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.ldap.LdapUserSearchSessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.core.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.ldap.ActiveDirectorySessionFactory;
import org.elasticsearch.xpack.security.authc.ldap.LdapSessionFactory;
import org.elasticsearch.xpack.security.authc.ldap.LdapUserSearchSessionFactory;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapLoadBalancing;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;
import org.elasticsearch.xpack.security.authc.support.CachingUsernamePasswordRealm;
import org.elasticsearch.xpack.security.authc.support.DelegatedAuthorizationSupport;
import org.elasticsearch.xpack.security.authc.support.mapper.CompositeRoleMapper;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;

public final class LdapRealm
extends CachingUsernamePasswordRealm {
    private final SessionFactory sessionFactory;
    private final UserRoleMapper roleMapper;
    private final ThreadPool threadPool;
    private final TimeValue executionTimeout;
    private DelegatedAuthorizationSupport delegatedRealms;

    public LdapRealm(RealmConfig config, SSLService sslService, ResourceWatcherService watcherService, NativeRoleMappingStore nativeRoleMappingStore, ThreadPool threadPool) throws LDAPException {
        this(config, LdapRealm.sessionFactory(config, sslService, threadPool), new CompositeRoleMapper(config, watcherService, nativeRoleMappingStore), threadPool);
    }

    LdapRealm(RealmConfig config, SessionFactory sessionFactory, UserRoleMapper roleMapper, ThreadPool threadPool) {
        super(config, threadPool);
        this.sessionFactory = sessionFactory;
        this.roleMapper = roleMapper;
        this.threadPool = threadPool;
        this.executionTimeout = (TimeValue)config.getSetting(LdapRealmSettings.EXECUTION_TIMEOUT);
        roleMapper.refreshRealmOnChange((CachingRealm)this);
    }

    static SessionFactory sessionFactory(RealmConfig config, SSLService sslService, ThreadPool threadPool) throws LDAPException {
        SessionFactory sessionFactory;
        if ("active_directory".equals(config.type())) {
            sessionFactory = new ActiveDirectorySessionFactory(config, sslService, threadPool);
        } else {
            assert ("ldap".equals(config.type())) : "type [" + config.type() + "] is unknown. expected one of [active_directory, ldap]";
            List<Setting.AffixSetting<?>> configuredSearchSettings = LdapUserSearchSessionFactory.configuredUserSearchSettings(config);
            boolean hasTemplates = config.hasSetting(LdapSessionFactorySettings.USER_DN_TEMPLATES_SETTING);
            if (configuredSearchSettings.isEmpty()) {
                if (!hasTemplates) {
                    throw new IllegalArgumentException("settings were not found for either user search [" + RealmSettings.getFullSettingKey((RealmConfig)config, (Setting.AffixSetting)LdapUserSearchSessionFactorySettings.SEARCH_BASE_DN) + "] or user template [" + RealmSettings.getFullSettingKey((RealmConfig)config, (Setting.AffixSetting)LdapSessionFactorySettings.USER_DN_TEMPLATES_SETTING) + "] modes of operation. Please provide the settings for the mode you wish to use. For more details refer to the ldap authentication section of the X-Pack guide.");
                }
                sessionFactory = new LdapSessionFactory(config, sslService, threadPool);
            } else {
                if (hasTemplates) {
                    throw new IllegalArgumentException("settings were found for both user search [" + configuredSearchSettings.stream().map(s -> RealmSettings.getFullSettingKey((RealmConfig)config, (Setting.AffixSetting)s)).collect(Collectors.joining(",")) + "] and user template [" + RealmSettings.getFullSettingKey((RealmConfig)config, (Setting.AffixSetting)LdapSessionFactorySettings.USER_DN_TEMPLATES_SETTING) + "] modes of operation. Please remove the settings for the mode you do not wish to use. For more details refer to the ldap authentication section of the X-Pack guide.");
                }
                sessionFactory = new LdapUserSearchSessionFactory(config, sslService, threadPool);
            }
        }
        return sessionFactory;
    }

    @Override
    protected void doAuthenticate(UsernamePasswordToken token, ActionListener<AuthenticationResult<User>> listener) {
        assert (this.delegatedRealms != null) : "Realm has not been initialized correctly";
        CancellableLdapRunnable<AuthenticationResult> cancellableLdapRunnable = new CancellableLdapRunnable<AuthenticationResult>(listener, ex -> AuthenticationResult.unsuccessful((String)("Authentication against realm [" + this.toString() + "] failed"), (Exception)ex), () -> this.sessionFactory.session(token.principal(), token.credentials(), (ActionListener<LdapSession>)this.contextPreservingListener(new LdapSessionActionListener("authenticate", token.principal(), listener))), this.logger);
        this.threadPool.generic().execute((Runnable)((Object)cancellableLdapRunnable));
        this.threadPool.schedule(cancellableLdapRunnable::maybeTimeout, this.executionTimeout, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    @Override
    protected void doLookupUser(String username, ActionListener<User> userActionListener) {
        if (this.sessionFactory.supportsUnauthenticatedSession()) {
            ActionListener sessionListener = ActionListener.wrap(result -> userActionListener.onResponse((Object)((User)result.getValue())), arg_0 -> userActionListener.onFailure(arg_0));
            CancellableLdapRunnable<User> cancellableLdapRunnable = new CancellableLdapRunnable<User>(userActionListener, e -> null, () -> this.sessionFactory.unauthenticatedSession(username, (ActionListener<LdapSession>)this.contextPreservingListener(new LdapSessionActionListener("lookup", username, (ActionListener<AuthenticationResult<User>>)sessionListener))), this.logger);
            this.threadPool.generic().execute((Runnable)((Object)cancellableLdapRunnable));
            this.threadPool.schedule(cancellableLdapRunnable::maybeTimeout, this.executionTimeout, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        } else {
            userActionListener.onResponse(null);
        }
    }

    private ContextPreservingActionListener<LdapSession> contextPreservingListener(LdapSessionActionListener sessionListener) {
        Supplier toRestore = this.config.threadContext().newRestorableContext(false);
        return new ContextPreservingActionListener(toRestore, (ActionListener)sessionListener);
    }

    public void initialize(Iterable<Realm> realms, XPackLicenseState licenseState) {
        if (this.delegatedRealms != null) {
            throw new IllegalStateException("Realm has already been initialized");
        }
        this.delegatedRealms = new DelegatedAuthorizationSupport(realms, this.config, licenseState);
    }

    @Override
    public void usageStats(ActionListener<Map<String, Object>> listener) {
        super.usageStats((ActionListener<Map<String, Object>>)ActionListener.wrap(usage -> {
            usage.put("size", this.getCacheSize());
            usage.put("load_balance_type", LdapLoadBalancing.resolve(this.config).toString());
            usage.put("ssl", this.sessionFactory.isSslUsed());
            usage.put("user_search", false == LdapUserSearchSessionFactory.configuredUserSearchSettings(this.config).isEmpty());
            listener.onResponse(usage);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private static void buildUser(LdapSession session, String username, ActionListener<AuthenticationResult<User>> listener, UserRoleMapper roleMapper, DelegatedAuthorizationSupport delegatedAuthz) {
        assert (delegatedAuthz != null) : "DelegatedAuthorizationSupport is null";
        if (session == null) {
            listener.onResponse((Object)AuthenticationResult.notHandled());
        } else if (delegatedAuthz.hasDelegation()) {
            delegatedAuthz.resolve(username, listener);
        } else {
            LdapRealm.lookupUserFromSession(username, session, roleMapper, listener);
        }
    }

    @Override
    protected void handleCachedAuthentication(User user, ActionListener<AuthenticationResult<User>> listener) {
        if (this.delegatedRealms.hasDelegation()) {
            this.delegatedRealms.resolve(user.principal(), listener);
        } else {
            super.handleCachedAuthentication(user, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lookupUserFromSession(String username, LdapSession session, UserRoleMapper roleMapper, ActionListener<AuthenticationResult<User>> listener) {
        boolean loadingGroups = false;
        try {
            Consumer<Exception> onFailure = e -> {
                IOUtils.closeWhileHandlingException((Closeable)((Object)session));
                listener.onFailure(e);
            };
            session.resolve((ActionListener<LdapSession.LdapUserData>)ActionListener.wrap(ldapData -> {
                HashMap<String, Object> metadata = new HashMap<String, Object>();
                metadata.put("ldap_dn", session.userDn());
                metadata.put("ldap_groups", ldapData.groups);
                metadata.putAll(ldapData.metadata);
                UserRoleMapper.UserData user = new UserRoleMapper.UserData(username, session.userDn(), ldapData.groups, metadata, session.realm());
                roleMapper.resolveRoles(user, ActionListener.wrap(roles -> {
                    IOUtils.close((Closeable)((Object)session));
                    String[] rolesArray = roles.toArray(new String[roles.size()]);
                    listener.onResponse((Object)AuthenticationResult.success((Object)new User(username, rolesArray, null, null, metadata, true)));
                }, (Consumer)onFailure));
            }, onFailure));
            loadingGroups = true;
        }
        finally {
            if (!loadingGroups) {
                session.close();
            }
        }
    }

    static class CancellableLdapRunnable<T>
    extends AbstractRunnable {
        private final Runnable in;
        private final ActionListener<T> listener;
        private final Function<Exception, T> defaultValue;
        private final Logger logger;
        private final AtomicReference<LdapRunnableState> state = new AtomicReference<LdapRunnableState>(LdapRunnableState.AWAITING_EXECUTION);

        CancellableLdapRunnable(ActionListener<T> listener, Function<Exception, T> defaultValue, Runnable in, Logger logger) {
            this.listener = listener;
            this.defaultValue = Objects.requireNonNull(defaultValue);
            this.in = in;
            this.logger = logger;
        }

        public void onFailure(Exception e) {
            this.logger.error("execution of ldap runnable failed", (Throwable)e);
            T result = this.defaultValue.apply(e);
            this.listener.onResponse(result);
        }

        protected void doRun() throws Exception {
            if (this.state.compareAndSet(LdapRunnableState.AWAITING_EXECUTION, LdapRunnableState.EXECUTING)) {
                this.in.run();
            } else {
                this.logger.trace("skipping execution of ldap runnable as the current state is [{}]", (Object)this.state.get());
            }
        }

        public void onRejection(Exception e) {
            this.listener.onFailure(e);
        }

        void maybeTimeout() {
            if (this.state.compareAndSet(LdapRunnableState.AWAITING_EXECUTION, LdapRunnableState.TIMED_OUT)) {
                this.logger.warn("skipping execution of ldap runnable as it has been waiting for execution too long");
                this.listener.onFailure((Exception)new ElasticsearchTimeoutException("timed out waiting for execution of ldap runnable", new Object[0]));
            }
        }

        static enum LdapRunnableState {
            AWAITING_EXECUTION,
            EXECUTING,
            TIMED_OUT;

        }
    }

    private class LdapSessionActionListener
    implements ActionListener<LdapSession> {
        private final AtomicReference<LdapSession> ldapSessionAtomicReference = new AtomicReference();
        private String action;
        private final String username;
        private final ActionListener<AuthenticationResult<User>> resultListener;

        LdapSessionActionListener(String action, String username, ActionListener<AuthenticationResult<User>> resultListener) {
            this.action = action;
            this.username = username;
            this.resultListener = resultListener;
        }

        public void onResponse(LdapSession session) {
            if (session == null) {
                this.resultListener.onResponse((Object)AuthenticationResult.notHandled());
            } else {
                this.ldapSessionAtomicReference.set(session);
                LdapRealm.buildUser(session, this.username, this.resultListener, LdapRealm.this.roleMapper, LdapRealm.this.delegatedRealms);
            }
        }

        public void onFailure(Exception e) {
            if (this.ldapSessionAtomicReference.get() != null) {
                IOUtils.closeWhileHandlingException((Closeable)((Closeable)((Object)this.ldapSessionAtomicReference.get())));
            }
            if (LdapRealm.this.logger.isDebugEnabled()) {
                LdapRealm.this.logger.debug(() -> Strings.format((String)"Exception occurred during %s for %s", (Object[])new Object[]{this.action, LdapRealm.this}), (Throwable)e);
            }
            this.resultListener.onResponse((Object)AuthenticationResult.unsuccessful((String)(this.action + " failed"), (Exception)e));
        }
    }
}

