/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.jwt;

import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.jwt.JwtRealmSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.jwt.JwtAlgorithmValidator;
import org.elasticsearch.xpack.security.authc.jwt.JwtAuthenticationToken;
import org.elasticsearch.xpack.security.authc.jwt.JwtDateClaimValidator;
import org.elasticsearch.xpack.security.authc.jwt.JwtFieldValidator;
import org.elasticsearch.xpack.security.authc.jwt.JwtSignatureValidator;
import org.elasticsearch.xpack.security.authc.jwt.JwtStringClaimValidator;
import org.elasticsearch.xpack.security.authc.jwt.JwtTypeValidator;

public class JwtAuthenticator
implements Releasable {
    private static final Logger logger = LogManager.getLogger(JwtAuthenticator.class);
    private final RealmConfig realmConfig;
    private final List<JwtFieldValidator> jwtFieldValidators;
    private final JwtSignatureValidator jwtSignatureValidator;
    private final JwtRealmSettings.TokenType tokenType;
    private final Map<String, String> fallbackClaimNames;

    public JwtAuthenticator(RealmConfig realmConfig, SSLService sslService, JwtSignatureValidator.PkcJwkSetReloadNotifier reloadNotifier) {
        this.realmConfig = realmConfig;
        this.tokenType = (JwtRealmSettings.TokenType)realmConfig.getSetting(JwtRealmSettings.TOKEN_TYPE);
        ArrayList<JwtFieldValidator> jwtFieldValidators = new ArrayList<JwtFieldValidator>();
        if (this.tokenType == JwtRealmSettings.TokenType.ID_TOKEN) {
            this.fallbackClaimNames = Map.of();
            jwtFieldValidators.addAll(JwtAuthenticator.configureFieldValidatorsForIdToken(realmConfig));
        } else {
            this.fallbackClaimNames = Map.ofEntries(Map.entry("sub", (String)realmConfig.getSetting(JwtRealmSettings.FALLBACK_SUB_CLAIM)), Map.entry("aud", (String)realmConfig.getSetting(JwtRealmSettings.FALLBACK_AUD_CLAIM)));
            jwtFieldValidators.addAll(JwtAuthenticator.configureFieldValidatorsForAccessToken(realmConfig, this.fallbackClaimNames));
        }
        jwtFieldValidators.addAll(this.getRequireClaimsValidators());
        this.jwtFieldValidators = List.copyOf(jwtFieldValidators);
        this.jwtSignatureValidator = new JwtSignatureValidator.DelegatingJwtSignatureValidator(realmConfig, sslService, reloadNotifier);
    }

    public void authenticate(JwtAuthenticationToken jwtAuthenticationToken, ActionListener<JWTClaimsSet> listener) {
        String tokenPrincipal = jwtAuthenticationToken.principal();
        SignedJWT signedJWT = jwtAuthenticationToken.getSignedJWT();
        JWTClaimsSet jwtClaimsSet = jwtAuthenticationToken.getJWTClaimsSet();
        JWSHeader jwsHeader = signedJWT.getHeader();
        if (logger.isTraceEnabled()) {
            logger.trace("Realm [{}] successfully parsed JWT token [{}] with header [{}] and claimSet [{}]", (Object)this.realmConfig.name(), (Object)tokenPrincipal, (Object)jwsHeader, (Object)jwtClaimsSet);
        }
        for (JwtFieldValidator jwtFieldValidator : this.jwtFieldValidators) {
            try {
                jwtFieldValidator.validate(jwsHeader, jwtClaimsSet);
            }
            catch (Exception e) {
                listener.onFailure(e);
                return;
            }
        }
        try {
            this.validateSignature(tokenPrincipal, signedJWT, (ActionListener<Void>)listener.map(ignored -> jwtClaimsSet));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    void validateSignature(String tokenPrincipal, SignedJWT signedJWT, ActionListener<Void> listener) {
        this.jwtSignatureValidator.validate(tokenPrincipal, signedJWT, listener);
    }

    public void close() {
        this.jwtSignatureValidator.close();
    }

    public JwtRealmSettings.TokenType getTokenType() {
        return this.tokenType;
    }

    public Map<String, String> getFallbackClaimNames() {
        return this.fallbackClaimNames;
    }

    JwtSignatureValidator.DelegatingJwtSignatureValidator getJwtSignatureValidator() {
        assert (this.jwtSignatureValidator instanceof JwtSignatureValidator.DelegatingJwtSignatureValidator);
        return (JwtSignatureValidator.DelegatingJwtSignatureValidator)this.jwtSignatureValidator;
    }

    private static List<JwtFieldValidator> configureFieldValidatorsForIdToken(RealmConfig realmConfig) {
        assert (realmConfig.getSetting(JwtRealmSettings.TOKEN_TYPE) == JwtRealmSettings.TokenType.ID_TOKEN);
        TimeValue allowedClockSkew = (TimeValue)realmConfig.getSetting(JwtRealmSettings.ALLOWED_CLOCK_SKEW);
        Clock clock = Clock.systemUTC();
        JwtStringClaimValidator subjectClaimValidator = realmConfig.hasSetting(JwtRealmSettings.ALLOWED_SUBJECTS) ? new JwtStringClaimValidator("sub", (List)realmConfig.getSetting(JwtRealmSettings.ALLOWED_SUBJECTS), true) : JwtStringClaimValidator.ALLOW_ALL_SUBJECTS;
        return List.of(JwtTypeValidator.INSTANCE, new JwtStringClaimValidator("iss", List.of((String)realmConfig.getSetting(JwtRealmSettings.ALLOWED_ISSUER)), true), subjectClaimValidator, new JwtStringClaimValidator("aud", (List)realmConfig.getSetting(JwtRealmSettings.ALLOWED_AUDIENCES), false), new JwtAlgorithmValidator((List)realmConfig.getSetting(JwtRealmSettings.ALLOWED_SIGNATURE_ALGORITHMS)), new JwtDateClaimValidator(clock, "iat", allowedClockSkew, JwtDateClaimValidator.Relationship.BEFORE_NOW, false), new JwtDateClaimValidator(clock, "exp", allowedClockSkew, JwtDateClaimValidator.Relationship.AFTER_NOW, false), new JwtDateClaimValidator(clock, "nbf", allowedClockSkew, JwtDateClaimValidator.Relationship.BEFORE_NOW, true), new JwtDateClaimValidator(clock, "auth_time", allowedClockSkew, JwtDateClaimValidator.Relationship.BEFORE_NOW, true));
    }

    private static List<JwtFieldValidator> configureFieldValidatorsForAccessToken(RealmConfig realmConfig, Map<String, String> fallbackClaimLookup) {
        assert (realmConfig.getSetting(JwtRealmSettings.TOKEN_TYPE) == JwtRealmSettings.TokenType.ACCESS_TOKEN);
        TimeValue allowedClockSkew = (TimeValue)realmConfig.getSetting(JwtRealmSettings.ALLOWED_CLOCK_SKEW);
        Clock clock = Clock.systemUTC();
        return List.of(JwtTypeValidator.INSTANCE, new JwtStringClaimValidator("iss", List.of((String)realmConfig.getSetting(JwtRealmSettings.ALLOWED_ISSUER)), true), new JwtStringClaimValidator("sub", fallbackClaimLookup, (List)realmConfig.getSetting(JwtRealmSettings.ALLOWED_SUBJECTS), true), new JwtStringClaimValidator("aud", fallbackClaimLookup, (List)realmConfig.getSetting(JwtRealmSettings.ALLOWED_AUDIENCES), false), new JwtAlgorithmValidator((List)realmConfig.getSetting(JwtRealmSettings.ALLOWED_SIGNATURE_ALGORITHMS)), new JwtDateClaimValidator(clock, "iat", allowedClockSkew, JwtDateClaimValidator.Relationship.BEFORE_NOW, false), new JwtDateClaimValidator(clock, "exp", allowedClockSkew, JwtDateClaimValidator.Relationship.AFTER_NOW, false));
    }

    private List<JwtStringClaimValidator> getRequireClaimsValidators() {
        Settings requiredClaims = (Settings)this.realmConfig.getSetting(JwtRealmSettings.REQUIRED_CLAIMS);
        return requiredClaims.names().stream().map(name -> {
            List allowedValues = requiredClaims.getAsList(name);
            return new JwtStringClaimValidator((String)name, allowedValues, false);
        }).toList();
    }
}

