/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.token;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenRequest;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenResponse;
import org.elasticsearch.xpack.security.action.token.TransportCreateTokenAction;
import org.elasticsearch.xpack.security.authc.TokenService;

public class TransportRefreshTokenAction
extends HandledTransportAction<CreateTokenRequest, CreateTokenResponse> {
    private final TokenService tokenService;

    @Inject
    public TransportRefreshTokenAction(TransportService transportService, ActionFilters actionFilters, TokenService tokenService) {
        super("cluster:admin/xpack/security/token/refresh", transportService, actionFilters, CreateTokenRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.tokenService = tokenService;
    }

    protected void doExecute(Task task, CreateTokenRequest request, ActionListener<CreateTokenResponse> listener) {
        this.tokenService.refreshToken(request.getRefreshToken(), (ActionListener<TokenService.CreateTokenResult>)ActionListener.wrap(tokenResult -> {
            String scope = TransportCreateTokenAction.getResponseScopeValue(request.getScope());
            CreateTokenResponse response = new CreateTokenResponse(tokenResult.getAccessToken(), this.tokenService.getExpirationDelay(), scope, tokenResult.getRefreshToken(), null, tokenResult.getAuthentication());
            listener.onResponse((Object)response);
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

