/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.token;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.token.InvalidateTokenRequest;
import org.elasticsearch.xpack.core.security.action.token.InvalidateTokenResponse;
import org.elasticsearch.xpack.core.security.authc.support.TokensInvalidationResult;
import org.elasticsearch.xpack.security.authc.TokenService;

public final class TransportInvalidateTokenAction
extends HandledTransportAction<InvalidateTokenRequest, InvalidateTokenResponse> {
    private final TokenService tokenService;

    @Inject
    public TransportInvalidateTokenAction(TransportService transportService, ActionFilters actionFilters, TokenService tokenService) {
        super("cluster:admin/xpack/security/token/invalidate", transportService, actionFilters, InvalidateTokenRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.tokenService = tokenService;
    }

    protected void doExecute(Task task, InvalidateTokenRequest request, ActionListener<InvalidateTokenResponse> listener) {
        ActionListener invalidateListener = ActionListener.wrap(tokensInvalidationResult -> listener.onResponse((Object)new InvalidateTokenResponse(tokensInvalidationResult)), arg_0 -> listener.onFailure(arg_0));
        if (Strings.hasText((String)request.getUserName()) || Strings.hasText((String)request.getRealmName())) {
            this.tokenService.invalidateActiveTokens(request.getRealmName(), request.getUserName(), null, (ActionListener<TokensInvalidationResult>)invalidateListener);
        } else if (request.getTokenType() == InvalidateTokenRequest.Type.ACCESS_TOKEN) {
            this.tokenService.invalidateAccessToken(request.getTokenString(), (ActionListener<TokensInvalidationResult>)invalidateListener);
        } else {
            assert (request.getTokenType() == InvalidateTokenRequest.Type.REFRESH_TOKEN);
            this.tokenService.invalidateRefreshToken(request.getTokenString(), (ActionListener<TokensInvalidationResult>)invalidateListener);
        }
    }
}

