/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.role;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.role.GetRolesRequest;
import org.elasticsearch.xpack.core.security.action.role.GetRolesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.core.security.authz.store.RoleRetrievalResult;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;

public class TransportGetRolesAction
extends HandledTransportAction<GetRolesRequest, GetRolesResponse> {
    private final NativeRolesStore nativeRolesStore;
    private final ReservedRolesStore reservedRolesStore;

    @Inject
    public TransportGetRolesAction(ActionFilters actionFilters, NativeRolesStore nativeRolesStore, TransportService transportService, ReservedRolesStore reservedRolesStore) {
        super("cluster:admin/xpack/security/role/get", transportService, actionFilters, GetRolesRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.nativeRolesStore = nativeRolesStore;
        this.reservedRolesStore = reservedRolesStore;
    }

    protected void doExecute(Task task, GetRolesRequest request, ActionListener<GetRolesResponse> listener) {
        String[] requestedRoles = request.names();
        boolean specificRolesRequested = requestedRoles != null && requestedRoles.length > 0;
        HashSet<String> rolesToSearchFor = new HashSet<String>();
        ArrayList<RoleDescriptor> roles = new ArrayList<RoleDescriptor>();
        if (specificRolesRequested) {
            for (String role : requestedRoles) {
                if (ReservedRolesStore.isReserved((String)role)) {
                    RoleDescriptor rd = this.reservedRolesStore.roleDescriptor(role);
                    if (rd != null) {
                        roles.add(rd);
                        continue;
                    }
                    listener.onFailure((Exception)new IllegalStateException("unable to obtain reserved role [" + role + "]"));
                    return;
                }
                rolesToSearchFor.add(role);
            }
        } else {
            roles.addAll(this.reservedRolesStore.roleDescriptors());
        }
        if (specificRolesRequested && rolesToSearchFor.isEmpty()) {
            listener.onResponse((Object)new GetRolesResponse(roles.toArray(new RoleDescriptor[roles.size()])));
        } else {
            this.nativeRolesStore.getRoleDescriptors(rolesToSearchFor, (ActionListener<RoleRetrievalResult>)ActionListener.wrap(retrievalResult -> {
                if (retrievalResult.isSuccess()) {
                    roles.addAll(retrievalResult.getDescriptors());
                    listener.onResponse((Object)new GetRolesResponse(roles.toArray(new RoleDescriptor[roles.size()])));
                } else {
                    listener.onFailure(retrievalResult.getFailure());
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }
}

