/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.privilege;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.privilege.PutPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.privilege.PutPrivilegesResponse;
import org.elasticsearch.xpack.security.authz.store.NativePrivilegeStore;

public class TransportPutPrivilegesAction
extends HandledTransportAction<PutPrivilegesRequest, PutPrivilegesResponse> {
    private final NativePrivilegeStore privilegeStore;

    @Inject
    public TransportPutPrivilegesAction(ActionFilters actionFilters, NativePrivilegeStore privilegeStore, TransportService transportService) {
        super("cluster:admin/xpack/security/privilege/put", transportService, actionFilters, PutPrivilegesRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.privilegeStore = privilegeStore;
    }

    protected void doExecute(Task task, PutPrivilegesRequest request, ActionListener<PutPrivilegesResponse> listener) {
        if (request.getPrivileges() == null || request.getPrivileges().size() == 0) {
            listener.onResponse((Object)new PutPrivilegesResponse(Collections.emptyMap()));
        } else {
            this.privilegeStore.putPrivileges(request.getPrivileges(), request.getRefreshPolicy(), (ActionListener<Map<String, List<String>>>)ActionListener.wrap(created -> listener.onResponse((Object)new PutPrivilegesResponse(created)), arg_0 -> listener.onFailure(arg_0)));
        }
    }
}

