/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.apikey;

import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.security.action.apikey.AbstractCreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyResponse;
import org.elasticsearch.xpack.core.security.action.apikey.GrantApiKeyRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.action.TransportGrantAction;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.support.ApiKeyUserRoleDescriptorResolver;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public final class TransportGrantApiKeyAction
extends TransportGrantAction<GrantApiKeyRequest, CreateApiKeyResponse> {
    private final ApiKeyService apiKeyService;
    private final ApiKeyUserRoleDescriptorResolver resolver;

    @Inject
    public TransportGrantApiKeyAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, AuthenticationService authenticationService, AuthorizationService authorizationService, ApiKeyService apiKeyService, CompositeRolesStore rolesStore, NamedXContentRegistry xContentRegistry) {
        this(transportService, actionFilters, threadPool.getThreadContext(), authenticationService, authorizationService, apiKeyService, new ApiKeyUserRoleDescriptorResolver(rolesStore, xContentRegistry));
    }

    TransportGrantApiKeyAction(TransportService transportService, ActionFilters actionFilters, ThreadContext threadContext, AuthenticationService authenticationService, AuthorizationService authorizationService, ApiKeyService apiKeyService, ApiKeyUserRoleDescriptorResolver resolver) {
        super("cluster:admin/xpack/security/api_key/grant", transportService, actionFilters, GrantApiKeyRequest::new, authenticationService, authorizationService, threadContext);
        this.apiKeyService = apiKeyService;
        this.resolver = resolver;
    }

    @Override
    protected void doExecuteWithGrantAuthentication(Task task, GrantApiKeyRequest request, Authentication authentication, ActionListener<CreateApiKeyResponse> listener) {
        this.resolver.resolveUserRoleDescriptors(authentication, (ActionListener<Set<RoleDescriptor>>)ActionListener.wrap(roleDescriptors -> this.apiKeyService.createApiKey(authentication, (AbstractCreateApiKeyRequest)request.getApiKeyRequest(), (Set<RoleDescriptor>)roleDescriptors, listener), arg_0 -> listener.onFailure(arg_0)));
    }
}

