/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.apikey;

import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.apikey.BaseBulkUpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.BulkUpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.BulkUpdateApiKeyResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.action.apikey.TransportBaseUpdateApiKeyAction;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.support.ApiKeyUserRoleDescriptorResolver;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public final class TransportBulkUpdateApiKeyAction
extends TransportBaseUpdateApiKeyAction<BulkUpdateApiKeyRequest, BulkUpdateApiKeyResponse> {
    private final ApiKeyService apiKeyService;
    private final ApiKeyUserRoleDescriptorResolver resolver;

    @Inject
    public TransportBulkUpdateApiKeyAction(TransportService transportService, ActionFilters actionFilters, ApiKeyService apiKeyService, SecurityContext context, CompositeRolesStore rolesStore, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/xpack/security/api_key/bulk_update", transportService, actionFilters, BulkUpdateApiKeyRequest::new, context);
        this.apiKeyService = apiKeyService;
        this.resolver = new ApiKeyUserRoleDescriptorResolver(rolesStore, xContentRegistry);
    }

    @Override
    void doExecuteUpdate(Task task, BulkUpdateApiKeyRequest request, Authentication authentication, ActionListener<BulkUpdateApiKeyResponse> listener) {
        this.resolver.resolveUserRoleDescriptors(authentication, (ActionListener<Set<RoleDescriptor>>)ActionListener.wrap(roleDescriptors -> this.apiKeyService.updateApiKeys(authentication, (BaseBulkUpdateApiKeyRequest)request, (Set<RoleDescriptor>)roleDescriptors, listener), arg_0 -> listener.onFailure(arg_0)));
    }
}

