/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.io.IOException;
import java.util.Iterator;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.script.mustache.SearchTemplateResponse;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class MultiSearchTemplateResponse
extends ActionResponse
implements Iterable<Item>,
ToXContentObject {
    private final Item[] items;
    private final long tookInMillis;

    MultiSearchTemplateResponse(StreamInput in) throws IOException {
        super(in);
        this.items = (Item[])in.readArray(Item::new, Item[]::new);
        this.tookInMillis = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_0_0) ? in.readVLong() : -1L;
    }

    MultiSearchTemplateResponse(Item[] items, long tookInMillis) {
        this.items = items;
        this.tookInMillis = tookInMillis;
    }

    @Override
    public Iterator<Item> iterator() {
        return Iterators.forArray((Object[])this.items);
    }

    public Item[] getResponses() {
        return this.items;
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray((Writeable[])this.items);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_0_0)) {
            out.writeVLong(this.tookInMillis);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("took", this.tookInMillis);
        builder.startArray("responses");
        for (Item item : this.items) {
            builder.startObject();
            if (item.isFailure()) {
                ElasticsearchException.generateFailureXContent((XContentBuilder)builder, (ToXContent.Params)params, (Exception)item.getFailure(), (boolean)true);
                builder.field("status", ExceptionsHelper.status((Throwable)item.getFailure()).getStatus());
            } else {
                item.getResponse().innerToXContent(builder, params);
                builder.field("status", item.getResponse().status().getStatus());
            }
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static MultiSearchTemplateResponse fromXContext(XContentParser parser) {
        MultiSearchResponse mSearchResponse = MultiSearchResponse.fromXContext((XContentParser)parser);
        MultiSearchResponse.Item[] responses = mSearchResponse.getResponses();
        Item[] templateResponses = new Item[responses.length];
        int i = 0;
        for (MultiSearchResponse.Item item : responses) {
            SearchTemplateResponse stResponse = null;
            if (item.getResponse() != null) {
                stResponse = new SearchTemplateResponse();
                stResponse.setResponse(item.getResponse());
            }
            templateResponses[i++] = new Item(stResponse, item.getFailure());
        }
        return new MultiSearchTemplateResponse(templateResponses, mSearchResponse.getTook().millis());
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static class Item
    implements Writeable {
        private final SearchTemplateResponse response;
        private final Exception exception;

        private Item(StreamInput in) throws IOException {
            if (in.readBoolean()) {
                this.response = new SearchTemplateResponse(in);
                this.exception = null;
            } else {
                this.exception = in.readException();
                this.response = null;
            }
        }

        public Item(SearchTemplateResponse response, Exception exception) {
            this.response = response;
            this.exception = exception;
        }

        public boolean isFailure() {
            return this.exception != null;
        }

        @Nullable
        public String getFailureMessage() {
            return this.exception == null ? null : this.exception.getMessage();
        }

        @Nullable
        public SearchTemplateResponse getResponse() {
            return this.response;
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (this.response != null) {
                out.writeBoolean(true);
                this.response.writeTo(out);
            } else {
                out.writeBoolean(false);
                out.writeException((Throwable)this.exception);
            }
        }

        public Exception getFailure() {
            return this.exception;
        }

        public String toString() {
            return "Item [response=" + this.response + ", exception=" + this.exception + "]";
        }
    }

    static final class Fields {
        static final String RESPONSES = "responses";
        static final String STATUS = "status";

        Fields() {
        }
    }
}

