/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal.metrics;

import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.telemetry.apm.internal.metrics.AbstractInstrument;
import org.elasticsearch.telemetry.apm.internal.metrics.OtelHelper;
import org.elasticsearch.telemetry.metric.LongGauge;

public class LongGaugeAdapter
extends AbstractInstrument<ObservableLongMeasurement>
implements LongGauge {
    public LongGaugeAdapter(Meter meter, String name, String description, String unit) {
        super(meter, name, description, unit);
    }

    @Override
    ObservableLongMeasurement buildInstrument(Meter meter) {
        return Objects.requireNonNull(meter).gaugeBuilder(this.getName()).ofLongs().setDescription(this.getDescription()).setUnit(this.getUnit()).buildObserver();
    }

    public void record(long value) {
        ((ObservableLongMeasurement)this.getInstrument()).record(value);
    }

    public void record(long value, Map<String, Object> attributes) {
        ((ObservableLongMeasurement)this.getInstrument()).record(value, OtelHelper.fromMap(attributes));
    }
}

