/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal.metrics;

import io.opentelemetry.api.metrics.DoubleGaugeBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.telemetry.apm.internal.metrics.AbstractInstrument;
import org.elasticsearch.telemetry.apm.internal.metrics.OtelHelper;
import org.elasticsearch.telemetry.metric.DoubleGauge;

public class DoubleGaugeAdapter
extends AbstractInstrument<ObservableDoubleMeasurement>
implements DoubleGauge {
    public DoubleGaugeAdapter(Meter meter, String name, String description, String unit) {
        super(meter, name, description, unit);
    }

    @Override
    ObservableDoubleMeasurement buildInstrument(Meter meter) {
        DoubleGaugeBuilder builder = Objects.requireNonNull(meter).gaugeBuilder(this.getName());
        return builder.setDescription(this.getDescription()).setUnit(this.getUnit()).buildObserver();
    }

    public void record(double value) {
        ((ObservableDoubleMeasurement)this.getInstrument()).record(value);
    }

    public void record(double value, Map<String, Object> attributes) {
        ((ObservableDoubleMeasurement)this.getInstrument()).record(value, OtelHelper.fromMap(attributes));
    }
}

