/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal.metrics;

import io.opentelemetry.api.metrics.Meter;
import java.security.AccessController;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.telemetry.metric.Instrument;

public abstract class AbstractInstrument<T>
implements Instrument {
    private final AtomicReference<T> delegate;
    private final String name;
    private final String description;
    private final String unit;

    public AbstractInstrument(Meter meter, String name, String description, String unit) {
        this.name = Objects.requireNonNull(name);
        this.description = Objects.requireNonNull(description);
        this.unit = Objects.requireNonNull(unit);
        this.delegate = new AtomicReference<T>(this.doBuildInstrument(meter));
    }

    private T doBuildInstrument(Meter meter) {
        return (T)AccessController.doPrivileged(() -> this.buildInstrument(meter));
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.unit.toString();
    }

    T getInstrument() {
        return this.delegate.get();
    }

    String getDescription() {
        return this.description;
    }

    void setProvider(@Nullable Meter meter) {
        this.delegate.set(this.doBuildInstrument(Objects.requireNonNull(meter)));
    }

    abstract T buildInstrument(Meter var1);
}

