/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal.metrics;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import java.security.AccessController;
import java.util.function.Supplier;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.telemetry.apm.internal.APMAgentSettings;
import org.elasticsearch.telemetry.apm.internal.metrics.Instruments;
import org.elasticsearch.telemetry.metric.DoubleCounter;
import org.elasticsearch.telemetry.metric.DoubleGauge;
import org.elasticsearch.telemetry.metric.DoubleHistogram;
import org.elasticsearch.telemetry.metric.DoubleUpDownCounter;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.LongGauge;
import org.elasticsearch.telemetry.metric.LongHistogram;
import org.elasticsearch.telemetry.metric.LongUpDownCounter;
import org.elasticsearch.telemetry.metric.Meter;

public class APMMeter
extends AbstractLifecycleComponent
implements Meter {
    private final Instruments instruments;
    private final Supplier<io.opentelemetry.api.metrics.Meter> otelMeterSupplier;
    private final Supplier<io.opentelemetry.api.metrics.Meter> noopMeterSupplier;
    private volatile boolean enabled;

    public APMMeter(Settings settings) {
        this(settings, APMMeter.otelMeter(), APMMeter.noopMeter());
    }

    public APMMeter(Settings settings, Supplier<io.opentelemetry.api.metrics.Meter> otelMeterSupplier, Supplier<io.opentelemetry.api.metrics.Meter> noopMeterSupplier) {
        this.enabled = (Boolean)APMAgentSettings.TELEMETRY_METRICS_ENABLED_SETTING.get(settings);
        this.otelMeterSupplier = otelMeterSupplier;
        this.noopMeterSupplier = noopMeterSupplier;
        this.instruments = new Instruments(this.enabled ? this.createOtelMeter() : this.createNoopMeter());
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.instruments.setProvider(this.createOtelMeter());
        } else {
            this.instruments.setProvider(this.createNoopMeter());
        }
    }

    protected void doStart() {
    }

    protected void doStop() {
        this.instruments.setProvider(this.createNoopMeter());
    }

    protected void doClose() {
    }

    public DoubleCounter registerDoubleCounter(String name, String description, String unit) {
        return this.instruments.registerDoubleCounter(name, description, unit);
    }

    public DoubleCounter getDoubleCounter(String name) {
        return this.instruments.getDoubleCounter(name);
    }

    public DoubleUpDownCounter registerDoubleUpDownCounter(String name, String description, String unit) {
        return this.instruments.registerDoubleUpDownCounter(name, description, unit);
    }

    public DoubleUpDownCounter getDoubleUpDownCounter(String name) {
        return this.instruments.getDoubleUpDownCounter(name);
    }

    public DoubleGauge registerDoubleGauge(String name, String description, String unit) {
        return this.instruments.registerDoubleGauge(name, description, unit);
    }

    public DoubleGauge getDoubleGauge(String name) {
        return this.instruments.getDoubleGauge(name);
    }

    public DoubleHistogram registerDoubleHistogram(String name, String description, String unit) {
        return this.instruments.registerDoubleHistogram(name, description, unit);
    }

    public DoubleHistogram getDoubleHistogram(String name) {
        return this.instruments.getDoubleHistogram(name);
    }

    public LongCounter registerLongCounter(String name, String description, String unit) {
        return this.instruments.registerLongCounter(name, description, unit);
    }

    public LongCounter getLongCounter(String name) {
        return this.instruments.getLongCounter(name);
    }

    public LongUpDownCounter registerLongUpDownCounter(String name, String description, String unit) {
        return this.instruments.registerLongUpDownCounter(name, description, unit);
    }

    public LongUpDownCounter getLongUpDownCounter(String name) {
        return this.instruments.getLongUpDownCounter(name);
    }

    public LongGauge registerLongGauge(String name, String description, String unit) {
        return this.instruments.registerLongGauge(name, description, unit);
    }

    public LongGauge getLongGauge(String name) {
        return this.instruments.getLongGauge(name);
    }

    public LongHistogram registerLongHistogram(String name, String description, String unit) {
        return this.instruments.registerLongHistogram(name, description, unit);
    }

    public LongHistogram getLongHistogram(String name) {
        return this.instruments.getLongHistogram(name);
    }

    io.opentelemetry.api.metrics.Meter createOtelMeter() {
        assert (this.enabled);
        return AccessController.doPrivileged(this.otelMeterSupplier::get);
    }

    private io.opentelemetry.api.metrics.Meter createNoopMeter() {
        return this.noopMeterSupplier.get();
    }

    private static Supplier<io.opentelemetry.api.metrics.Meter> noopMeter() {
        return () -> OpenTelemetry.noop().getMeter("noop");
    }

    private static Supplier<io.opentelemetry.api.metrics.Meter> otelMeter() {
        OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
        io.opentelemetry.api.metrics.Meter meter = openTelemetry.getMeter("elasticsearch");
        return () -> meter;
    }

    Instruments getInstruments() {
        return this.instruments;
    }
}

