/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal;

import java.security.AccessController;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.telemetry.apm.internal.APMTelemetryProvider;
import org.elasticsearch.telemetry.apm.internal.metrics.APMMeter;
import org.elasticsearch.telemetry.apm.internal.tracing.APMTracer;

public class APMAgentSettings {
    private static final Logger LOGGER = LogManager.getLogger(APMAgentSettings.class);
    static Map<String, String> APM_AGENT_DEFAULT_SETTINGS = Map.of("transaction_sample_rate", "0.2", "enable_experimental_instrumentations", "true");
    private static final String APM_SETTING_PREFIX = "tracing.apm.";
    private static final List<String> PROHIBITED_AGENT_KEYS = List.of("config_file", "recording", "instrument");
    public static final Setting.AffixSetting<String> APM_AGENT_SETTINGS = Setting.prefixKeySetting((String)"tracing.apm.agent.", qualifiedKey -> {
        String[] parts = qualifiedKey.split("\\.");
        String key = parts[parts.length - 1];
        String defaultValue = APM_AGENT_DEFAULT_SETTINGS.getOrDefault(key, "");
        return new Setting(qualifiedKey, defaultValue, value -> {
            if (PROHIBITED_AGENT_KEYS.contains(key)) {
                throw new IllegalArgumentException("Explicitly configuring [" + qualifiedKey + "] is prohibited");
            }
            return value;
        }, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.OperatorDynamic});
    });
    public static final Setting<List<String>> APM_TRACING_NAMES_INCLUDE_SETTING = Setting.stringListSetting((String)"tracing.apm.names.include", (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final Setting<List<String>> APM_TRACING_NAMES_EXCLUDE_SETTING = Setting.stringListSetting((String)"tracing.apm.names.exclude", (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final Setting<List<String>> APM_TRACING_SANITIZE_FIELD_NAMES = Setting.stringListSetting((String)"tracing.apm.sanitize_field_names", List.of("password", "passwd", "pwd", "secret", "*key", "*token*", "*session*", "*credit*", "*card*", "*auth*", "*principal*", "set-cookie"), (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final Setting<Boolean> APM_ENABLED_SETTING = Setting.boolSetting((String)"tracing.apm.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final Setting<Boolean> TELEMETRY_METRICS_ENABLED_SETTING = Setting.boolSetting((String)"telemetry.metrics.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final Setting<SecureString> APM_SECRET_TOKEN_SETTING = SecureSetting.secureString((String)"tracing.apm.secret_token", null, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<SecureString> APM_API_KEY_SETTING = SecureSetting.secureString((String)"tracing.apm.api_key", null, (Setting.Property[])new Setting.Property[0]);

    public void addClusterSettingsListeners(ClusterService clusterService, APMTelemetryProvider apmTelemetryProvider) {
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        APMTracer apmTracer = apmTelemetryProvider.getTracer();
        APMMeter apmMeter = apmTelemetryProvider.getMeter();
        clusterSettings.addSettingsUpdateConsumer(APM_ENABLED_SETTING, enabled -> {
            apmTracer.setEnabled((boolean)enabled);
            this.setAgentSetting("instrument", Boolean.toString(enabled));
        });
        clusterSettings.addSettingsUpdateConsumer(TELEMETRY_METRICS_ENABLED_SETTING, enabled -> {
            apmMeter.setEnabled((boolean)enabled);
            this.setAgentSetting("recording", Boolean.toString(enabled));
        });
        clusterSettings.addSettingsUpdateConsumer(APM_TRACING_NAMES_INCLUDE_SETTING, apmTracer::setIncludeNames);
        clusterSettings.addSettingsUpdateConsumer(APM_TRACING_NAMES_EXCLUDE_SETTING, apmTracer::setExcludeNames);
        clusterSettings.addSettingsUpdateConsumer(APM_TRACING_SANITIZE_FIELD_NAMES, apmTracer::setLabelFilters);
        clusterSettings.addAffixMapUpdateConsumer(APM_AGENT_SETTINGS, map -> map.forEach(this::setAgentSetting), (x, y) -> {});
    }

    public void syncAgentSystemProperties(Settings settings) {
        this.setAgentSetting("recording", Boolean.toString((Boolean)APM_ENABLED_SETTING.get(settings)));
        APM_AGENT_DEFAULT_SETTINGS.keySet().forEach(key -> this.setAgentSetting((String)key, (String)APM_AGENT_SETTINGS.getConcreteSetting(APM_AGENT_SETTINGS.getKey() + key).get(settings)));
        APM_AGENT_SETTINGS.getAsMap(settings).forEach(this::setAgentSetting);
    }

    @SuppressForbidden(reason="Need to be able to manipulate APM agent-related properties to set them dynamically")
    public void setAgentSetting(String key, String value) {
        String completeKey = "elastic.apm." + Objects.requireNonNull(key);
        AccessController.doPrivileged(() -> {
            if (value == null || value.isEmpty()) {
                LOGGER.trace("Clearing system property [{}]", (Object)completeKey);
                System.clearProperty(completeKey);
            } else {
                LOGGER.trace("Setting setting property [{}] to [{}]", (Object)completeKey, (Object)value);
                System.setProperty(completeKey, value);
            }
            return null;
        });
    }
}

