/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.TelemetryPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.telemetry.apm.internal.APMAgentSettings;
import org.elasticsearch.telemetry.apm.internal.APMTelemetryProvider;
import org.elasticsearch.telemetry.apm.internal.metrics.APMMeter;
import org.elasticsearch.telemetry.apm.internal.tracing.APMTracer;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class APM
extends Plugin
implements NetworkPlugin,
TelemetryPlugin {
    private final SetOnce<APMTelemetryProvider> telemetryProvider = new SetOnce();
    private final Settings settings;

    public APM(Settings settings) {
        this.settings = settings;
    }

    public TelemetryProvider getTelemetryProvider(Settings settings) {
        APMTelemetryProvider apmTelemetryProvider = new APMTelemetryProvider(settings);
        this.telemetryProvider.set((Object)apmTelemetryProvider);
        return apmTelemetryProvider;
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier, TelemetryProvider unused, AllocationService allocationService, IndicesService indicesService) {
        APMTracer apmTracer = ((APMTelemetryProvider)this.telemetryProvider.get()).getTracer();
        apmTracer.setClusterName(clusterService.getClusterName().value());
        apmTracer.setNodeName(clusterService.getNodeName());
        APMAgentSettings apmAgentSettings = new APMAgentSettings();
        apmAgentSettings.syncAgentSystemProperties(this.settings);
        apmAgentSettings.addClusterSettingsListeners(clusterService, (APMTelemetryProvider)this.telemetryProvider.get());
        APMMeter apmMeter = ((APMTelemetryProvider)this.telemetryProvider.get()).getMeter();
        return List.of(apmTracer, apmMeter);
    }

    public List<Setting<?>> getSettings() {
        return List.of(APMAgentSettings.APM_ENABLED_SETTING, APMAgentSettings.TELEMETRY_METRICS_ENABLED_SETTING, APMAgentSettings.APM_TRACING_NAMES_INCLUDE_SETTING, APMAgentSettings.APM_TRACING_NAMES_EXCLUDE_SETTING, APMAgentSettings.APM_TRACING_SANITIZE_FIELD_NAMES, APMAgentSettings.APM_AGENT_SETTINGS, APMAgentSettings.APM_SECRET_TOKEN_SETTING, APMAgentSettings.APM_API_KEY_SETTING);
    }
}

