/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.util;

import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.predicate.regex.LikePattern;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public final class StringUtils {
    private StringUtils() {
    }

    public static LikePattern toLikePattern(String s) {
        char escape = '\u0001';
        String escapeString = Character.toString(escape);
        String likeString = s.replace("%", escapeString + "%").replace("_", escapeString + "_").replace("*", "%").replace("?", "_");
        return new LikePattern(likeString, escape);
    }

    public static LikePattern toLikePattern(Expression expression) {
        if (!expression.foldable() || !DataTypes.isString((DataType)expression.dataType())) {
            throw new EqlIllegalArgumentException("Invalid like pattern received {}", expression);
        }
        return StringUtils.toLikePattern(expression.fold().toString());
    }
}

