/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plugin;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.BreakerSettings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.CircuitBreakerPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.eql.EqlInfoTransportAction;
import org.elasticsearch.xpack.eql.EqlUsageTransportAction;
import org.elasticsearch.xpack.eql.action.EqlSearchAction;
import org.elasticsearch.xpack.eql.execution.PlanExecutor;
import org.elasticsearch.xpack.eql.plugin.EqlAsyncGetResultAction;
import org.elasticsearch.xpack.eql.plugin.EqlAsyncGetStatusAction;
import org.elasticsearch.xpack.eql.plugin.EqlStatsAction;
import org.elasticsearch.xpack.eql.plugin.RestEqlDeleteAsyncResultAction;
import org.elasticsearch.xpack.eql.plugin.RestEqlGetAsyncResultAction;
import org.elasticsearch.xpack.eql.plugin.RestEqlGetAsyncStatusAction;
import org.elasticsearch.xpack.eql.plugin.RestEqlSearchAction;
import org.elasticsearch.xpack.eql.plugin.RestEqlStatsAction;
import org.elasticsearch.xpack.eql.plugin.TransportEqlAsyncGetResultsAction;
import org.elasticsearch.xpack.eql.plugin.TransportEqlAsyncGetStatusAction;
import org.elasticsearch.xpack.eql.plugin.TransportEqlSearchAction;
import org.elasticsearch.xpack.eql.plugin.TransportEqlStatsAction;
import org.elasticsearch.xpack.ql.index.IndexResolver;
import org.elasticsearch.xpack.ql.index.RemoteClusterResolver;
import org.elasticsearch.xpack.ql.type.DefaultDataTypeRegistry;

public class EqlPlugin
extends Plugin
implements ActionPlugin,
CircuitBreakerPlugin {
    public static final String CIRCUIT_BREAKER_NAME = "eql_sequence";
    public static final long CIRCUIT_BREAKER_LIMIT = (long)(0.5 * (double)JvmInfo.jvmInfo().getMem().getHeapMax().getBytes());
    public static final double CIRCUIT_BREAKER_OVERHEAD = 1.0;
    private final SetOnce<CircuitBreaker> circuitBreaker = new SetOnce();
    public static final Setting<Boolean> EQL_ENABLED_SETTING = Setting.boolSetting((String)"xpack.eql.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.DeprecatedWarning});

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier, TelemetryProvider telemetryProvider, AllocationService allocationService, IndicesService indicesService) {
        return this.createComponents(client, environment.settings(), clusterService);
    }

    private Collection<Object> createComponents(Client client, Settings settings, ClusterService clusterService) {
        RemoteClusterResolver remoteClusterResolver = new RemoteClusterResolver(settings, clusterService.getClusterSettings());
        IndexResolver indexResolver = new IndexResolver(client, clusterService.getClusterName().value(), DefaultDataTypeRegistry.INSTANCE, () -> ((RemoteClusterResolver)remoteClusterResolver).remoteClusters());
        PlanExecutor planExecutor = new PlanExecutor(client, indexResolver, (CircuitBreaker)this.circuitBreaker.get());
        return Collections.singletonList(planExecutor);
    }

    public List<Setting<?>> getSettings() {
        return List.of(EQL_ENABLED_SETTING);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of(new ActionPlugin.ActionHandler((ActionType)EqlSearchAction.INSTANCE, TransportEqlSearchAction.class), new ActionPlugin.ActionHandler((ActionType)EqlStatsAction.INSTANCE, TransportEqlStatsAction.class), new ActionPlugin.ActionHandler((ActionType)EqlAsyncGetResultAction.INSTANCE, TransportEqlAsyncGetResultsAction.class), new ActionPlugin.ActionHandler((ActionType)EqlAsyncGetStatusAction.INSTANCE, TransportEqlAsyncGetStatusAction.class), new ActionPlugin.ActionHandler((ActionType)XPackUsageFeatureAction.EQL, EqlUsageTransportAction.class), new ActionPlugin.ActionHandler((ActionType)XPackInfoFeatureAction.EQL, EqlInfoTransportAction.class));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return List.of(new RestEqlSearchAction(), new RestEqlStatsAction(), new RestEqlGetAsyncResultAction(), new RestEqlGetAsyncStatusAction(), new RestEqlDeleteAsyncResultAction());
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public BreakerSettings getCircuitBreaker(Settings settings) {
        return BreakerSettings.updateFromSettings((BreakerSettings)new BreakerSettings(CIRCUIT_BREAKER_NAME, CIRCUIT_BREAKER_LIMIT, 1.0, CircuitBreaker.Type.MEMORY, CircuitBreaker.Durability.TRANSIENT), (Settings)settings);
    }

    public void setCircuitBreaker(CircuitBreaker circuitBreaker) {
        assert (circuitBreaker.getName().equals(CIRCUIT_BREAKER_NAME));
        this.circuitBreaker.set((Object)circuitBreaker);
    }
}

