/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.search;

import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.ClosePointInTimeAction;
import org.elasticsearch.action.search.ClosePointInTimeRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.OpenPointInTimeAction;
import org.elasticsearch.action.search.OpenPointInTimeRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.builder.PointInTimeBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.eql.execution.search.BasicQueryClient;
import org.elasticsearch.xpack.eql.execution.search.RuntimeUtils;
import org.elasticsearch.xpack.eql.session.EqlSession;
import org.elasticsearch.xpack.ql.index.IndexResolver;
import org.elasticsearch.xpack.ql.util.ActionListeners;

public class PITAwareQueryClient
extends BasicQueryClient {
    private String pitId;
    private final TimeValue keepAlive;

    public PITAwareQueryClient(EqlSession eqlSession) {
        super(eqlSession);
        this.keepAlive = eqlSession.configuration().requestTimeout();
    }

    @Override
    protected void search(SearchRequest search, ActionListener<SearchResponse> listener) {
        if (this.pitId == null) {
            this.openPIT(listener, () -> this.searchWithPIT(search, listener));
        } else {
            this.searchWithPIT(search, listener);
        }
    }

    private void searchWithPIT(SearchRequest request, ActionListener<SearchResponse> listener) {
        this.makeRequestPITCompatible(request);
        super.search(request, this.pitListener(SearchResponse::pointInTimeId, listener));
    }

    @Override
    protected void search(MultiSearchRequest search, ActionListener<MultiSearchResponse> listener) {
        if (this.pitId == null) {
            this.openPIT(listener, () -> this.searchWithPIT(search, listener));
        } else {
            this.searchWithPIT(search, listener);
        }
    }

    private void searchWithPIT(MultiSearchRequest search, ActionListener<MultiSearchResponse> listener) {
        for (SearchRequest request : search.requests()) {
            this.makeRequestPITCompatible(request);
        }
        super.search(search, this.pitListener(r -> {
            for (MultiSearchResponse.Item item : r.getResponses()) {
                if (item.isFailure()) continue;
                return item.getResponse().pointInTimeId();
            }
            return this.pitId;
        }, listener));
    }

    private void makeRequestPITCompatible(SearchRequest request) {
        SearchSourceBuilder source = request.source();
        source.pointInTimeBuilder(new PointInTimeBuilder(this.pitId));
        Object[] indices = request.indices();
        if (!CollectionUtils.isEmpty((Object[])indices)) {
            request.indices(Strings.EMPTY_ARRAY);
            TermsQueryBuilder indexQuery = indices.length == 1 ? QueryBuilders.termQuery((String)"_index", (String)indices[0]) : QueryBuilders.termsQuery((String)"_index", (String[])indices);
            RuntimeUtils.combineFilters(source, (QueryBuilder)indexQuery);
        }
    }

    private <Response> ActionListener<Response> pitListener(Function<Response, String> pitIdExtractor, ActionListener<Response> listener) {
        return ActionListener.wrap(r -> {
            this.pitId = (String)pitIdExtractor.apply(r);
            listener.onResponse(r);
        }, e -> {
            listener.onFailure(e);
            if (this.pitId != null && !this.cfg.isCancelled()) {
                this.close((ActionListener<Boolean>)ActionListener.wrap(b -> {}, ex -> {}));
            }
        });
    }

    private <Response> void openPIT(ActionListener<Response> listener, Runnable runnable) {
        OpenPointInTimeRequest request = new OpenPointInTimeRequest(this.indices).indicesOptions(IndexResolver.FIELD_CAPS_INDICES_OPTIONS).keepAlive(this.keepAlive);
        this.client.execute((ActionType)OpenPointInTimeAction.INSTANCE, (ActionRequest)request, listener.delegateFailureAndWrap((l, r) -> {
            this.pitId = r.getPointInTimeId();
            runnable.run();
        }));
    }

    @Override
    public void close(ActionListener<Boolean> listener) {
        if (this.pitId != null) {
            this.client.execute((ActionType)ClosePointInTimeAction.INSTANCE, (ActionRequest)new ClosePointInTimeRequest(this.pitId), ActionListeners.map(listener, ClearScrollResponse::isSucceeded));
            this.pitId = null;
        }
    }
}

