/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.transport.actions.stats;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.WatcherMetadata;
import org.elasticsearch.xpack.core.watcher.WatcherState;
import org.elasticsearch.xpack.core.watcher.common.stats.Counters;
import org.elasticsearch.xpack.core.watcher.execution.QueuedWatch;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionSnapshot;

public class WatcherStatsResponse
extends BaseNodesResponse<Node>
implements ToXContentObject {
    private final WatcherMetadata watcherMetadata;

    public WatcherStatsResponse(StreamInput in) throws IOException {
        super(in);
        this.watcherMetadata = new WatcherMetadata(in.readBoolean());
    }

    public WatcherStatsResponse(ClusterName clusterName, WatcherMetadata watcherMetadata, List<Node> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
        this.watcherMetadata = watcherMetadata;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.watcherMetadata.manuallyStopped());
    }

    protected List<Node> readNodesFrom(StreamInput in) throws IOException {
        return in.readCollectionAsList(Node::new);
    }

    protected void writeNodesTo(StreamOutput out, List<Node> nodes) throws IOException {
        out.writeCollection(nodes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        ChunkedToXContent.wrapAsToXContent((ChunkedToXContent)this.watcherMetadata).toXContent(builder, params);
        builder.startArray("stats");
        for (Node node : this.getNodes()) {
            node.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public long getWatchesCount() {
        return this.getNodes().stream().mapToLong(Node::getWatchesCount).sum();
    }

    public WatcherMetadata watcherMetadata() {
        return this.watcherMetadata;
    }

    public static class Node
    extends BaseNodeResponse
    implements ToXContentObject {
        private long watchesCount;
        private WatcherState watcherState;
        private long threadPoolQueueSize;
        private long threadPoolMaxSize;
        private List<WatchExecutionSnapshot> snapshots;
        private List<QueuedWatch> queuedWatches;
        private Counters stats;

        public Node(StreamInput in) throws IOException {
            super(in);
            this.watchesCount = in.readLong();
            this.threadPoolQueueSize = in.readLong();
            this.threadPoolMaxSize = in.readLong();
            this.watcherState = WatcherState.fromId(in.readByte());
            if (in.readBoolean()) {
                this.snapshots = in.readCollectionAsList(WatchExecutionSnapshot::new);
            }
            if (in.readBoolean()) {
                this.queuedWatches = in.readCollectionAsList(QueuedWatch::new);
            }
            if (in.readBoolean()) {
                this.stats = new Counters(in);
            }
        }

        public Node(DiscoveryNode node) {
            super(node);
        }

        public long getThreadPoolQueueSize() {
            return this.threadPoolQueueSize;
        }

        public void setThreadPoolQueueSize(long threadPoolQueueSize) {
            this.threadPoolQueueSize = threadPoolQueueSize;
        }

        public long getThreadPoolMaxSize() {
            return this.threadPoolMaxSize;
        }

        public void setThreadPoolMaxSize(long threadPoolMaxSize) {
            this.threadPoolMaxSize = threadPoolMaxSize;
        }

        public long getWatchesCount() {
            return this.watchesCount;
        }

        public void setWatchesCount(long watchesCount) {
            this.watchesCount = watchesCount;
        }

        public WatcherState getWatcherState() {
            return this.watcherState;
        }

        public void setWatcherState(WatcherState watcherServiceState) {
            this.watcherState = watcherServiceState;
        }

        @Nullable
        public List<WatchExecutionSnapshot> getSnapshots() {
            return this.snapshots;
        }

        public void setSnapshots(List<WatchExecutionSnapshot> snapshots) {
            this.snapshots = snapshots;
        }

        @Nullable
        public List<QueuedWatch> getQueuedWatches() {
            return this.queuedWatches;
        }

        public void setQueuedWatches(List<QueuedWatch> queuedWatches) {
            this.queuedWatches = queuedWatches;
        }

        public Counters getStats() {
            return this.stats;
        }

        public void setStats(Counters stats) {
            this.stats = stats;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeLong(this.watchesCount);
            out.writeLong(this.threadPoolQueueSize);
            out.writeLong(this.threadPoolMaxSize);
            out.writeByte(this.watcherState.getId());
            out.writeBoolean(this.snapshots != null);
            if (this.snapshots != null) {
                out.writeCollection(this.snapshots);
            }
            out.writeBoolean(this.queuedWatches != null);
            if (this.queuedWatches != null) {
                out.writeCollection(this.queuedWatches);
            }
            out.writeBoolean(this.stats != null);
            if (this.stats != null) {
                this.stats.writeTo(out);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("node_id", this.getNode().getId());
            builder.field("watcher_state", this.watcherState.toString().toLowerCase(Locale.ROOT));
            builder.field("watch_count", this.watchesCount);
            builder.startObject("execution_thread_pool");
            builder.field("queue_size", this.threadPoolQueueSize);
            builder.field("max_size", this.threadPoolMaxSize);
            builder.endObject();
            if (this.snapshots != null) {
                builder.startArray("current_watches");
                for (WatchExecutionSnapshot snapshot : this.snapshots) {
                    snapshot.toXContent(builder, params);
                }
                builder.endArray();
            }
            if (this.queuedWatches != null) {
                builder.startArray("queued_watches");
                for (QueuedWatch queuedWatch : this.queuedWatches) {
                    queuedWatch.toXContent(builder, params);
                }
                builder.endArray();
            }
            if (this.stats != null && this.stats.hasCounters()) {
                builder.field("stats", this.stats.toNestedMap());
            }
            builder.endObject();
            return builder;
        }
    }
}

