/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.transport.actions.put;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;

public class UpdateWatcherSettingsAction
extends ActionType<AcknowledgedResponse> {
    public static final UpdateWatcherSettingsAction INSTANCE = new UpdateWatcherSettingsAction();
    public static final String NAME = "cluster:admin/xpack/watcher/settings/update";
    public static final Set<String> ALLOWED_SETTING_KEYS = Set.of("index.number_of_replicas", "index.auto_expand_replicas");

    public UpdateWatcherSettingsAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final Map<String, Object> settings;

        public Request(Map<String, Object> settings) {
            this.settings = settings;
        }

        public Request(StreamInput in) throws IOException {
            this.settings = in.readMap();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeGenericMap(this.settings);
        }

        public Map<String, Object> settings() {
            return this.settings;
        }

        public ActionRequestValidationException validate() {
            Set forbiddenSettings = Sets.difference(this.settings.keySet(), ALLOWED_SETTING_KEYS);
            if (forbiddenSettings.size() > 0) {
                return ValidateActions.addValidationError((String)("illegal settings: " + forbiddenSettings + ", these settings may not be configured. Only the following settings may be configured: " + ALLOWED_SETTING_KEYS), null);
            }
            return null;
        }
    }
}

