/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.TransformStats;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;

public class GetTransformStatsAction
extends ActionType<Response> {
    public static final GetTransformStatsAction INSTANCE = new GetTransformStatsAction();
    public static final String NAME = "cluster:monitor/transform/stats/get";

    public GetTransformStatsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends BaseTasksResponse
    implements ToXContentObject {
        private final QueryPage<TransformStats> transformsStats;

        public Response(List<TransformStats> transformStateAndStats) {
            this(new QueryPage<TransformStats>(transformStateAndStats, transformStateAndStats.size(), TransformField.TRANSFORMS));
        }

        public Response(List<TransformStats> transformStateAndStats, long count, List<TaskOperationFailure> taskFailures, List<? extends ElasticsearchException> nodeFailures) {
            this(new QueryPage<TransformStats>(transformStateAndStats, count, TransformField.TRANSFORMS), taskFailures, nodeFailures);
        }

        public Response(QueryPage<TransformStats> transformsStats) {
            this(transformsStats, Collections.emptyList(), Collections.emptyList());
        }

        private Response(QueryPage<TransformStats> transformsStats, List<TaskOperationFailure> taskFailures, List<? extends ElasticsearchException> nodeFailures) {
            super(taskFailures, nodeFailures);
            this.transformsStats = ExceptionsHelper.requireNonNull(transformsStats, "transformsStats");
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.transformsStats = new QueryPage(in, TransformStats::new);
        }

        public List<TransformStats> getTransformsStats() {
            return this.transformsStats.results();
        }

        public long getCount() {
            return this.transformsStats.count();
        }

        public ParseField getResultsField() {
            return this.transformsStats.getResultsField();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.transformsStats.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.toXContentCommon(builder, params);
            this.transformsStats.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.transformsStats);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
                return false;
            }
            Response that = (Response)((Object)other);
            return Objects.equals(this.transformsStats, that.transformsStats);
        }

        public final String toString() {
            return org.elasticsearch.common.Strings.toString((ToXContent)this);
        }
    }

    public static class Request
    extends BaseTasksRequest<Request> {
        private final String id;
        private PageParams pageParams = PageParams.defaultParams();
        private boolean allowNoMatch = true;
        public static final int MAX_SIZE_RETURN = 1000;
        private List<String> expandedIds;

        public Request(String id, @Nullable TimeValue timeout) {
            this.setTimeout(timeout);
            this.id = org.elasticsearch.common.Strings.isNullOrEmpty((String)id) || id.equals("*") ? "_all" : id;
            this.expandedIds = Collections.singletonList(this.id);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.id = in.readString();
            this.expandedIds = in.readCollectionAsImmutableList(StreamInput::readString);
            this.pageParams = new PageParams(in);
            this.allowNoMatch = in.readBoolean();
        }

        public boolean match(Task task) {
            return this.expandedIds.stream().anyMatch(transformId -> task.getDescription().equals("data_frame_" + transformId));
        }

        public String getId() {
            return this.id;
        }

        public List<String> getExpandedIds() {
            return this.expandedIds;
        }

        public void setExpandedIds(List<String> expandedIds) {
            this.expandedIds = List.copyOf(expandedIds);
        }

        public final void setPageParams(PageParams pageParams) {
            this.pageParams = Objects.requireNonNull(pageParams);
        }

        public final PageParams getPageParams() {
            return this.pageParams;
        }

        public boolean isAllowNoMatch() {
            return this.allowNoMatch;
        }

        public void setAllowNoMatch(boolean allowNoMatch) {
            this.allowNoMatch = allowNoMatch;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.id);
            out.writeStringCollection(this.expandedIds);
            this.pageParams.writeTo(out);
            out.writeBoolean(this.allowNoMatch);
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException exception = null;
            if (this.getPageParams() != null && this.getPageParams().getSize() > 1000) {
                exception = ValidateActions.addValidationError((String)("Param [" + PageParams.SIZE.getPreferredName() + "] has a max acceptable value of [1000]"), exception);
            }
            return exception;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.pageParams, this.allowNoMatch);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.id, other.id) && Objects.equals(this.pageParams, other.pageParams) && this.allowNoMatch == other.allowNoMatch;
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, Strings.format((String)"get_transform_stats[%s]", (Object[])new Object[]{this.id}), parentTaskId, headers);
        }
    }
}

