/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.termsenum.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class TermsEnumRequest
extends BroadcastRequest<TermsEnumRequest>
implements ToXContentObject {
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = SearchRequest.DEFAULT_INDICES_OPTIONS;
    public static int DEFAULT_SIZE = 10;
    public static TimeValue DEFAULT_TIMEOUT = new TimeValue(1000L);
    private String field;
    private String string = null;
    private String searchAfter = null;
    private int size = DEFAULT_SIZE;
    private boolean caseInsensitive;
    private QueryBuilder indexFilter;

    public TermsEnumRequest() {
        this(Strings.EMPTY_ARRAY);
    }

    public TermsEnumRequest(String ... indices) {
        super(indices);
        this.indicesOptions(DEFAULT_INDICES_OPTIONS);
        this.timeout(DEFAULT_TIMEOUT);
    }

    public TermsEnumRequest(TermsEnumRequest clone) {
        super(new String[0]);
        this.field = clone.field;
        this.string = clone.string;
        this.searchAfter = clone.searchAfter;
        this.caseInsensitive = clone.caseInsensitive;
        this.size = clone.size;
        this.indexFilter = clone.indexFilter;
        this.indices(clone.indices);
        this.indicesOptions(clone.indicesOptions());
        this.timeout(clone.timeout());
        this.setParentTask(clone.getParentTask());
    }

    public TermsEnumRequest(StreamInput in) throws IOException {
        super(in);
        this.field = in.readString();
        this.string = in.readOptionalString();
        this.searchAfter = in.readOptionalString();
        this.caseInsensitive = in.readBoolean();
        this.size = in.readVInt();
        this.indexFilter = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.field);
        out.writeOptionalString(this.string);
        out.writeOptionalString(this.searchAfter);
        out.writeBoolean(this.caseInsensitive);
        out.writeVInt(this.size);
        out.writeOptionalNamedWriteable((NamedWriteable)this.indexFilter);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("field", this.field);
        if (this.string != null) {
            builder.field("string", this.string);
        }
        if (this.searchAfter != null) {
            builder.field("search_after", this.searchAfter);
        }
        builder.field("size", this.size);
        builder.field("timeout", (Object)this.timeout());
        builder.field("case_insensitive", this.caseInsensitive);
        if (this.indexFilter != null) {
            builder.field("index_filter", (ToXContent)this.indexFilter);
        }
        return builder.endObject();
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.string != null && new BytesRef((CharSequence)this.string).length > 32766) {
            validationException = ValidateActions.addValidationError((String)"prefix string larger than 32766 characters, which is the maximum allowed term length for keyword fields.", (ActionRequestValidationException)validationException);
        }
        if (this.field == null) {
            validationException = ValidateActions.addValidationError((String)"field cannot be null", (ActionRequestValidationException)validationException);
        }
        if (this.timeout() == null) {
            validationException = ValidateActions.addValidationError((String)"Timeout cannot be null", (ActionRequestValidationException)validationException);
        } else if (this.timeout().getSeconds() > 60L) {
            validationException = ValidateActions.addValidationError((String)"Timeout cannot be > 1 minute", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public boolean allowsRemoteIndices() {
        return true;
    }

    public TermsEnumRequest field(String field) {
        this.field = field;
        return this;
    }

    public String field() {
        return this.field;
    }

    public TermsEnumRequest string(String string) {
        this.string = string;
        return this;
    }

    @Nullable
    public String string() {
        return this.string;
    }

    @Nullable
    public String searchAfter() {
        return this.searchAfter;
    }

    public TermsEnumRequest searchAfter(String searchAfter) {
        this.searchAfter = searchAfter;
        return this;
    }

    public int size() {
        return this.size;
    }

    public TermsEnumRequest size(int size) {
        this.size = size;
        return this;
    }

    public TermsEnumRequest caseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        return this;
    }

    public boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    public TermsEnumRequest indexFilter(QueryBuilder indexFilter) {
        this.indexFilter = indexFilter;
        return this;
    }

    public QueryBuilder indexFilter() {
        return this.indexFilter;
    }

    public String toString() {
        return "[" + Arrays.toString(this.indices) + "] field[" + this.field + "], string[" + this.string + "]  size=" + this.size + " timeout=" + this.timeout().getMillis() + " case_insensitive=" + this.caseInsensitive + " indexFilter = " + this.indexFilter + " searchAfter[" + this.searchAfter + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TermsEnumRequest that = (TermsEnumRequest)((Object)o);
        return this.size == that.size && this.caseInsensitive == that.caseInsensitive && Objects.equals(this.field, that.field) && Objects.equals(this.string, that.string) && Objects.equals(this.searchAfter, that.searchAfter) && Objects.equals(this.indexFilter, that.indexFilter) && Arrays.equals(this.indices, that.indices) && Objects.equals(this.indicesOptions(), that.indicesOptions()) && Objects.equals(this.timeout(), that.timeout());
    }

    public int hashCode() {
        int result = Objects.hash(this.field, this.string, this.searchAfter, this.size, this.caseInsensitive, this.indexFilter, this.indicesOptions(), this.timeout());
        result = 31 * result + Arrays.hashCode(this.indices);
        return result;
    }
}

