/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.store;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.store.KibanaOwnedReservedRoleDescriptors;
import org.elasticsearch.xpack.core.security.authz.store.RoleRetrievalResult;
import org.elasticsearch.xpack.core.security.support.MetadataUtils;

public class ReservedRolesStore
implements BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>> {
    public static final String ALERTS_LEGACY_INDEX = ".siem-signals*";
    public static final String ALERTS_BACKING_INDEX = ".internal.alerts*";
    public static final String ALERTS_INDEX_ALIAS = ".alerts*";
    public static final String PREVIEW_ALERTS_INDEX_ALIAS = ".preview.alerts*";
    public static final String PREVIEW_ALERTS_BACKING_INDEX_ALIAS = ".internal.preview.alerts*";
    public static final String LISTS_INDEX = ".lists-*";
    public static final String LISTS_ITEMS_INDEX = ".items-*";
    public static final String UNIVERSAL_PROFILING_ALIASES = "profiling-*";
    public static final String UNIVERSAL_PROFILING_BACKING_INDICES = ".profiling-*";
    public static final RoleDescriptor SUPERUSER_ROLE_DESCRIPTOR = new RoleDescriptor("superuser", new String[]{"all"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("all").allowRestrictedIndices(false).build(), RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("monitor", "read", "view_index_metadata", "read_cross_cluster").allowRestrictedIndices(true).build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("*").privileges("*").resources("*").build()}, null, new String[]{"*"}, MetadataUtils.DEFAULT_RESERVED_METADATA, Collections.emptyMap(), new RoleDescriptor.RemoteIndicesPrivileges[]{new RoleDescriptor.RemoteIndicesPrivileges(RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("all").allowRestrictedIndices(false).build(), "*"), new RoleDescriptor.RemoteIndicesPrivileges(RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("monitor", "read", "view_index_metadata", "read_cross_cluster").allowRestrictedIndices(true).build(), "*")}, null);
    private static final Map<String, RoleDescriptor> ALL_RESERVED_ROLES = ReservedRolesStore.initializeReservedRoles();
    public static final Setting<List<String>> INCLUDED_RESERVED_ROLES_SETTING = Setting.listSetting((String)SecurityField.setting("reserved_roles.include"), List.copyOf(ALL_RESERVED_ROLES.keySet()), Function.identity(), value -> {
        Set valueSet = Set.copyOf(value);
        if (!valueSet.contains("superuser")) {
            throw new IllegalArgumentException("the [superuser] reserved role must be included");
        }
        SortedSet unknownRoles = Sets.sortedDifference(valueSet, ALL_RESERVED_ROLES.keySet());
        if (!unknownRoles.isEmpty()) {
            throw new IllegalArgumentException("unknown reserved roles to include [" + Strings.collectionToCommaDelimitedString((Iterable)unknownRoles));
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static Map<String, RoleDescriptor> RESERVED_ROLES = null;

    public ReservedRolesStore() {
        this(ALL_RESERVED_ROLES.keySet());
    }

    public ReservedRolesStore(Set<String> includes) {
        assert (includes.contains("superuser")) : "superuser must be included";
        RESERVED_ROLES = ALL_RESERVED_ROLES.entrySet().stream().filter(entry -> includes.contains(entry.getKey())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static RoleDescriptor.RemoteIndicesPrivileges getRemoteIndicesReadPrivileges(String indexPattern) {
        return new RoleDescriptor.RemoteIndicesPrivileges(RoleDescriptor.IndicesPrivileges.builder().indices(indexPattern).privileges("read", "read_cross_cluster").allowRestrictedIndices(false).build(), "*");
    }

    private static Map<String, RoleDescriptor> initializeReservedRoles() {
        return Map.ofEntries(Map.entry("superuser", SUPERUSER_ROLE_DESCRIPTOR), Map.entry("transport_client", new RoleDescriptor("transport_client", new String[]{"transport_client"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)), Map.entry("kibana_admin", ReservedRolesStore.kibanaAdminUser("kibana_admin", MetadataUtils.DEFAULT_RESERVED_METADATA)), Map.entry("kibana_user", ReservedRolesStore.kibanaAdminUser("kibana_user", MetadataUtils.getDeprecatedReservedMetadata("Please use the [kibana_admin] role instead"))), Map.entry("monitoring_user", new RoleDescriptor("monitoring_user", new String[]{"cluster:monitor/main", "cluster:monitor/xpack/info", "cluster:monitor/remote/info"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".monitoring-*").privileges("read", "read_cross_cluster").build(), RoleDescriptor.IndicesPrivileges.builder().indices("/metrics-(beats|elasticsearch|enterprisesearch|kibana|logstash).*/").privileges("read", "read_cross_cluster").build(), RoleDescriptor.IndicesPrivileges.builder().indices("metricbeat-*").privileges("read", "read_cross_cluster").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_monitoring").build()}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null, new RoleDescriptor.RemoteIndicesPrivileges[]{ReservedRolesStore.getRemoteIndicesReadPrivileges(".monitoring-*"), ReservedRolesStore.getRemoteIndicesReadPrivileges("/metrics-(beats|elasticsearch|enterprisesearch|kibana|logstash).*/"), ReservedRolesStore.getRemoteIndicesReadPrivileges("metricbeat-*")}, null)), Map.entry("remote_monitoring_agent", new RoleDescriptor("remote_monitoring_agent", new String[]{"manage_index_templates", "manage_ingest_pipelines", "monitor", "cluster:admin/ilm/get", "cluster:admin/ilm/put", "cluster:monitor/xpack/watcher/watch/get", "cluster:admin/xpack/watcher/watch/put", "cluster:admin/xpack/watcher/watch/delete"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".monitoring-*").privileges("all").build(), RoleDescriptor.IndicesPrivileges.builder().indices("metricbeat-*").privileges("index", "create_index", "view_index_metadata", "indices:admin/aliases", "indices:admin/rollover").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)), Map.entry("remote_monitoring_collector", new RoleDescriptor("remote_monitoring_collector", new String[]{"monitor"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("monitor").allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices(".kibana*").privileges("read").allowRestrictedIndices(true).build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)), Map.entry("ingest_admin", new RoleDescriptor("ingest_admin", new String[]{"manage_index_templates", "manage_pipeline"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)), Map.entry("reporting_user", new RoleDescriptor("reporting_user", null, null, null, null, null, MetadataUtils.getDeprecatedReservedMetadata("Please use Kibana feature privileges instead"), null)), Map.entry("kibana_system", ReservedRolesStore.kibanaSystemRoleDescriptor("kibana_system")), Map.entry("logstash_system", new RoleDescriptor("logstash_system", new String[]{"monitor", "cluster:admin/xpack/monitoring/bulk"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)), Map.entry("beats_admin", new RoleDescriptor("beats_admin", null, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".management-beats").privileges("all").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)), Map.entry("beats_system", new RoleDescriptor("beats_system", new String[]{"monitor", "cluster:admin/xpack/monitoring/bulk"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".monitoring-beats-*").privileges("create_index", "create").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)), Map.entry("apm_system", new RoleDescriptor("apm_system", new String[]{"monitor", "cluster:admin/xpack/monitoring/bulk"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".monitoring-beats-*").privileges("create_index", "create_doc").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)), Map.entry("apm_user", new RoleDescriptor("apm_user", null, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("apm-*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("logs-apm.*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("logs-apm-*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("metrics-apm.*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("metrics-apm-*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("traces-apm.*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("traces-apm-*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".ml-anomalies*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("observability-annotations").privileges("read", "view_index_metadata").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_ml_apm_user").build()}, null, null, MetadataUtils.getDeprecatedReservedMetadata("This role will be removed in a future major release. Please use editor and viewer roles instead"), null)), Map.entry("machine_learning_user", new RoleDescriptor("machine_learning_user", new String[]{"monitor_ml"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".ml-anomalies*", ".ml-notifications*").privileges("view_index_metadata", "read").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".ml-annotations*").privileges("view_index_metadata", "read", "write").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_ml_user").build()}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)), Map.entry("machine_learning_admin", new RoleDescriptor("machine_learning_admin", new String[]{"manage_ml"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".ml-anomalies*", ".ml-notifications*", ".ml-state*", ".ml-meta*", ".ml-stats-*").allowRestrictedIndices(true).privileges("view_index_metadata", "read").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".ml-annotations*").privileges("view_index_metadata", "read", "write").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_ml_admin").build()}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)), Map.entry("data_frame_transforms_admin", new RoleDescriptor("data_frame_transforms_admin", new String[]{"manage_data_frame_transforms"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".transform-notifications-*", ".data-frame-notifications-*", ".transform-notifications-read").privileges("view_index_metadata", "read").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_ml_user").build()}, null, null, MetadataUtils.getDeprecatedReservedMetadata("Please use the [transform_admin] role instead"), null)), Map.entry("data_frame_transforms_user", new RoleDescriptor("data_frame_transforms_user", new String[]{"monitor_data_frame_transforms"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".transform-notifications-*", ".data-frame-notifications-*", ".transform-notifications-read").privileges("view_index_metadata", "read").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_ml_user").build()}, null, null, MetadataUtils.getDeprecatedReservedMetadata("Please use the [transform_user] role instead"), null)), Map.entry("transform_admin", new RoleDescriptor("transform_admin", new String[]{"manage_transform"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".transform-notifications-*", ".data-frame-notifications-*", ".transform-notifications-read").privileges("view_index_metadata", "read").build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)), Map.entry("transform_user", new RoleDescriptor("transform_user", new String[]{"monitor_transform"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".transform-notifications-*", ".data-frame-notifications-*", ".transform-notifications-read").privileges("view_index_metadata", "read").build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)), Map.entry("watcher_admin", new RoleDescriptor("watcher_admin", new String[]{"manage_watcher"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".watches", ".triggered_watches", ".watcher-history-*").privileges("read").allowRestrictedIndices(true).build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)), Map.entry("watcher_user", new RoleDescriptor("watcher_user", new String[]{"monitor_watcher"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".watches").privileges("read").allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices(".watcher-history-*").privileges("read").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)), Map.entry("logstash_admin", new RoleDescriptor("logstash_admin", new String[]{"manage_logstash_pipelines"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".logstash*").privileges("create", "delete", "index", "manage", "read").allowRestrictedIndices(true).build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)), Map.entry("rollup_user", new RoleDescriptor("rollup_user", new String[]{"monitor_rollup"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)), Map.entry("rollup_admin", new RoleDescriptor("rollup_admin", new String[]{"manage_rollup"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)), Map.entry("snapshot_user", new RoleDescriptor("snapshot_user", new String[]{"create_snapshot", "cluster:admin/repository/get"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("view_index_metadata").allowRestrictedIndices(true).build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)), Map.entry("enrich_user", new RoleDescriptor("enrich_user", new String[]{"manage_enrich", "manage_ingest_pipelines", "monitor"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".enrich-*").privileges("read", "view_index_metadata").allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices(".enrich-*").privileges("manage", "write").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)), Map.entry("viewer", ReservedRolesStore.buildViewerRoleDescriptor()), Map.entry("editor", ReservedRolesStore.buildEditorRoleDescriptor()));
    }

    private static RoleDescriptor buildViewerRoleDescriptor() {
        return new RoleDescriptor("viewer", new String[0], new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("/~(([.]|ilm-history-).*)/").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices(ALERTS_LEGACY_INDEX, LISTS_INDEX, LISTS_ITEMS_INDEX).privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices(ALERTS_INDEX_ALIAS, PREVIEW_ALERTS_INDEX_ALIAS).privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices(UNIVERSAL_PROFILING_ALIASES, UNIVERSAL_PROFILING_BACKING_INDICES).privileges("read", "view_index_metadata").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-.kibana").resources("*").privileges("read").build()}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null);
    }

    private static RoleDescriptor buildEditorRoleDescriptor() {
        return new RoleDescriptor("editor", new String[0], new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("/~(([.]|ilm-history-).*)/").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("observability-annotations").privileges("read", "view_index_metadata", "write").build(), RoleDescriptor.IndicesPrivileges.builder().indices(ALERTS_LEGACY_INDEX, LISTS_INDEX, LISTS_ITEMS_INDEX).privileges("read", "view_index_metadata", "write", "maintenance").build(), RoleDescriptor.IndicesPrivileges.builder().indices(ALERTS_BACKING_INDEX, ALERTS_INDEX_ALIAS, PREVIEW_ALERTS_BACKING_INDEX_ALIAS, PREVIEW_ALERTS_INDEX_ALIAS).privileges("read", "view_index_metadata", "write", "maintenance").build(), RoleDescriptor.IndicesPrivileges.builder().indices(UNIVERSAL_PROFILING_ALIASES, UNIVERSAL_PROFILING_BACKING_INDICES).privileges("read", "view_index_metadata").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-.kibana").resources("*").privileges("all").build()}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null);
    }

    private static RoleDescriptor kibanaAdminUser(String name, Map<String, Object> metadata) {
        return KibanaOwnedReservedRoleDescriptors.kibanaAdminUser(name, metadata);
    }

    public static RoleDescriptor kibanaSystemRoleDescriptor(String name) {
        return KibanaOwnedReservedRoleDescriptors.kibanaSystem(name);
    }

    public static boolean isReserved(String role) {
        if (RESERVED_ROLES == null) {
            throw new IllegalStateException("ReserveRolesStore is not initialized properly");
        }
        return RESERVED_ROLES.containsKey(role);
    }

    public Map<String, Object> usageStats() {
        return Collections.emptyMap();
    }

    public RoleDescriptor roleDescriptor(String role) {
        return RESERVED_ROLES.get(role);
    }

    public Collection<RoleDescriptor> roleDescriptors() {
        return RESERVED_ROLES.values();
    }

    public static Set<String> names() {
        if (RESERVED_ROLES == null) {
            throw new IllegalStateException("ReserveRolesStore is not initialized properly");
        }
        return RESERVED_ROLES.keySet();
    }

    @Override
    public void accept(Set<String> roleNames, ActionListener<RoleRetrievalResult> listener) {
        Set<RoleDescriptor> descriptors = roleNames.stream().map(RESERVED_ROLES::get).filter(Objects::nonNull).collect(Collectors.toSet());
        listener.onResponse((Object)RoleRetrievalResult.success(descriptors));
    }

    public String toString() {
        return "reserved roles store";
    }
}

