/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.user.InternalUser;
import org.elasticsearch.xpack.core.security.user.User;

public class GetUsersResponse
extends ActionResponse
implements ToXContentObject {
    private final User[] users;
    @Nullable
    private final Map<String, String> profileUidLookup;

    public GetUsersResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        if (size < 0) {
            this.users = null;
        } else {
            this.users = new User[size];
            for (int i = 0; i < size; ++i) {
                User user = Authentication.AuthenticationSerializationHelper.readUserFrom(in);
                assert (!(user instanceof InternalUser)) : "should not get internal user [" + user + "]";
                this.users[i] = user;
            }
        }
        this.profileUidLookup = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_5_0) ? (in.readBoolean() ? in.readMap(StreamInput::readString) : null) : null;
    }

    public GetUsersResponse(Collection<User> users) {
        this(users, null);
    }

    public GetUsersResponse(Collection<User> users, @Nullable Map<String, String> profileUidLookup) {
        this.users = (User[])users.toArray(User[]::new);
        this.profileUidLookup = profileUidLookup;
    }

    public User[] users() {
        return this.users;
    }

    public Map<String, String> getProfileUidLookup() {
        return this.profileUidLookup;
    }

    public boolean hasUsers() {
        return this.users != null && this.users.length > 0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.users == null ? -1 : this.users.length);
        if (this.users != null) {
            for (User user : this.users) {
                Authentication.AuthenticationSerializationHelper.writeUserTo(user, out);
            }
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_5_0)) {
            if (this.profileUidLookup != null) {
                out.writeBoolean(true);
                out.writeMap(this.profileUidLookup, StreamOutput::writeString);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (User user : this.users) {
            String profileUid;
            builder.field(user.principal());
            builder.startObject();
            user.innerToXContent(builder);
            if (this.profileUidLookup != null && (profileUid = this.profileUidLookup.get(user.principal())) != null) {
                builder.field("profile_uid", profileUid);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }
}

