/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.role;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.action.role.RoleDescriptorRequestValidator;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivileges;
import org.elasticsearch.xpack.core.security.support.NativeRealmValidationUtil;
import org.elasticsearch.xpack.core.security.support.Validation;

public class PutRoleRequest
extends ActionRequest
implements WriteRequest<PutRoleRequest> {
    private String name;
    private String[] clusterPrivileges = Strings.EMPTY_ARRAY;
    private ConfigurableClusterPrivilege[] configurableClusterPrivileges = ConfigurableClusterPrivileges.EMPTY_ARRAY;
    private List<RoleDescriptor.IndicesPrivileges> indicesPrivileges = new ArrayList<RoleDescriptor.IndicesPrivileges>();
    private List<RoleDescriptor.ApplicationResourcePrivileges> applicationPrivileges = new ArrayList<RoleDescriptor.ApplicationResourcePrivileges>();
    private String[] runAs = Strings.EMPTY_ARRAY;
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.IMMEDIATE;
    private Map<String, Object> metadata;
    private List<RoleDescriptor.RemoteIndicesPrivileges> remoteIndicesPrivileges = new ArrayList<RoleDescriptor.RemoteIndicesPrivileges>();

    public PutRoleRequest(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
        this.clusterPrivileges = in.readStringArray();
        int indicesSize = in.readVInt();
        this.indicesPrivileges = new ArrayList<RoleDescriptor.IndicesPrivileges>(indicesSize);
        for (int i = 0; i < indicesSize; ++i) {
            this.indicesPrivileges.add(new RoleDescriptor.IndicesPrivileges(in));
        }
        this.applicationPrivileges = in.readCollectionAsList(RoleDescriptor.ApplicationResourcePrivileges::new);
        this.configurableClusterPrivileges = ConfigurableClusterPrivileges.readArray(in);
        this.runAs = in.readStringArray();
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom((StreamInput)in);
        this.metadata = in.readMap();
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_8_0)) {
            this.remoteIndicesPrivileges = in.readCollectionAsList(RoleDescriptor.RemoteIndicesPrivileges::new);
        }
    }

    public PutRoleRequest() {
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        Validation.Error error = NativeRealmValidationUtil.validateRoleName(this.name, false);
        if (error != null) {
            validationException = ValidateActions.addValidationError((String)error.toString(), validationException);
        }
        return RoleDescriptorRequestValidator.validate(this.roleDescriptor(), validationException);
    }

    public void name(String name) {
        this.name = name;
    }

    public void cluster(String ... clusterPrivilegesArray) {
        this.clusterPrivileges = clusterPrivilegesArray;
    }

    public void conditionalCluster(ConfigurableClusterPrivilege ... configurableClusterPrivilegesArray) {
        this.configurableClusterPrivileges = configurableClusterPrivilegesArray;
    }

    public void addIndex(RoleDescriptor.IndicesPrivileges ... privileges) {
        this.indicesPrivileges.addAll(Arrays.asList(privileges));
    }

    public void addRemoteIndex(RoleDescriptor.RemoteIndicesPrivileges ... privileges) {
        this.remoteIndicesPrivileges.addAll(Arrays.asList(privileges));
    }

    public void addRemoteIndex(String[] remoteClusters, String[] indices, String[] privileges, String[] grantedFields, String[] deniedFields, @Nullable BytesReference query, boolean allowRestrictedIndices) {
        this.remoteIndicesPrivileges.add(RoleDescriptor.RemoteIndicesPrivileges.builder(remoteClusters).indices(indices).privileges(privileges).grantedFields(grantedFields).deniedFields(deniedFields).query(query).allowRestrictedIndices(allowRestrictedIndices).build());
    }

    public void addIndex(String[] indices, String[] privileges, String[] grantedFields, String[] deniedFields, @Nullable BytesReference query, boolean allowRestrictedIndices) {
        this.indicesPrivileges.add(RoleDescriptor.IndicesPrivileges.builder().indices(indices).privileges(privileges).grantedFields(grantedFields).deniedFields(deniedFields).query(query).allowRestrictedIndices(allowRestrictedIndices).build());
    }

    public void addApplicationPrivileges(RoleDescriptor.ApplicationResourcePrivileges ... privileges) {
        this.applicationPrivileges.addAll(Arrays.asList(privileges));
    }

    public void runAs(String ... usernames) {
        this.runAs = usernames;
    }

    public PutRoleRequest setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public void metadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public String name() {
        return this.name;
    }

    public String[] cluster() {
        return this.clusterPrivileges;
    }

    public RoleDescriptor.IndicesPrivileges[] indices() {
        return this.indicesPrivileges.toArray(new RoleDescriptor.IndicesPrivileges[this.indicesPrivileges.size()]);
    }

    public RoleDescriptor.RemoteIndicesPrivileges[] remoteIndices() {
        return this.remoteIndicesPrivileges.toArray(new RoleDescriptor.RemoteIndicesPrivileges[0]);
    }

    public boolean hasRemoteIndicesPrivileges() {
        return false == this.remoteIndicesPrivileges.isEmpty();
    }

    public List<RoleDescriptor.ApplicationResourcePrivileges> applicationPrivileges() {
        return Collections.unmodifiableList(this.applicationPrivileges);
    }

    public ConfigurableClusterPrivilege[] conditionalClusterPrivileges() {
        return this.configurableClusterPrivileges;
    }

    public String[] runAs() {
        return this.runAs;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        out.writeStringArray(this.clusterPrivileges);
        out.writeVInt(this.indicesPrivileges.size());
        for (RoleDescriptor.IndicesPrivileges index : this.indicesPrivileges) {
            index.writeTo(out);
        }
        out.writeCollection(this.applicationPrivileges);
        ConfigurableClusterPrivileges.writeArray(out, this.configurableClusterPrivileges);
        out.writeStringArray(this.runAs);
        this.refreshPolicy.writeTo(out);
        out.writeGenericMap(this.metadata);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_8_0)) {
            out.writeCollection(this.remoteIndicesPrivileges);
        } else if (this.hasRemoteIndicesPrivileges()) {
            throw new IllegalArgumentException("versions of Elasticsearch before [" + TransportVersions.V_8_8_0 + "] can't handle remote indices privileges and attempted to send to [" + out.getTransportVersion() + "]");
        }
    }

    public RoleDescriptor roleDescriptor() {
        return new RoleDescriptor(this.name, this.clusterPrivileges, this.indicesPrivileges.toArray(new RoleDescriptor.IndicesPrivileges[this.indicesPrivileges.size()]), this.applicationPrivileges.toArray(new RoleDescriptor.ApplicationResourcePrivileges[this.applicationPrivileges.size()]), this.configurableClusterPrivileges, this.runAs, this.metadata, Collections.emptyMap(), this.remoteIndicesPrivileges.toArray(new RoleDescriptor.RemoteIndicesPrivileges[0]), null);
    }
}

