/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.apikey.CrossClusterApiKeyRoleDescriptorBuilder;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptorsIntersection;

public final class ApiKey
implements ToXContentObject,
Writeable {
    public static final TransportVersion CROSS_CLUSTER_KEY_VERSION = TransportVersions.V_8_500_020;
    private final String name;
    private final String id;
    private final Type type;
    private final Instant creation;
    private final Instant expiration;
    private final boolean invalidated;
    private final String username;
    private final String realm;
    private final Map<String, Object> metadata;
    @Nullable
    private final List<RoleDescriptor> roleDescriptors;
    @Nullable
    private final RoleDescriptorsIntersection limitedBy;
    static final ConstructingObjectParser<ApiKey, Void> PARSER = new ConstructingObjectParser("api_key", true, args -> new ApiKey((String)args[0], (String)args[1], (Type)((Object)((Object)args[2])), Instant.ofEpochMilli((Long)args[3]), args[4] == null ? null : Instant.ofEpochMilli((Long)args[4]), (boolean)((Boolean)args[5]), (String)args[6], (String)args[7], (Map<String, Object>)(args[8] == null ? null : (Map)args[8]), (List<RoleDescriptor>)((List)args[9]), (RoleDescriptorsIntersection)args[10]));

    public ApiKey(String name, String id, Type type, Instant creation, Instant expiration, boolean invalidated, String username, String realm, @Nullable Map<String, Object> metadata, @Nullable List<RoleDescriptor> roleDescriptors, @Nullable List<RoleDescriptor> limitedByRoleDescriptors) {
        this(name, id, type, creation, expiration, invalidated, username, realm, metadata, roleDescriptors, limitedByRoleDescriptors == null ? null : new RoleDescriptorsIntersection(List.of(Set.copyOf(limitedByRoleDescriptors))));
    }

    private ApiKey(String name, String id, Type type, Instant creation, Instant expiration, boolean invalidated, String username, String realm, @Nullable Map<String, Object> metadata, @Nullable List<RoleDescriptor> roleDescriptors, @Nullable RoleDescriptorsIntersection limitedBy) {
        this.name = name;
        this.id = id;
        this.type = type;
        this.creation = Instant.ofEpochMilli(creation.toEpochMilli());
        this.expiration = expiration != null ? Instant.ofEpochMilli(expiration.toEpochMilli()) : null;
        this.invalidated = invalidated;
        this.username = username;
        this.realm = realm;
        this.metadata = metadata == null ? Map.of() : metadata;
        List<RoleDescriptor> list = this.roleDescriptors = roleDescriptors != null ? List.copyOf(roleDescriptors) : null;
        assert (limitedBy == null || limitedBy.roleDescriptorsList().size() == 1) : "can only have one set of limited-by role descriptors";
        this.limitedBy = limitedBy;
    }

    public ApiKey(StreamInput in) throws IOException {
        this.name = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_5_0) ? in.readOptionalString() : in.readString();
        this.id = in.readString();
        this.type = in.getTransportVersion().onOrAfter((VersionId)CROSS_CLUSTER_KEY_VERSION) ? (Type)in.readEnum(Type.class) : Type.REST;
        this.creation = in.readInstant();
        this.expiration = in.readOptionalInstant();
        this.invalidated = in.readBoolean();
        this.username = in.readString();
        this.realm = in.readString();
        this.metadata = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_0_0) ? in.readMap() : Map.of();
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_5_0)) {
            List roleDescriptors = in.readOptionalCollectionAsList(RoleDescriptor::new);
            this.roleDescriptors = roleDescriptors != null ? List.copyOf(roleDescriptors) : null;
            this.limitedBy = (RoleDescriptorsIntersection)in.readOptionalWriteable(RoleDescriptorsIntersection::new);
        } else {
            this.roleDescriptors = null;
            this.limitedBy = null;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Instant getCreation() {
        return this.creation;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRealm() {
        return this.realm;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public List<RoleDescriptor> getRoleDescriptors() {
        return this.roleDescriptors;
    }

    public RoleDescriptorsIntersection getLimitedBy() {
        return this.limitedBy;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        return builder.endObject();
    }

    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("id", this.id).field("name", this.name);
        builder.field("type", this.type.value());
        builder.field("creation", this.creation.toEpochMilli());
        if (this.expiration != null) {
            builder.field("expiration", this.expiration.toEpochMilli());
        }
        builder.field("invalidated", this.invalidated).field("username", this.username).field("realm", this.realm).field("metadata", this.metadata == null ? Map.of() : this.metadata);
        if (this.roleDescriptors != null) {
            builder.startObject("role_descriptors");
            for (RoleDescriptor roleDescriptor : this.roleDescriptors) {
                builder.field(roleDescriptor.getName(), (ToXContent)roleDescriptor);
            }
            builder.endObject();
            if (this.type == Type.CROSS_CLUSTER) {
                assert (this.roleDescriptors.size() == 1);
                this.buildXContentForCrossClusterApiKeyAccess(builder, this.roleDescriptors.iterator().next());
            }
        }
        if (this.limitedBy != null) {
            assert (this.type != Type.CROSS_CLUSTER);
            builder.field("limited_by", (ToXContent)this.limitedBy);
        }
        return builder;
    }

    private void buildXContentForCrossClusterApiKeyAccess(XContentBuilder builder, RoleDescriptor roleDescriptor) throws IOException {
        if (Assertions.ENABLED) {
            CrossClusterApiKeyRoleDescriptorBuilder.validate(roleDescriptor);
        }
        ArrayList<RoleDescriptor.IndicesPrivileges> search = new ArrayList<RoleDescriptor.IndicesPrivileges>();
        ArrayList<RoleDescriptor.IndicesPrivileges> replication = new ArrayList<RoleDescriptor.IndicesPrivileges>();
        for (RoleDescriptor.IndicesPrivileges indicesPrivileges : roleDescriptor.getIndicesPrivileges()) {
            if (Arrays.equals(CrossClusterApiKeyRoleDescriptorBuilder.CCS_INDICES_PRIVILEGE_NAMES, indicesPrivileges.getPrivileges())) {
                search.add(indicesPrivileges);
                continue;
            }
            assert (Arrays.equals(CrossClusterApiKeyRoleDescriptorBuilder.CCR_INDICES_PRIVILEGE_NAMES, indicesPrivileges.getPrivileges()));
            replication.add(indicesPrivileges);
        }
        builder.startObject("access");
        ToXContent.MapParams params = new ToXContent.MapParams(Map.of("_with_privileges", "false"));
        if (!search.isEmpty()) {
            builder.startArray("search");
            for (RoleDescriptor.IndicesPrivileges indicesPrivileges : search) {
                indicesPrivileges.toXContent(builder, (ToXContent.Params)params);
            }
            builder.endArray();
        }
        if (!replication.isEmpty()) {
            builder.startArray("replication");
            for (RoleDescriptor.IndicesPrivileges indicesPrivileges : replication) {
                indicesPrivileges.toXContent(builder, (ToXContent.Params)params);
            }
            builder.endArray();
        }
        builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_5_0)) {
            out.writeOptionalString(this.name);
        } else {
            out.writeString(this.name);
        }
        out.writeString(this.id);
        if (out.getTransportVersion().onOrAfter((VersionId)CROSS_CLUSTER_KEY_VERSION)) {
            out.writeEnum((Enum)this.type);
        }
        out.writeInstant(this.creation);
        out.writeOptionalInstant(this.expiration);
        out.writeBoolean(this.invalidated);
        out.writeString(this.username);
        out.writeString(this.realm);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_0_0)) {
            out.writeGenericMap(this.metadata);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_5_0)) {
            out.writeOptionalCollection(this.roleDescriptors);
            out.writeOptionalWriteable((Writeable)this.limitedBy);
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.id, this.type, this.creation, this.expiration, this.invalidated, this.username, this.realm, this.metadata, this.roleDescriptors, this.limitedBy});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiKey other = (ApiKey)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.creation, other.creation) && Objects.equals(this.expiration, other.expiration) && Objects.equals(this.invalidated, other.invalidated) && Objects.equals(this.username, other.username) && Objects.equals(this.realm, other.realm) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.roleDescriptors, other.roleDescriptors) && Objects.equals(this.limitedBy, other.limitedBy);
    }

    public static ApiKey fromXContent(XContentParser parser) throws IOException {
        return (ApiKey)PARSER.parse(parser, null);
    }

    public String toString() {
        return "ApiKey [name=" + this.name + ", id=" + this.id + ", type=" + this.type.value() + ", creation=" + this.creation + ", expiration=" + this.expiration + ", invalidated=" + this.invalidated + ", username=" + this.username + ", realm=" + this.realm + ", metadata=" + this.metadata + ", role_descriptors=" + this.roleDescriptors + ", limited_by=" + this.limitedBy + "]";
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("id", new String[0]));
        PARSER.declareField(ConstructingObjectParser.constructorArg(), Type::fromXContent, new ParseField("type", new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("creation", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), new ParseField("expiration", new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("invalidated", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("username", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("realm", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField("metadata", new String[0]));
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> {
            p.nextToken();
            return RoleDescriptor.parse(n, p, false);
        }, new ParseField("role_descriptors", new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> RoleDescriptorsIntersection.fromXContent(p), new ParseField("limited_by", new String[0]), ObjectParser.ValueType.OBJECT_ARRAY);
    }

    public static enum Type {
        REST,
        CROSS_CLUSTER;


        public static Type parse(String value) {
            return switch (value.toLowerCase(Locale.ROOT)) {
                case "rest" -> REST;
                case "cross_cluster" -> CROSS_CLUSTER;
                default -> throw new IllegalArgumentException("invalid API key type [" + value + "] expected one of [" + Stream.of(Type.values()).map(Type::value).collect(Collectors.joining(",")) + "]");
            };
        }

        public static Type fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            if (token == null) {
                token = parser.nextToken();
            }
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_STRING, (XContentParser.Token)token, (XContentParser)parser);
            return Type.parse(parser.text());
        }

        public String value() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

