/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action;

import java.io.IOException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.support.BearerToken;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;

public class Grant
implements Writeable {
    public static final String PASSWORD_GRANT_TYPE = "password";
    public static final String ACCESS_TOKEN_GRANT_TYPE = "access_token";
    private String type;
    private String username;
    private SecureString password;
    private SecureString accessToken;
    private String runAsUsername;

    public Grant() {
    }

    public Grant(StreamInput in) throws IOException {
        this.type = in.readString();
        this.username = in.readOptionalString();
        this.password = in.readOptionalSecureString();
        this.accessToken = in.readOptionalSecureString();
        this.runAsUsername = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_4_0) ? in.readOptionalString() : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeOptionalString(this.username);
        out.writeOptionalSecureString(this.password);
        out.writeOptionalSecureString(this.accessToken);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_4_0)) {
            out.writeOptionalString(this.runAsUsername);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getUsername() {
        return this.username;
    }

    public SecureString getPassword() {
        return this.password;
    }

    public SecureString getAccessToken() {
        return this.accessToken;
    }

    public String getRunAsUsername() {
        return this.runAsUsername;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(SecureString password) {
        this.password = password;
    }

    public void setAccessToken(SecureString accessToken) {
        this.accessToken = accessToken;
    }

    public void setRunAsUsername(String runAsUsername) {
        this.runAsUsername = runAsUsername;
    }

    public AuthenticationToken getAuthenticationToken() {
        assert (this.validate(null) == null) : "grant is invalid";
        return switch (this.type) {
            case PASSWORD_GRANT_TYPE -> new UsernamePasswordToken(this.username, this.password);
            case ACCESS_TOKEN_GRANT_TYPE -> new BearerToken(this.accessToken);
            default -> null;
        };
    }

    public ActionRequestValidationException validate(ActionRequestValidationException validationException) {
        if (this.type == null) {
            validationException = ValidateActions.addValidationError((String)"[grant_type] is required", (ActionRequestValidationException)validationException);
        } else if (this.type.equals(PASSWORD_GRANT_TYPE)) {
            validationException = this.validateRequiredField("username", this.username, validationException);
            validationException = this.validateRequiredField(PASSWORD_GRANT_TYPE, (CharSequence)this.password, validationException);
            validationException = this.validateUnsupportedField(ACCESS_TOKEN_GRANT_TYPE, (CharSequence)this.accessToken, validationException);
        } else if (this.type.equals(ACCESS_TOKEN_GRANT_TYPE)) {
            validationException = this.validateRequiredField(ACCESS_TOKEN_GRANT_TYPE, (CharSequence)this.accessToken, validationException);
            validationException = this.validateUnsupportedField("username", this.username, validationException);
            validationException = this.validateUnsupportedField(PASSWORD_GRANT_TYPE, (CharSequence)this.password, validationException);
        } else {
            validationException = ValidateActions.addValidationError((String)("grant_type [" + this.type + "] is not supported"), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    private ActionRequestValidationException validateRequiredField(String fieldName, CharSequence fieldValue, ActionRequestValidationException validationException) {
        if (fieldValue == null || fieldValue.length() == 0) {
            return ValidateActions.addValidationError((String)("[" + fieldName + "] is required for grant_type [" + this.type + "]"), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    private ActionRequestValidationException validateUnsupportedField(String fieldName, CharSequence fieldValue, ActionRequestValidationException validationException) {
        if (fieldValue != null && fieldValue.length() > 0) {
            return ValidateActions.addValidationError((String)("[" + fieldName + "] is not supported for grant_type [" + this.type + "]"), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }
}

