/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.monitoring.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.bulk.BulkRequestParser;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.core.monitoring.action.MonitoringBulkDoc;
import org.elasticsearch.xpack.core.monitoring.action.MonitoringIndex;

public class MonitoringBulkRequest
extends ActionRequest {
    private final List<MonitoringBulkDoc> docs = new ArrayList<MonitoringBulkDoc>();

    public MonitoringBulkRequest() {
    }

    public MonitoringBulkRequest(StreamInput in) throws IOException {
        super(in);
        this.docs.addAll(in.readCollectionAsList(MonitoringBulkDoc::new));
    }

    public Collection<MonitoringBulkDoc> getDocs() {
        return Collections.unmodifiableCollection(new ArrayList<MonitoringBulkDoc>(this.docs));
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.docs.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"no monitoring documents added", validationException);
        }
        for (int i = 0; i < this.docs.size(); ++i) {
            MonitoringBulkDoc doc = this.docs.get(i);
            if (doc.getSource() != null && doc.getSource().length() != 0) continue;
            validationException = ValidateActions.addValidationError((String)("source is missing for monitoring document [" + i + "]"), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public MonitoringBulkRequest add(MonitoringBulkDoc doc) {
        this.docs.add(doc);
        return this;
    }

    public MonitoringBulkRequest add(MonitoredSystem system, BytesReference content, XContentType xContentType, long timestamp, long intervalMillis) throws IOException {
        new BulkRequestParser(false, RestApiVersion.current()).parse(content, null, null, null, null, null, true, xContentType, (indexRequest, type) -> {
            if (MonitoringIndex.from(indexRequest.index()) != MonitoringIndex.TIMESTAMPED) {
                return;
            }
            BytesReference source = indexRequest.source();
            if (source.length() == 0) {
                throw new IllegalArgumentException("source is missing for monitoring document [" + indexRequest.index() + "][" + type + "][" + indexRequest.id() + "]");
            }
            this.add(new MonitoringBulkDoc(system, (String)type, indexRequest.id(), timestamp, intervalMillis, source, xContentType));
        }, updateRequest -> {
            throw new IllegalArgumentException("monitoring bulk requests should only contain index requests");
        }, deleteRequest -> {
            throw new IllegalArgumentException("monitoring bulk requests should only contain index requests");
        });
        return this;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeCollection(this.docs);
    }
}

