/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel.ltr;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ltr.LearnToRankFeatureExtractorBuilder;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.QueryProvider;

public record QueryExtractorBuilder(String featureName, QueryProvider query) implements LearnToRankFeatureExtractorBuilder
{
    public static final ParseField NAME = new ParseField("query_extractor", new String[0]);
    public static final ParseField FEATURE_NAME = new ParseField("feature_name", new String[0]);
    public static final ParseField QUERY = new ParseField("query", new String[0]);
    private static final ConstructingObjectParser<QueryExtractorBuilder, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), a -> new QueryExtractorBuilder((String)a[0], (QueryProvider)a[1]));
    private static final ConstructingObjectParser<QueryExtractorBuilder, Void> LENIENT_PARSER = new ConstructingObjectParser(NAME.getPreferredName(), true, a -> new QueryExtractorBuilder((String)a[0], (QueryProvider)a[1]));

    public QueryExtractorBuilder(String featureName, QueryProvider query) {
        this.featureName = ExceptionsHelper.requireNonNull(featureName, FEATURE_NAME);
        this.query = ExceptionsHelper.requireNonNull(query, QUERY);
    }

    public QueryExtractorBuilder(StreamInput input) throws IOException {
        this(input.readString(), QueryProvider.fromStream(input));
    }

    public static QueryExtractorBuilder fromXContent(XContentParser parser, Object context) {
        boolean lenient = Boolean.TRUE.equals(context);
        return lenient ? (QueryExtractorBuilder)LENIENT_PARSER.apply(parser, null) : (QueryExtractorBuilder)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FEATURE_NAME.getPreferredName(), this.featureName);
        builder.field(QUERY.getPreferredName(), this.query.getQuery());
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.featureName);
        this.query.writeTo(out);
    }

    @Override
    public void validate() throws Exception {
        if (this.query.getParsingException() != null) {
            throw this.query.getParsingException();
        }
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    public QueryExtractorBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        QueryProvider rewritten = (QueryProvider)Rewriteable.rewrite((Rewriteable)this.query, (QueryRewriteContext)ctx);
        if (rewritten == this.query) {
            return this;
        }
        return new QueryExtractorBuilder(this.featureName, rewritten);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FEATURE_NAME);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> QueryProvider.fromXContent(p, false, "Inference config query is not parsable"), QUERY);
        LENIENT_PARSER.declareString(ConstructingObjectParser.constructorArg(), FEATURE_NAME);
        LENIENT_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> QueryProvider.fromXContent(p, true, "Inference config query is not parsable"), QUERY);
    }
}

