/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.LearnToRankConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ltr.LearnToRankFeatureExtractorBuilder;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public class LearnToRankConfigUpdate
implements InferenceConfigUpdate,
NamedXContentObject,
Rewriteable<LearnToRankConfigUpdate> {
    public static final ParseField NAME = LearnToRankConfig.NAME;
    public static LearnToRankConfigUpdate EMPTY_PARAMS = new LearnToRankConfigUpdate(null, null);
    private static final ObjectParser<Builder, Void> STRICT_PARSER = LearnToRankConfigUpdate.createParser(false);
    private final Integer numTopFeatureImportanceValues;
    private final List<LearnToRankFeatureExtractorBuilder> featureExtractorBuilderList;

    public static LearnToRankConfigUpdate fromConfig(LearnToRankConfig config) {
        return new LearnToRankConfigUpdate(config.getNumTopFeatureImportanceValues(), config.getFeatureExtractorBuilders());
    }

    private static ObjectParser<Builder, Void> createParser(boolean lenient) {
        ObjectParser parser = new ObjectParser(NAME.getPreferredName(), lenient, Builder::new);
        parser.declareInt(Builder::setNumTopFeatureImportanceValues, LearnToRankConfig.NUM_TOP_FEATURE_IMPORTANCE_VALUES);
        parser.declareNamedObjects(Builder::setFeatureExtractorBuilders, (p, c, n) -> (LearnToRankFeatureExtractorBuilder)p.namedObject(LearnToRankFeatureExtractorBuilder.class, n, (Object)false), b -> {}, LearnToRankConfig.FEATURE_EXTRACTORS);
        return parser;
    }

    public static LearnToRankConfigUpdate fromXContentStrict(XContentParser parser) {
        return ((Builder)STRICT_PARSER.apply(parser, null)).build();
    }

    public LearnToRankConfigUpdate(Integer numTopFeatureImportanceValues, List<LearnToRankFeatureExtractorBuilder> featureExtractorBuilders) {
        Set featureNames;
        if (numTopFeatureImportanceValues != null && numTopFeatureImportanceValues < 0) {
            throw new IllegalArgumentException("[" + LearnToRankConfig.NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName() + "] must be greater than or equal to 0");
        }
        if (featureExtractorBuilders != null && (featureNames = featureExtractorBuilders.stream().map(LearnToRankFeatureExtractorBuilder::featureName).collect(Collectors.toSet())).size() < featureExtractorBuilders.size()) {
            throw new IllegalArgumentException("[" + LearnToRankConfig.FEATURE_EXTRACTORS.getPreferredName() + "] contains duplicate [feature_name] values");
        }
        this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
        this.featureExtractorBuilderList = featureExtractorBuilders == null ? List.of() : featureExtractorBuilders;
    }

    public LearnToRankConfigUpdate(StreamInput in) throws IOException {
        this.numTopFeatureImportanceValues = in.readOptionalVInt();
        this.featureExtractorBuilderList = in.readNamedWriteableCollectionAsList(LearnToRankFeatureExtractorBuilder.class);
    }

    public Integer getNumTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    @Override
    public String getResultsField() {
        return "predicted_value";
    }

    @Override
    public InferenceConfigUpdate.Builder<? extends InferenceConfigUpdate.Builder<?, ?>, ? extends InferenceConfigUpdate> newBuilder() {
        return new Builder().setNumTopFeatureImportanceValues(this.numTopFeatureImportanceValues);
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalVInt(this.numTopFeatureImportanceValues);
        out.writeNamedWriteableCollection(this.featureExtractorBuilderList);
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    public TransportVersion getMinimalSupportedVersion() {
        return LearnToRankConfig.MIN_SUPPORTED_TRANSPORT_VERSION;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.numTopFeatureImportanceValues != null) {
            builder.field(LearnToRankConfig.NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName(), this.numTopFeatureImportanceValues);
        }
        if (!this.featureExtractorBuilderList.isEmpty()) {
            NamedXContentObjectHelper.writeNamedObjects(builder, params, true, LearnToRankConfig.FEATURE_EXTRACTORS.getPreferredName(), this.featureExtractorBuilderList);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LearnToRankConfigUpdate that = (LearnToRankConfigUpdate)o;
        return Objects.equals(this.numTopFeatureImportanceValues, that.numTopFeatureImportanceValues) && Objects.equals(this.featureExtractorBuilderList, that.featureExtractorBuilderList);
    }

    public int hashCode() {
        return Objects.hash(this.numTopFeatureImportanceValues, this.featureExtractorBuilderList);
    }

    @Override
    public LearnToRankConfig apply(InferenceConfig originalConfig) {
        if (!(originalConfig instanceof LearnToRankConfig)) {
            throw ExceptionsHelper.badRequestException("Inference config of type [{}] can not be updated with a inference request of type [{}]", originalConfig.getName(), this.getName());
        }
        LearnToRankConfig ltrConfig = (LearnToRankConfig)originalConfig;
        if (this.isNoop(ltrConfig)) {
            return ltrConfig;
        }
        LearnToRankConfig.Builder builder = new LearnToRankConfig.Builder(ltrConfig);
        if (this.numTopFeatureImportanceValues != null) {
            builder.setNumTopFeatureImportanceValues(this.numTopFeatureImportanceValues);
        }
        if (!this.featureExtractorBuilderList.isEmpty()) {
            Map<String, LearnToRankFeatureExtractorBuilder> existingExtractors = ltrConfig.getFeatureExtractorBuilders().stream().collect(Collectors.toMap(LearnToRankFeatureExtractorBuilder::featureName, f -> f));
            this.featureExtractorBuilderList.forEach(f -> existingExtractors.put(f.featureName(), (LearnToRankFeatureExtractorBuilder)f));
            builder.setLearnToRankFeatureExtractorBuilders(new ArrayList<LearnToRankFeatureExtractorBuilder>(existingExtractors.values()));
        }
        return builder.build();
    }

    @Override
    public boolean isSupported(InferenceConfig inferenceConfig) {
        return inferenceConfig instanceof LearnToRankConfig;
    }

    boolean isNoop(LearnToRankConfig originalConfig) {
        return !(this.numTopFeatureImportanceValues != null && originalConfig.getNumTopFeatureImportanceValues() != this.numTopFeatureImportanceValues.intValue() || !this.featureExtractorBuilderList.isEmpty() && !Objects.equals(originalConfig.getFeatureExtractorBuilders(), this.featureExtractorBuilderList));
    }

    public LearnToRankConfigUpdate rewrite(QueryRewriteContext ctx) throws IOException {
        if (this.featureExtractorBuilderList.isEmpty()) {
            return this;
        }
        ArrayList<LearnToRankFeatureExtractorBuilder> rewrittenBuilders = new ArrayList<LearnToRankFeatureExtractorBuilder>(this.featureExtractorBuilderList.size());
        boolean rewritten = false;
        for (LearnToRankFeatureExtractorBuilder extractorBuilder : this.featureExtractorBuilderList) {
            LearnToRankFeatureExtractorBuilder rewrittenExtractor = (LearnToRankFeatureExtractorBuilder)Rewriteable.rewrite((Rewriteable)extractorBuilder, (QueryRewriteContext)ctx);
            rewritten |= rewrittenExtractor != extractorBuilder;
            rewrittenBuilders.add(rewrittenExtractor);
        }
        if (rewritten) {
            return new LearnToRankConfigUpdate(this.getNumTopFeatureImportanceValues(), rewrittenBuilders);
        }
        return this;
    }

    public static class Builder
    implements InferenceConfigUpdate.Builder<Builder, LearnToRankConfigUpdate> {
        private Integer numTopFeatureImportanceValues;
        private List<LearnToRankFeatureExtractorBuilder> featureExtractorBuilderList;

        @Override
        public Builder setResultsField(String resultsField) {
            assert (false) : "results field should never be set in ltr config";
            return this;
        }

        public Builder setNumTopFeatureImportanceValues(Integer numTopFeatureImportanceValues) {
            this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
            return this;
        }

        public Builder setFeatureExtractorBuilders(List<LearnToRankFeatureExtractorBuilder> featureExtractorBuilderList) {
            this.featureExtractorBuilderList = featureExtractorBuilderList;
            return this;
        }

        @Override
        public LearnToRankConfigUpdate build() {
            return new LearnToRankConfigUpdate(this.numTopFeatureImportanceValues, this.featureExtractorBuilderList);
        }
    }
}

