/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.Evaluation;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationFields;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.MlEvaluationNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression.Huber;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression.MeanSquaredError;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression.RSquared;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class Regression
implements Evaluation {
    public static final ParseField NAME = new ParseField("regression", new String[0]);
    private static final ParseField METRICS = new ParseField("metrics", new String[0]);
    public static final ConstructingObjectParser<Regression, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), a -> new Regression((String)a[0], (String)a[1], (List)a[2]));
    private final EvaluationFields fields;
    private final List<EvaluationMetric> metrics;

    public static Regression fromXContent(XContentParser parser) {
        return (Regression)PARSER.apply(parser, null);
    }

    public Regression(String actualField, String predictedField, @Nullable List<EvaluationMetric> metrics) {
        this.fields = new EvaluationFields(ExceptionsHelper.requireNonNull(actualField, EvaluationFields.ACTUAL_FIELD), ExceptionsHelper.requireNonNull(predictedField, EvaluationFields.PREDICTED_FIELD), null, null, null, false);
        this.metrics = this.initMetrics(metrics, Regression::defaultMetrics);
    }

    private static List<EvaluationMetric> defaultMetrics() {
        return Arrays.asList(new MeanSquaredError(), new RSquared(), new Huber());
    }

    public Regression(StreamInput in) throws IOException {
        this.fields = new EvaluationFields(in.readString(), in.readString(), null, null, null, false);
        this.metrics = in.readNamedWriteableCollectionAsList(EvaluationMetric.class);
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public EvaluationFields getFields() {
        return this.fields;
    }

    public List<EvaluationMetric> getMetrics() {
        return this.metrics;
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fields.getActualField());
        out.writeString(this.fields.getPredictedField());
        out.writeNamedWriteableCollection(this.metrics);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(EvaluationFields.ACTUAL_FIELD.getPreferredName(), this.fields.getActualField());
        builder.field(EvaluationFields.PREDICTED_FIELD.getPreferredName(), this.fields.getPredictedField());
        builder.startObject(METRICS.getPreferredName());
        for (EvaluationMetric metric : this.metrics) {
            builder.field(metric.getName(), (ToXContent)metric);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Regression that = (Regression)o;
        return Objects.equals(that.fields, this.fields) && Objects.equals(that.metrics, this.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.metrics);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), EvaluationFields.ACTUAL_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), EvaluationFields.PREDICTED_FIELD);
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> (EvaluationMetric)p.namedObject(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(NAME.getPreferredName(), n), c), METRICS);
    }
}

